/*
 * Decompiled with CFR 0.152.
 */
package com.fiskmods.lightsabers.common.generator;

import com.fiskmods.lightsabers.common.block.BlockCrystalGen;
import com.fiskmods.lightsabers.common.block.ModBlocks;
import com.fiskmods.lightsabers.common.generator.WorldGenCrystalCaveEntrance;
import com.google.common.collect.Lists;
import cpw.mods.fml.common.IWorldGenerator;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;

public enum WorldGeneratorOres implements IWorldGenerator
{
    INSTANCE;

    private WorldGenCrystalCaveEntrance entrance = new WorldGenCrystalCaveEntrance(32);

    public void generate(Random rand, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        switch (world.field_73011_w.field_76574_g) {
            case 0: {
                this.generateOverworld(world, rand, chunkX * 16, chunkZ * 16);
            }
        }
    }

    public boolean isCrystalCaveChunk(World world, int x, int z) {
        Random rand = new Random(world.func_72905_C() + (long)(x * x * 4987142) + (long)(x * 5947611) + (long)(z * z) * 4392871L + (long)(z * 389711) ^ 0x3AD8025FL);
        return rand.nextInt(33) == 0;
    }

    public boolean isCrystalCaveChunk(World world, Chunk chunk) {
        return this.isCrystalCaveChunk(world, chunk.field_76635_g, chunk.field_76647_h);
    }

    public void generateOverworld(World world, Random rand, int x, int z) {
        Chunk chunk;
        if (world.func_72912_H().func_76067_t() != WorldType.field_77138_c && this.isCrystalCaveChunk(world, chunk = world.func_72938_d(x, z)) && world.func_72807_a(x, z) != BiomeGenBase.field_76771_b) {
            ArrayList airBlocks = Lists.newArrayList();
            for (int i = 0; i < 16; ++i) {
                for (int j = 0; j < 16; ++j) {
                    int topBlock;
                    for (topBlock = 128; world.func_147439_a(x + i, topBlock, z + j) == Blocks.field_150350_a && topBlock > 0; --topBlock) {
                    }
                    for (int y = 0; y < topBlock - 10; ++y) {
                        if (world.func_147439_a(x + i, y, z + j) != Blocks.field_150350_a) continue;
                        airBlocks.add(new int[]{x + i, y, z + j});
                    }
                }
            }
            if (airBlocks.size() > 1024) {
                int[] aint = (int[])airBlocks.get(rand.nextInt(airBlocks.size()));
                int x1 = aint[0];
                int y1 = aint[1];
                int z1 = aint[2];
                int count = 0;
                while (y1 < world.func_72825_h(x1, z1)) {
                    if (count < 10 + rand.nextInt(10)) {
                        ++y1;
                    } else {
                        if (rand.nextInt(3) == 0) {
                            x1 += (rand.nextInt(3) - 1) * 2;
                        }
                        if (rand.nextInt(9) == 0) {
                            ++y1;
                        }
                        if (rand.nextInt(3) == 0) {
                            z1 += (rand.nextInt(3) - 1) * 2;
                        }
                    }
                    this.entrance.func_76484_a(world, rand, x1, y1, z1);
                    ++count;
                }
                int radius = 1;
                for (int i = -radius; i <= radius; ++i) {
                    for (int j = -radius; j <= radius; ++j) {
                        this.generateCrystal(100, ModBlocks.lightsaberCrystal, 64, world, rand, x + i * 16, z + j * 16);
                    }
                }
            }
        }
    }

    public void generateCrystal(int attempts, Block block, int minY, World world, Random rand, int chunkX, int chunkZ) {
        for (int i = 0; i < attempts; ++i) {
            int z;
            int y;
            int x = chunkX + rand.nextInt(16);
            if (world.func_147439_a(x, y = rand.nextInt(minY), z = chunkZ + rand.nextInt(16)) != Blocks.field_150350_a) continue;
            BlockCrystalGen.replace(world, x, y, z);
        }
    }
}

