/*
 * Decompiled with CFR 0.152.
 */
package com.fiskmods.lightsabers.common.generator;

import com.fiskmods.lightsabers.common.generator.structure.EnumStructure;
import cpw.mods.fml.common.IWorldGenerator;
import java.util.Random;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.storage.WorldInfo;

public enum WorldGeneratorStructures implements IWorldGenerator
{
    INSTANCE;


    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        switch (world.field_73011_w.field_76574_g) {
            case 0: {
                this.generateOverworld(world, random, chunkX * 16 + 8, chunkZ * 16 + 8);
                break;
            }
            case -1: {
                this.generateNether(world, random, chunkX * 16 + 8, chunkZ * 16 + 8);
            }
        }
    }

    public static Random getRandomForCoords(World world, int x, int z) {
        return new Random((long)x * 341873128712L + (long)z * 132897987541L + world.func_72905_C() + 235785655L);
    }

    public static boolean canSpawnStructureAtCoords(World world, int x, int z, EnumStructure structure) {
        int xOriginal = x;
        int zOriginal = z;
        if (x < 0) {
            x -= structure.maxDistance - 1;
        }
        if (z < 0) {
            z -= structure.maxDistance - 1;
        }
        int x2 = x / structure.maxDistance;
        int z2 = z / structure.maxDistance;
        Random random = WorldGeneratorStructures.getRandomForCoords(world, x2, z2);
        x2 *= structure.maxDistance;
        z2 *= structure.maxDistance;
        if (xOriginal == (x2 += random.nextInt(structure.maxDistance - structure.minDistance)) && zOriginal == (z2 += random.nextInt(structure.maxDistance - structure.minDistance))) {
            return structure.biomePredicate.apply((Object)world.func_72959_q().func_76935_a(xOriginal, zOriginal));
        }
        return false;
    }

    public static void generateStructure(World world, int x, int z, EnumStructure structure) throws Exception {
        Random rand = WorldGeneratorStructures.getRandomForCoords(world, x, z);
        int y = Math.max(world.func_72825_h(x, z), world.field_73011_w.func_76557_i());
        structure.construct(world, x, y, z, rand).spawnStructure(rand);
    }

    public void generateOverworld(World world, Random random, int x, int z) {
        WorldInfo info = world.func_72912_H();
        if (info.func_76067_t() != WorldType.field_77138_c && info.func_76089_r()) {
            for (EnumStructure enumStructure : EnumStructure.values()) {
                if (!WorldGeneratorStructures.canSpawnStructureAtCoords(world, x, z, enumStructure)) continue;
                try {
                    WorldGeneratorStructures.generateStructure(world, x, z, enumStructure);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void generateNether(World world, Random random, int chunkX, int chunkZ) {
    }
}

