/*
 * Decompiled with CFR 0.152.
 */
package com.fiskmods.lightsabers.common.generator.structure;

import com.fiskmods.lightsabers.common.generator.structure.Structure;
import com.fiskmods.lightsabers.common.generator.structure.StructureJediTemple;
import com.fiskmods.lightsabers.common.generator.structure.StructureSithTomb;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public enum EnumStructure {
    SITH_TOMB(new Constructor(){

        @Override
        public Structure construct(World world, int x, int y, int z, Random rand) {
            return new StructureSithTomb(world, x, y, z);
        }
    }, 8, 32, BiomeGenBase.field_76769_d, BiomeGenBase.field_76786_s, BiomeGenBase.field_150589_Z, BiomeGenBase.field_150608_ab, BiomeGenBase.field_150607_aa),
    JEDI_TEMPLE(new Constructor(){

        @Override
        public Structure construct(World world, int x, int y, int z, Random rand) {
            return new StructureJediTemple(0.0f, world, x, y, z);
        }
    }, 24, 64, new TemplePredicate());

    public final Predicate<BiomeGenBase> biomePredicate;
    private final Constructor constructor;
    public int minDistance;
    public int maxDistance;

    private EnumStructure(Constructor c, int min, int max, Predicate<BiomeGenBase> predicate) {
        this.biomePredicate = predicate;
        this.minDistance = min;
        this.maxDistance = max;
        this.constructor = c;
    }

    private EnumStructure(Constructor c, int min, int max, final BiomeGenBase ... biomes) {
        this(c, min, max, new Predicate<BiomeGenBase>(){
            List<BiomeGenBase> biomeList;
            {
                this.biomeList = Lists.newArrayList((Object[])biomes);
            }

            public boolean apply(BiomeGenBase biome) {
                return this.biomeList.contains(biome);
            }
        });
    }

    public Structure construct(World world, int x, int y, int z, Random rand) {
        return this.constructor.construct(world, x, y, z, rand);
    }

    private static class TemplePredicate
    implements Predicate<BiomeGenBase> {
        private TemplePredicate() {
        }

        public boolean apply(BiomeGenBase biome) {
            return biome.field_76748_D > 0.0f && biome.field_76750_F < 1.5f;
        }
    }

    private static interface Constructor {
        public Structure construct(World var1, int var2, int var3, int var4, Random var5);
    }
}

