/*
 * Decompiled with CFR 0.152.
 */
package com.fiskmods.lightsabers.common.generator.structure;

import com.fiskmods.lightsabers.common.generator.structure.StructureHelper;
import com.fiskmods.lightsabers.common.generator.structure.StructurePoint;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;

public abstract class Structure {
    protected final World worldObj;
    protected int xCoord;
    protected int yCoord;
    protected int zCoord;
    protected boolean mirrorX;
    protected boolean mirrorZ;
    protected int maxY;
    protected boolean simulate = false;
    protected List<StructurePoint> coverage = Lists.newArrayList();

    public Structure(World world, int x, int y, int z) {
        this.worldObj = world;
        this.xCoord = x;
        this.yCoord = y;
        this.zCoord = z;
    }

    public abstract void spawnStructure(Random var1);

    public void setBlock(Block block, int metadata, int x, int y, int z) {
        if (this.mirrorX && x > 0) {
            this.setBlock(this.xCoord - x, this.yCoord + y, this.zCoord + z, block, StructureHelper.mirrorMetadata(block, metadata));
        }
        if (this.mirrorZ && z > 0) {
            this.setBlock(this.xCoord + x, this.yCoord + y, this.zCoord - z, block, StructureHelper.mirrorMetadata(block, metadata));
        }
        this.setBlock(this.xCoord + x, this.yCoord + y, this.zCoord + z, block, metadata);
    }

    private void setBlock(int x, int y, int z, Block block, int metadata) {
        Block block1 = null;
        if (this.simulate || ((block1 = this.worldObj.func_147439_a(x, y, z)) != block || this.worldObj.func_72805_g(x, y, z) != metadata) && block1.func_149712_f(this.worldObj, x, y, z) != -1.0f) {
            if (this.simulate) {
                this.maxY = Math.max(this.maxY, y);
                StructurePoint p = new StructurePoint(x, y, z);
                if (this.coverage.contains((Object)p)) {
                    for (int i = 0; i < this.coverage.size(); ++i) {
                        StructurePoint p1 = this.coverage.get(i);
                        if (!p.equals((Object)p1)) continue;
                        p1.field_71572_b = Math.min(p1.field_71572_b, y);
                        break;
                    }
                } else {
                    this.coverage.add(p);
                }
            } else {
                this.placeBlock(x, y, z, block, metadata, 2);
            }
        }
    }

    public void placeBlock(int x, int y, int z, Block block, int metadata, int flags) {
        this.worldObj.func_147465_d(x, y, z, block, metadata, flags);
    }

    protected boolean generateStructureChestContents(Random random, int x, int y, int z, WeightedRandomChestContent[] chestContent, int itemsToGenerate) {
        int i = this.xCoord + x;
        int j = this.yCoord + y;
        int k = this.zCoord + z;
        if (this.worldObj.func_147439_a(i, j, k) != Blocks.field_150486_ae) {
            this.worldObj.func_147465_d(i, j, k, (Block)Blocks.field_150486_ae, 0, 2);
            TileEntityChest tile = (TileEntityChest)this.worldObj.func_147438_o(i, j, k);
            if (tile != null) {
                WeightedRandomChestContent.func_76293_a((Random)random, (WeightedRandomChestContent[])chestContent, (IInventory)tile, (int)itemsToGenerate);
            }
            return true;
        }
        return false;
    }

    protected boolean fillStructureInventory(Block block, Random random, int x, int y, int z, WeightedRandomChestContent[] chestContent, int itemsToGenerate) {
        int i = this.xCoord + x;
        int j = this.yCoord + y;
        int k = this.zCoord + z;
        if (this.worldObj.func_147439_a(i, j, k) == block) {
            IInventory inventory = (IInventory)this.worldObj.func_147438_o(i, j, k);
            if (inventory != null) {
                WeightedRandomChestContent.func_76293_a((Random)random, (WeightedRandomChestContent[])chestContent, (IInventory)inventory, (int)itemsToGenerate);
            }
            return true;
        }
        return false;
    }
}

