/*
 * Decompiled with CFR 0.152.
 */
package com.fiskmods.lightsabers.common.generator.structure;

import com.fiskmods.lightsabers.common.block.ModBlocks;
import com.fiskmods.lightsabers.common.generator.structure.Structure;
import com.fiskmods.lightsabers.common.generator.structure.StructurePoint;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.common.util.ForgeDirection;

public class StructureJediTemple
extends Structure {
    private final float ruination;
    private Random rand;

    public StructureJediTemple(float ruin, World world, int x, int y, int z) {
        super(world, x, y, z);
        this.ruination = ruin;
    }

    @Override
    public void placeBlock(int x, int y, int z, Block block, int metadata, int flags) {
        if (this.ruination > 0.0f) {
            if (block == Blocks.field_150362_t || block == Blocks.field_150355_j) {
                return;
            }
            if (block.func_149688_o() == Material.field_151592_s && this.rand.nextFloat() * this.rand.nextFloat() <= this.ruination) {
                return;
            }
            if (block == ModBlocks.lightForcestone && metadata == 0 && this.rand.nextFloat() < this.ruination) {
                if (this.rand.nextBoolean()) {
                    super.placeBlock(x, y, z, (Block)ModBlocks.forcestoneSlab, this.rand.nextBoolean() ? 0 : 8, flags);
                } else {
                    super.placeBlock(x, y, z, ModBlocks.lightForcestoneStairs, this.rand.nextInt(8), flags);
                }
            } else if (block == ModBlocks.lightForcestoneStairs && this.rand.nextFloat() < this.ruination) {
                super.placeBlock(x, y, z, (Block)ModBlocks.forcestoneSlab, (metadata & 4) == 0 ? 0 : 8, flags);
            } else if (block == Blocks.field_150344_f && metadata == 4 && this.rand.nextFloat() < this.ruination) {
                if (this.rand.nextBoolean()) {
                    super.placeBlock(x, y, z, (Block)Blocks.field_150376_bx, this.rand.nextBoolean() ? 4 : 12, flags);
                } else {
                    super.placeBlock(x, y, z, Blocks.field_150400_ck, this.rand.nextInt(8), flags);
                }
            } else if (block == Blocks.field_150355_j || block == Blocks.field_150406_ce || block.hasTileEntity(metadata) || this.rand.nextFloat() * 4.0f >= this.ruination * this.ruination) {
                super.placeBlock(x, y, z, block, metadata, flags);
            }
        } else {
            super.placeBlock(x, y, z, block, metadata, flags);
        }
    }

    @Override
    public void spawnStructure(Random random) {
        BiomeGenBase biome = this.worldObj.func_72807_a(this.xCoord, this.zCoord);
        Block topBlock = biome.field_76752_A;
        Block fillerBlock = biome.field_76753_B;
        int topBlockMeta = biome.field_150604_aj;
        this.mirrorX = true;
        this.rand = random;
        for (int layer = 0; layer < 2; ++layer) {
            int j;
            int i;
            this.simulate = layer == 0;
            this.setBlock(Blocks.field_150344_f, 4, 5, 0, 13);
            this.setBlock(Blocks.field_150344_f, 4, 5, 0, 21);
            this.setBlock(ModBlocks.lightForcestoneStairs, 2, 3, 8, 7);
            this.setBlock(ModBlocks.lightForcestone, 0, 2, 1, 26);
            this.setBlock((Block)ModBlocks.forcestoneSlab, 0, 2, 3, 26);
            this.setBlock(ModBlocks.lightForcestone, 0, 2, 3, 28);
            for (i = 0; i < 2; ++i) {
                this.setBlock(ModBlocks.lightForcestone, 0, i, 0, 3);
                this.setBlock(ModBlocks.lightForcestoneStairs, 1, 2 + i, 0, 3 + i);
                this.setBlock(ModBlocks.lightForcestoneStairs, 2, 3 + i, 0, 3 + i);
                this.setBlock((Block)ModBlocks.forcestoneSlab, 0, 3 + i, 0, 2 + i);
                this.setBlock(ModBlocks.lightForcestone, 0, i, 5, 7);
                this.setBlock(Blocks.field_150344_f, 4, 4 + i, 0, 12);
                this.setBlock(Blocks.field_150344_f, 4, 4 + i, 0, 22);
                this.setBlock((Block)ModBlocks.forcestoneSlab, 0, 3 + i, 1, 24);
                this.setBlock(ModBlocks.lightForcestoneStairs, 2, 2, 3 + i, 27 + i);
                this.setBlock(ModBlocks.lightForcestone, 4, 2, 1, 27 + i);
                this.setBlock(ModBlocks.lightForcestone, 0, 3 + i, 3, 29);
                this.setBlock((Block)ModBlocks.forcestoneSlab, 0, i, 5, 29);
                this.setBlock(ModBlocks.lightForcestoneStairs, 2, i, 4, 31);
                for (j = 0; j < 2; ++j) {
                    this.setBlock(ModBlocks.lightForcestone, 0, 3 + i, 2, 28 + j);
                    this.setBlock((Block)ModBlocks.forcestoneSlab, 0, i, 4, 29 + j);
                }
                for (j = 0; j < 3; ++j) {
                    this.setBlock((Block)Blocks.field_150397_co, 3, i, 6 + j, 7);
                    this.setBlock(ModBlocks.lightForcestone, 0, 3 + i, 1, 27 + j);
                }
            }
            for (i = 0; i < 3; ++i) {
                this.setBlock(ModBlocks.lightForcestone, 0, i, 0, 4);
                this.setBlock(ModBlocks.lightForcestone, 1, i, 4, 7);
                this.setBlock(ModBlocks.lightForcestoneStairs, 2, i, 0, 2);
                this.setBlock(ModBlocks.lightForcestoneStairs, 1, 4, 0, 5 + i);
                this.setBlock((Block)ModBlocks.forcestoneSlab, 0, i, 0, 1);
                this.setBlock(ModBlocks.lightActivatedForcestone, 0, 3, 1 + i, 7);
                this.setBlock((Block)Blocks.field_150397_co, 3, 2, 1 + i, 7);
                this.setBlock((Block)Blocks.field_150397_co, 3, 0, 9 + i, 7);
                this.setBlock(Blocks.field_150344_f, 4, 3 + i, 0, 11);
                this.setBlock(Blocks.field_150344_f, 4, 2 + i, 0, 23);
                this.setBlock((Block)ModBlocks.forcestoneSlab, 0, 2 + i, 1, 25);
                this.setBlock(ModBlocks.lightForcestone, 1, 2, 2, 26 + i);
            }
            for (i = 0; i < 4; ++i) {
                this.setBlock(ModBlocks.lightForcestone, 0, 3, 4 + i, 7);
                this.setBlock(ModBlocks.lightForcestone, 0, 2, 5 + i, 7);
                this.setBlock(ModBlocks.lightActivatedForcestone, 0, 6, 1 + i, 11);
                this.setBlock(ModBlocks.lightActivatedForcestone, 0, 6, 1 + i, 22);
                for (j = 0; j < 2; ++j) {
                    this.setBlock(ModBlocks.lightForcestoneStairs, 2, 3 + j, 1 + i, 26 + i);
                }
                for (j = 0; j < 3; ++j) {
                    this.setBlock(ModBlocks.lightForcestone, 0, i, 0, 5 + j);
                    this.setBlock(ModBlocks.lightForcestone, 0, 2 + j, 0, 26 + i);
                }
            }
            for (i = 0; i < 5; ++i) {
                this.setBlock((Block)ModBlocks.forcestoneSlab, 0, 5, 0, 4 + i);
                this.setBlock(Blocks.field_150344_f, 4, i, 0, 8);
                for (j = 0; j < 2; ++j) {
                    this.setBlock(Blocks.field_150344_f, 4, i, 0, 24 + j);
                }
            }
            for (i = 0; i < 6; ++i) {
                for (j = 0; j < 2; ++j) {
                    this.setBlock(Blocks.field_150344_f, 4, i, 0, 9 + j);
                }
            }
            for (i = 0; i < 7; ++i) {
                this.setBlock(i % 2 == 0 ? ModBlocks.lightForcestone : Blocks.field_150406_ce, i % 2 == 0 ? 0 : 3, 5, 0, 14 + i);
            }
            for (i = 0; i < 8; ++i) {
                this.setBlock(ModBlocks.lightForcestone, i == 0 ? 0 : 2, 5, i, 23);
                this.setBlock(ModBlocks.lightForcestone, 0, 2, 0, 30 + i);
                this.setBlock(i == 3 ? ModBlocks.lightForcestone : ModBlocks.lightActivatedForcestone, 0, 2, 1 + i, 29);
                for (j = 0; j < 2; ++j) {
                    this.setBlock(ModBlocks.lightForcestone, 0, 5, i, 9 + j);
                }
                for (j = 0; j < 5; ++j) {
                    if (j == 4) {
                        this.setBlock(ModBlocks.lightForcestone, 0, 5, i, 24 + j);
                        continue;
                    }
                    if (j == 3) {
                        this.setBlock(i == 3 ? Blocks.field_150344_f : ModBlocks.lightForcestone, i == 3 ? 4 : 0, 5, i, 24 + j);
                        continue;
                    }
                    this.setBlock(i == 2 || i == 3 ? Blocks.field_150344_f : ModBlocks.lightForcestone, i == 2 || i == 3 ? 4 : 0, 5, i, 24 + j);
                }
            }
            for (i = 0; i < 9; ++i) {
                this.setBlock(ModBlocks.lightForcestone, 0, 4, i, 8);
                this.setBlock(i < 3 || i > 5 ? ModBlocks.lightForcestone : Blocks.field_150406_ce, i < 3 || i > 5 ? 0 : 3, 4, 0, 13 + i);
                this.setBlock(ModBlocks.lightForcestone, i > 4 && i < 8 ? 2 : 0, 5, i, 29);
                this.setBlock(i == 8 ? ModBlocks.lightForcestoneStairs : (i > 4 && i < 8 ? ModBlocks.lightActivatedForcestone : ModBlocks.lightForcestone), i == 8 ? 2 : 0, 6, i, 29);
            }
            for (i = 0; i < 10; ++i) {
                this.setBlock(ModBlocks.lightForcestone, 4, 6, 1, 12 + i);
                this.setBlock(Blocks.field_150344_f, 4, 6, 2, 12 + i);
                this.setBlock(Blocks.field_150344_f, 4, 6, 3, 12 + i);
                this.setBlock(ModBlocks.lightForcestone, 0, 6, 4, 12 + i);
            }
            for (i = 0; i < 11; ++i) {
                this.setBlock(i < 2 || i > 8 || i == 5 ? ModBlocks.lightForcestone : Blocks.field_150406_ce, i < 2 || i > 8 || i == 5 ? 0 : 3, 3, 0, 12 + i);
            }
            for (i = 0; i < 12; ++i) {
                this.setBlock(ModBlocks.lightForcestone, 0, 6, 0, 11 + i);
                this.setBlock(ModBlocks.lightForcestoneStairs, 1, 6, 5, 11 + i);
                this.setBlock(ModBlocks.lightForcestoneStairs, 4, 5, 5, 11 + i);
                this.setBlock((Block)Blocks.field_150397_co, 3, 5, 6, 11 + i);
                this.setBlock((Block)Blocks.field_150397_co, 3, 5, 7, 11 + i);
                this.setBlock(i < 2 || i > 3 ? ModBlocks.lightForcestone : Blocks.field_150406_ce, i < 2 || i > 3 ? 0 : 3, 2, 0, 11 + i);
                for (j = 0; j < 2; ++j) {
                    this.setBlock(Blocks.field_150344_f, 4, j, 0, 26 + i);
                }
            }
            for (i = 0; i < 13; ++i) {
                this.setBlock((i < 1 || i > 2) && i != 5 ? ModBlocks.lightForcestone : Blocks.field_150406_ce, (i < 1 || i > 2) && i != 5 ? 0 : 3, 1, 0, 11 + i);
                this.setBlock(i == 0 || i == 12 ? ModBlocks.lightForcestone : Blocks.field_150406_ce, i == 0 || i == 12 ? 0 : 3, 0, 0, 11 + i);
            }
            for (i = 0; i < 20; ++i) {
                this.setBlock(ModBlocks.lightForcestoneStairs, 1, 5, 8, 9 + i);
            }
            for (i = 0; i < 21; ++i) {
                this.setBlock(ModBlocks.lightForcestone, 0, 4, 8, 9 + i);
            }
            for (i = 0; i < 25; ++i) {
                this.setBlock((Block)ModBlocks.forcestoneSlab, 8, 3, 8, 8 + i);
            }
            for (i = 0; i < 28; ++i) {
                this.setBlock((Block)ModBlocks.forcestoneSlab, 0, 0, 13, 7 + i);
                this.setBlock(i == 0 || i == 27 ? ModBlocks.lightForcestone : ModBlocks.lightActivatedForcestone, i == 0 || i == 27 ? 0 : 8, 0, 12, 7 + i);
                this.setBlock(i == 0 || i == 27 ? ModBlocks.lightForcestone : ModBlocks.lightForcestoneStairs, i == 0 || i == 27 ? 0 : 4, 1, 9, 7 + i);
                this.setBlock(ModBlocks.lightForcestoneStairs, 1, 1, 12, 7 + i);
                this.setBlock(ModBlocks.lightForcestoneStairs, 1, 2, 9, 7 + i);
                for (j = 0; j < 2; ++j) {
                    this.setBlock(ModBlocks.lightForcestone, 0, 1, 10 + j, 7 + i);
                }
            }
            this.zCoord += 30;
            this.setBlock(ModBlocks.lightForcestone, 0, 2, 0, 12);
            this.setBlock(ModBlocks.lightForcestone, 0, 2, 0, 16);
            this.setBlock((Block)ModBlocks.forcestoneSlab, 0, 2, 1, 12);
            this.setBlock((Block)ModBlocks.forcestoneSlab, 0, 2, 1, 16);
            this.setBlock(ModBlocks.lightActivatedForcestone, 0, 0, 1, 11);
            this.setBlock(ModBlocks.lightActivatedForcestone, 0, 0, 1, 17);
            this.setBlock(ModBlocks.lightActivatedForcestone, 0, 3, 1, 14);
            this.setBlock(ModBlocks.lightForcestoneStairs, 7, 2, 4, 4);
            this.setBlock(ModBlocks.lightForcestoneStairs, 6, 2, 4, 24);
            this.setBlock(ModBlocks.lightForcestoneStairs, 5, 1, 8, 28);
            this.setBlock((Block)ModBlocks.forcestoneSlab, 8, 0, 7, 28);
            this.setBlock(ModBlocks.lightForcestoneStairs, 6, 14, 8, 13);
            this.setBlock(ModBlocks.lightForcestoneStairs, 7, 14, 8, 15);
            this.setBlock((Block)ModBlocks.forcestoneSlab, 8, 14, 7, 14);
            for (i = 0; i < 2; ++i) {
                int j2;
                int y = i * 4;
                for (j2 = 0; j2 < 2; ++j2) {
                    this.setBlock(ModBlocks.lightForcestone, j2, i, 4, 2 + j2);
                    this.setBlock((Block)ModBlocks.forcestoneSlab, 0, 2, 1, 4 + i * 3 + j2 * 17);
                    this.setBlock((Block)ModBlocks.forcestoneSlab, 0, 7 + i * 3, 1, 12 + j2 * 4);
                    this.setBlock(ModBlocks.lightForcestone, 1, 13 + i, 3, 12 + j2 * 4);
                    this.setBlock(ModBlocks.lightActivatedForcestone, 0, 16 + i * 10, 1 + j2, 9);
                    this.setBlock(ModBlocks.lightActivatedForcestone, 0, 16 + i * 10, 1 + j2, 19);
                    this.setBlock(ModBlocks.lightActivatedForcestone, 0, 5, 1 + i, 30 + j2 * 10);
                    this.setBlock(fillerBlock, 0, 6 + i, -2, 7 + j2);
                    this.setBlock(fillerBlock, 0, 6 + i, -2, 20 + j2);
                    this.setBlock(Blocks.field_150355_j, 0, 6 + i, -1, 7 + j2);
                    this.setBlock(Blocks.field_150355_j, 0, 6 + i, -1, 20 + j2);
                    this.setBlock((Block)ModBlocks.forcestoneSlab, 8, 10 + i, 8, 3 + j2);
                    this.setBlock((Block)ModBlocks.forcestoneSlab, 8, 10 + i, 8, 24 + j2);
                }
                for (j2 = 0; j2 < 3; ++j2) {
                    this.setBlock(Blocks.field_150344_f, 4, 6, y, j2);
                    this.setBlock(Blocks.field_150344_f, 4, 7, y, 1 + j2);
                    this.setBlock(Blocks.field_150344_f, 4, 8, y, 1 + j2);
                    this.setBlock(Blocks.field_150344_f, 4, 9, y, 2 + j2);
                    this.setBlock(Blocks.field_150344_f, 4, 10, y, 3 + j2);
                    this.setBlock(Blocks.field_150344_f, 4, 6, y, -j2 + 28);
                    this.setBlock(Blocks.field_150344_f, 4, 7, y, -(1 + j2) + 28);
                    this.setBlock(Blocks.field_150344_f, 4, 8, y, -(1 + j2) + 28);
                    this.setBlock(Blocks.field_150344_f, 4, 9, y, -(2 + j2) + 28);
                    this.setBlock(Blocks.field_150344_f, 4, 10, y, -(3 + j2) + 28);
                    this.setBlock(Blocks.field_150344_f, 4, 14 + i, 0, 13 + j2);
                    this.setBlock(ModBlocks.lightForcestone, 0, 12, 1 + j2, 12 + i * 4);
                    this.setBlock((Block)Blocks.field_150397_co, 3, i, 6 + j2, 4);
                    this.setBlock((Block)Blocks.field_150397_co, 3, i, 6 + j2, 24);
                    this.setBlock((Block)ModBlocks.forcestoneSlab, 8, 7 + i, 8, 1 + j2);
                    this.setBlock((Block)ModBlocks.forcestoneSlab, 8, 7 + i, 8, 25 + j2);
                    this.setBlock((Block)ModBlocks.forcestoneSlab, 8, 11 + j2, 8, 6 + i);
                    this.setBlock((Block)ModBlocks.forcestoneSlab, 8, 11 + j2, 8, 21 + i);
                }
                for (j2 = 0; j2 < 4; ++j2) {
                    this.setBlock(Blocks.field_150344_f, 4, 14, y, 8 + j2);
                    this.setBlock(Blocks.field_150344_f, 4, 14, y, 17 + j2);
                    this.setBlock(ModBlocks.lightForcestone, 0, 7 + j2, 0, 12 + i * 4);
                    this.setBlock(ModBlocks.lightForcestone, 0, 27, j2, 8 + i);
                    this.setBlock(ModBlocks.lightForcestone, 0, 27, j2, 19 + i);
                    this.setBlock(ModBlocks.lightForcestone, 0, 5 + i, j2, 41);
                    this.setBlock(ModBlocks.lightForcestone, 0, 10, 5 + j2, 12 + i * 4);
                }
                for (j2 = 0; j2 < 5; ++j2) {
                    this.setBlock(Blocks.field_150344_f, 4, 11, y, 3 + j2);
                    this.setBlock(Blocks.field_150344_f, 4, 11, y, -(3 + j2) + 28);
                    this.setBlock(Blocks.field_150344_f, 4, i, 0, 21 + j2);
                }
                for (j2 = 0; j2 < 6; ++j2) {
                    this.setBlock(Blocks.field_150344_f, 4, j2, 4, 26 + i);
                }
                for (j2 = 0; j2 < 17; ++j2) {
                    this.setBlock(Blocks.field_150344_f, 4, 13, y, 6 + j2);
                }
                for (j2 = 0; j2 < 19; ++j2) {
                    this.setBlock(Blocks.field_150344_f, 4, 12, y, 5 + j2);
                }
                this.setBlock(ModBlocks.lightForcestone, 1, 2, 3, i);
                this.setBlock((Block)Blocks.field_150349_c, 0, i, 0, 12);
                this.setBlock((Block)Blocks.field_150349_c, 0, i, 0, 16);
                this.setBlock(ModBlocks.lightForcestone, 0, i, 0, 11);
                this.setBlock(ModBlocks.lightForcestone, 0, i, 0, 17);
                this.setBlock((Block)ModBlocks.forcestoneSlab, 0, i, i == 0 ? 2 : 1, 11);
                this.setBlock((Block)ModBlocks.forcestoneSlab, 0, i, i == 0 ? 2 : 1, 17);
                this.setBlock(Blocks.field_150344_f, 4, 2 + i, 0, 11 + i);
                this.setBlock(Blocks.field_150344_f, 4, 2 + i, 0, 17 - i);
                this.setBlock(Blocks.field_150344_f, 4, 4, 0, 10 + i);
                this.setBlock(Blocks.field_150344_f, 4, 4, 0, 17 + i);
                this.setBlock(Blocks.field_150344_f, 4, 5, 0, 11 + i * 6);
                this.setBlock(ModBlocks.lightForcestone, 1, i, 4, 25);
                this.setBlock((Block)Blocks.field_150399_cn, 3, i, 4, 29);
                this.setBlock(Blocks.field_150344_f, 4, i, 0, 29);
                this.setBlock(ModBlocks.lightForcestone, 1, 2, 3, 27 + i);
                this.setBlock(ModBlocks.lightForcestoneStairs, 2, i * 2, 1, 40);
                this.setBlock(ModBlocks.lightForcestoneStairs, 0, 8, 0, 6 + i * 16);
                this.setBlock(fillerBlock, 0, 5 + i, -2, 6);
                this.setBlock(fillerBlock, 0, 8, -2, 8 + i);
                this.setBlock(fillerBlock, 0, 5 + i, -2, 22);
                this.setBlock(fillerBlock, 0, 8, -2, 19 + i);
                this.setBlock(Blocks.field_150355_j, 0, 5 + i, -1, 6);
                this.setBlock(Blocks.field_150355_j, 0, 8, -1, 8 + i);
                this.setBlock(Blocks.field_150355_j, 0, 5 + i, -1, 22);
                this.setBlock(Blocks.field_150355_j, 0, 8, -1, 19 + i);
                this.setBlock(ModBlocks.lightForcestone, 0, i, 5, 4);
                this.setBlock(ModBlocks.lightForcestone, 0, i, 5, 24);
                this.setBlock(ModBlocks.lightForcestoneStairs, 4, 10, 4, 12 + i * 4);
                this.setBlock(topBlock, topBlockMeta, 4 + i, -1, 5);
                this.setBlock(topBlock, topBlockMeta, 4, -1, 6 + i);
                this.setBlock(topBlock, topBlockMeta, 5, -1, 7 + i);
                this.setBlock(topBlock, topBlockMeta, 6 + i, -1, 9);
                this.setBlock(topBlock, topBlockMeta, 7 + i, -1, 10);
                this.setBlock(topBlock, topBlockMeta, 9, -1, 10 - i);
                this.setBlock(topBlock, topBlockMeta, 4 + i, -1, 23);
                this.setBlock(topBlock, topBlockMeta, 4, -1, 21 + i);
                this.setBlock(topBlock, topBlockMeta, 5, -1, 20 + i);
                this.setBlock(topBlock, topBlockMeta, 6 + i, -1, 19);
                this.setBlock(topBlock, topBlockMeta, 7 + i, -1, 18);
                this.setBlock(topBlock, topBlockMeta, 9, -1, 18 + i);
                this.setBlock((Block)Blocks.field_150397_co, 3, 8 + i, 5, 1);
                this.setBlock((Block)Blocks.field_150397_co, 3, 13, 5, 5 + i);
                this.setBlock((Block)Blocks.field_150397_co, 3, 8 + i, 5, 27);
                this.setBlock((Block)Blocks.field_150397_co, 3, 13, 5, 22 + i);
                this.setBlock((Block)Blocks.field_150397_co, 3, 11, 5, 3 + i * 22);
                this.setBlock(ModBlocks.lightForcestoneStairs, 0, 9, 8, 5 + i * 18);
                this.setBlock((Block)ModBlocks.forcestoneSlab, 8, 9, 8, 2 + i);
                this.setBlock((Block)ModBlocks.forcestoneSlab, 8, 11 + i, 8, 5);
                this.setBlock((Block)ModBlocks.forcestoneSlab, 8, 11 + i, 8, 23);
                this.setBlock((Block)ModBlocks.forcestoneSlab, 8, 9, 8, 25 + i);
            }
            for (i = 0; i < 3; ++i) {
                this.setBlock((Block)Blocks.field_150399_cn, 3, 15, 4, 13 + i);
                this.setBlock(ModBlocks.lightForcestone, 0, 2, 1 + i, 2);
                this.setBlock(ModBlocks.lightForcestone, 0, 3, 0, 13 + i);
                this.setBlock((Block)ModBlocks.forcestoneSlab, 0, 3, i == 1 ? 2 : 1, 13 + i);
                this.setBlock(Blocks.field_150344_f, 4, 3, 0, 9 + i);
                this.setBlock(Blocks.field_150344_f, 4, 3, 0, 17 + i);
                this.setBlock(ModBlocks.lightForcestone, 0, i, 4, 28);
                this.setBlock(Blocks.field_150344_f, 4, 3 + i, 4, 28);
                this.setBlock(ModBlocks.lightForcestone, 0, 2, 1 + i, 26);
                this.setBlock(ModBlocks.lightForcestone, 1, 11, 4, 13 + i);
                this.setBlock(ModBlocks.lightForcestoneStairs, 3, 19 + i * 2, 1, 9);
                this.setBlock(ModBlocks.lightForcestoneStairs, 2, 19 + i * 2, 1, 19);
                this.setBlock(ModBlocks.lightForcestoneStairs, 0, 26, 1, 12 + i * 2);
                this.setBlock(ModBlocks.lightForcestoneStairs, 0, 5, 1, 33 + i * 2);
                this.setBlock(ModBlocks.lightForcestoneStairs, 3, 4 + i, 0, 4);
                this.setBlock(ModBlocks.lightForcestoneStairs, 2, 7 + i, 0, 11);
                this.setBlock(ModBlocks.lightForcestoneStairs, i == 0 ? 0 : 3, 6 + i, 0, 5);
                this.setBlock(ModBlocks.lightForcestoneStairs, i != 1 ? 3 : 0, 9, 0, 6 + i);
                this.setBlock(ModBlocks.lightForcestoneStairs, 2, 4 + i, 0, 24);
                this.setBlock(ModBlocks.lightForcestoneStairs, 3, 7 + i, 0, 17);
                this.setBlock(ModBlocks.lightForcestoneStairs, i == 0 ? 0 : 2, 6 + i, 0, 23);
                this.setBlock(ModBlocks.lightForcestoneStairs, i != 1 ? 2 : 0, 9, 0, 20 + i);
                this.setBlock((Block)ModBlocks.forcestoneSlab, 0, 4 + i, 0, 8 + i);
                this.setBlock((Block)ModBlocks.forcestoneSlab, 0, 4 + i, 0, 20 - i);
                this.setBlock((Block)Blocks.field_150397_co, 3, 0, 9 + i, 4);
                this.setBlock((Block)Blocks.field_150397_co, 3, 0, 9 + i, 24);
                this.setBlock(ModBlocks.lightForcestone, 0, 10, 5, 13 + i);
                this.setBlock((Block)Blocks.field_150397_co, 3, 10, 9 + i, 14);
                this.setBlock((Block)Blocks.field_150397_co, 3, 6 + i, 5, 0);
                this.setBlock((Block)Blocks.field_150397_co, 3, 9 + i, 5, 2);
                this.setBlock((Block)Blocks.field_150397_co, 3, 12, 5, 3 + i);
                this.setBlock((Block)Blocks.field_150397_co, 3, 14, 5, 6 + i);
                this.setBlock((Block)Blocks.field_150397_co, 3, 14, 5, 20 + i);
                this.setBlock((Block)Blocks.field_150397_co, 3, 12, 5, 23 + i);
                this.setBlock((Block)Blocks.field_150397_co, 3, 9 + i, 5, 26);
                this.setBlock((Block)Blocks.field_150397_co, 3, 6 + i, 5, 28);
                this.setBlock(ModBlocks.lightForcestoneStairs, i == 2 ? 0 : 3, 7 + i, 8, 4);
                this.setBlock(ModBlocks.lightForcestoneStairs, i == 0 ? 3 : 0, 10, 8, 5 + i);
                this.setBlock(ModBlocks.lightForcestoneStairs, i == 2 ? 2 : 0, 10, 8, 21 + i);
                this.setBlock(ModBlocks.lightForcestoneStairs, i == 2 ? 0 : 2, 7 + i, 8, 24);
                for (j = 0; j < 3; ++j) {
                    this.setBlock((Block)ModBlocks.forcestoneSlab, 8, 15, 5, 9 + i + j * 4);
                    this.setBlock((Block)ModBlocks.forcestoneSlab, 8, 15, 5, 9 + i + j * 4);
                    this.setBlock(Blocks.field_150344_f, 4, 3 + i, 0, j);
                    this.setBlock(Blocks.field_150344_f, 4, i, 0, 8 + j);
                    this.setBlock(Blocks.field_150344_f, 4, i, 0, 18 + j);
                    this.setBlock((Block)Blocks.field_150349_c, 0, i, 0, 13 + j);
                    this.setBlock((Block)Blocks.field_150397_co, 3, 10, 6 + i, 13 + j);
                    this.setBlock((Block)ModBlocks.forcestoneSlab, 8, 4 + i, 8, j);
                }
                for (j = 0; j < 4; ++j) {
                    this.setBlock(ModBlocks.lightForcestone, 0, 2 + j, 4, i);
                    this.setBlock((Block)ModBlocks.forcestoneSlab, 8, 12 + i, 8, 8 + j);
                    this.setBlock((Block)ModBlocks.forcestoneSlab, 8, 12 + i, 8, 17 + j);
                    this.setBlock((Block)ModBlocks.forcestoneSlab, 8, 3 + j, 8, 26 + i);
                }
                for (j = 0; j < 5; ++j) {
                    this.setBlock(Blocks.field_150344_f, 4, 4 + i, 0, 12 + j);
                    this.setBlock(Blocks.field_150344_f, 4, 7 + j, 0, 13 + i);
                    this.setBlock(i > 0 || j == 0 || j == 4 ? ModBlocks.lightForcestone : ModBlocks.lightForcestoneStairs, i > 0 || j == 0 || j == 4 ? 0 : 7, 10 + j, 9 + i, 13);
                    this.setBlock(i > 0 || j == 0 || j == 4 ? ModBlocks.lightForcestone : ModBlocks.lightForcestoneStairs, i > 0 || j == 0 || j == 4 ? 0 : 6, 10 + j, 9 + i, 15);
                }
                for (j = 0; j < 6; ++j) {
                    this.setBlock(Blocks.field_150344_f, 4, j, 0, 26 + i);
                }
            }
            for (i = 0; i < 4; ++i) {
                this.setBlock(i > 2 ? ModBlocks.lightForcestone : ModBlocks.lightActivatedForcestone, 0, 2, 1 + i, 3);
                this.setBlock(ModBlocks.lightForcestone, 0, 3 + i, 0, 8 + i);
                this.setBlock(ModBlocks.lightForcestone, 0, 3 + i, 0, 20 - i);
                this.setBlock((Block)ModBlocks.forcestoneSlab, 0, 3 + i, 1, 8 + i);
                this.setBlock((Block)ModBlocks.forcestoneSlab, 0, 3 + i, 1, 20 - i);
                this.setBlock(i == 3 ? ModBlocks.lightForcestoneStairs : ModBlocks.lightActivatedForcestone, i == 3 ? 1 : 0, 15, 5 + i, 8);
                this.setBlock(i == 3 ? ModBlocks.lightForcestoneStairs : ModBlocks.lightActivatedForcestone, i == 3 ? 1 : 0, 15, 5 + i, 20);
                this.setBlock(i == 3 ? ModBlocks.lightForcestoneStairs : ModBlocks.lightActivatedForcestone, i == 3 ? 3 : 0, 6, 5 + i, 29);
                this.setBlock(ModBlocks.lightForcestone, 0, 2, 0, 21 + i);
                this.setBlock(ModBlocks.lightForcestone, 0, 16, i, 8);
                this.setBlock(ModBlocks.lightForcestone, 0, 16, i, 20);
                this.setBlock(ModBlocks.lightForcestone, 0, 26, i, 8);
                this.setBlock(ModBlocks.lightForcestone, 0, 26, i, 20);
                this.setBlock(ModBlocks.lightForcestone, 0, 6, i, 30);
                this.setBlock(ModBlocks.lightForcestone, 0, 6, i, 40);
                this.setBlock(ModBlocks.lightForcestoneStairs, 1, 3, 0, 4 + i);
                this.setBlock(ModBlocks.lightForcestoneStairs, 0, 10, 0, 8 + i);
                this.setBlock(ModBlocks.lightForcestoneStairs, 1, 3, 0, 21 + i);
                this.setBlock(ModBlocks.lightForcestoneStairs, 0, 10, 0, 17 + i);
                this.setBlock(ModBlocks.lightForcestone, 0, 2, 5 + i, 4);
                this.setBlock(ModBlocks.lightForcestone, 0, 2, 5 + i, 24);
                this.setBlock((Block)Blocks.field_150397_co, 3, 0, 8 + i, 28);
                this.setBlock((Block)Blocks.field_150397_co, 3, 14, 8 + i, 14);
                this.setBlock(topBlock, topBlockMeta, 6 + i, -1, 5 + i);
                this.setBlock(topBlock, topBlockMeta, 9 - i, -1, 20 + i);
                this.setBlock(ModBlocks.lightForcestoneStairs, i == 0 ? 1 : 3, 3 + i, 8, 3);
                this.setBlock(ModBlocks.lightForcestoneStairs, i == 3 ? 2 : 0, 11, 8, 8 + i);
                this.setBlock(ModBlocks.lightForcestoneStairs, i == 0 ? 3 : 0, 11, 8, 17 + i);
                this.setBlock(ModBlocks.lightForcestoneStairs, i == 0 ? 1 : 2, 3 + i, 8, 25);
                for (j = 0; j < 9; ++j) {
                    this.setBlock(Blocks.field_150344_f, 4, 17 + j, i, 8);
                    this.setBlock(Blocks.field_150344_f, 4, 17 + j, i, 20);
                    this.setBlock(Blocks.field_150344_f, 4, 27, i, 10 + j);
                    this.setBlock(Blocks.field_150344_f, 4, 6, i, 31 + j);
                }
            }
            for (i = 0; i < 5; ++i) {
                this.setBlock(ModBlocks.lightForcestone, 0, 9, i, 1);
                this.setBlock(ModBlocks.lightForcestone, 0, 13, i, 5);
                this.setBlock(ModBlocks.lightForcestone, 0, 13, i, 23);
                this.setBlock(ModBlocks.lightForcestone, 0, 9, i, 27);
                this.setBlock(ModBlocks.lightForcestone, 0, 14, 4, 12 + i);
                this.setBlock(Blocks.field_150344_f, 4, 14, 0, 12 + i);
                this.setBlock(i == 0 || i > 3 ? ModBlocks.lightForcestone : ModBlocks.lightActivatedForcestone, 0, 11, i, 12);
                this.setBlock(i == 0 || i > 3 ? ModBlocks.lightForcestone : ModBlocks.lightActivatedForcestone, 0, 11, i, 16);
                this.setBlock(i == 0 || i > 3 ? ModBlocks.lightForcestone : ModBlocks.lightActivatedForcestone, 0, 2, i, 25);
                this.setBlock((Block)ModBlocks.forcestoneSlab, 8, i > 1 ? i + 1 : i, 5, 29);
                this.setBlock(ModBlocks.lightForcestone, 1, i, 3, 40);
                this.setBlock(ModBlocks.lightForcestoneStairs, 3, i, 4, 40);
                this.setBlock(i == 0 || i == 4 ? ModBlocks.lightForcestone : ModBlocks.lightActivatedForcestone, i == 0 || i == 4 ? 0 : 8, 0, 12, 24 + i);
                this.setBlock((Block)ModBlocks.forcestoneSlab, 0, 0, 13, 24 + i);
                this.setBlock(ModBlocks.lightForcestoneStairs, 1, 1, 12, 24 + i);
                this.setBlock(ModBlocks.lightForcestoneStairs, 1, 2, 9, 24 + i);
                this.setBlock(ModBlocks.lightForcestoneStairs, 2, 10 + i, 9, 12);
                this.setBlock(ModBlocks.lightForcestoneStairs, 3, 10 + i, 9, 16);
                this.setBlock(ModBlocks.lightForcestoneStairs, 2, 10 + i, 12, 13);
                this.setBlock(ModBlocks.lightForcestoneStairs, 3, 10 + i, 12, 15);
                this.setBlock(i == 0 || i == 4 ? ModBlocks.lightForcestone : ModBlocks.lightActivatedForcestone, i == 0 || i == 4 ? 0 : 4, 10 + i, 12, 14);
                this.setBlock((Block)ModBlocks.forcestoneSlab, 0, 10 + i, 13, 14);
                for (j = 0; j < 2; ++j) {
                    this.setBlock(ModBlocks.lightForcestone, 0, 7 + j, i, 0);
                    this.setBlock(ModBlocks.lightForcestone, 0, 10 + j, i, 2);
                    this.setBlock(ModBlocks.lightForcestone, 0, 12, i, 3 + j);
                    this.setBlock(ModBlocks.lightForcestone, 0, 14, i, 6 + j);
                    this.setBlock(ModBlocks.lightForcestone, 0, 14, i, 21 + j);
                    this.setBlock(ModBlocks.lightForcestone, 0, 12, i, 24 + j);
                    this.setBlock(ModBlocks.lightForcestone, 0, 10 + j, i, 26);
                    this.setBlock(ModBlocks.lightForcestone, 0, 7 + j, i, 28);
                }
                for (j = 0; j < 3; ++j) {
                    this.setBlock(j > 0 || i == 0 || i == 4 ? ModBlocks.lightForcestone : ModBlocks.lightForcestoneStairs, j > 0 || i == 0 || i == 4 ? 0 : 4, 1, 9 + j, 24 + i);
                }
                for (j = 0; j < 4; ++j) {
                    this.setBlock(ModBlocks.lightForcestone, 0, 15, i, 8 + j);
                    this.setBlock(ModBlocks.lightForcestone, 0, 15, i, 17 + j);
                    this.setBlock(ModBlocks.lightForcestone, 0, 3 + j, i, 29);
                    this.setBlock(Blocks.field_150344_f, 4, i, j, 41);
                }
                for (j = 0; j < 10; ++j) {
                    this.setBlock((Block)Blocks.field_150399_cn, 3, i, 4, 30 + j);
                }
            }
            for (i = 0; i < 6; ++i) {
                this.setBlock(i == 0 || i > 3 ? ModBlocks.lightForcestone : ModBlocks.lightActivatedForcestone, 0, 15, i, 12);
                this.setBlock(i == 0 || i > 3 ? ModBlocks.lightForcestone : ModBlocks.lightActivatedForcestone, 0, 15, i, 16);
                this.setBlock(i == 0 || i > 3 ? ModBlocks.lightForcestone : ModBlocks.lightActivatedForcestone, 0, 2, i, 29);
                this.setBlock(ModBlocks.lightForcestone, 0, i, 4, 41);
            }
            for (i = 0; i < 8; ++i) {
                int j3;
                Block block = ModBlocks.lightForcestone;
                int metadata = block == Blocks.field_150399_cn ? 3 : 0;
                for (j3 = 0; j3 < 4; ++j3) {
                    if (j3 > 0 || i > 4) {
                        block = i < 2 ? ModBlocks.lightForcestone : (i < 4 || i == 6 ? Blocks.field_150399_cn : ModBlocks.lightForcestone);
                        metadata = block == Blocks.field_150399_cn ? 3 : 0;
                    }
                    this.setBlock(block, metadata, 3 + j3, i, 3);
                    this.setBlock(block, metadata, 3 + j3, i, 25);
                    this.setBlock(block, metadata, 11, i, 11 - j3);
                    this.setBlock(block, metadata, 11, i, 17 + j3);
                }
                for (j3 = 0; j3 < 2; ++j3) {
                    this.setBlock(block, metadata, 7 + j3, i, 4);
                    this.setBlock(block, metadata, 7 + j3, i, 24);
                    this.setBlock(block, metadata, 10, i, 6 + j3);
                    this.setBlock(block, metadata, 10, i, 21 + j3);
                }
                this.setBlock(block, metadata, 9, i, 5);
                this.setBlock(block, metadata, 9, i, 23);
            }
            for (i = 0; i < 9; ++i) {
                this.setBlock(ModBlocks.lightForcestone, 1, 26, 3, 10 + i);
                this.setBlock(ModBlocks.lightForcestoneStairs, 1, 26, 4, 10 + i);
                for (int j4 = 0; j4 < 10; ++j4) {
                    this.setBlock((Block)Blocks.field_150399_cn, 3, 16 + j4, 4, 10 + i);
                }
            }
            for (i = 0; i < 11; ++i) {
                int j5;
                this.setBlock(ModBlocks.lightForcestone, 0, 27, 4, 9 + i);
                this.setBlock(ModBlocks.lightForcestone, 1, 16 + i, 3, 9);
                this.setBlock(ModBlocks.lightForcestone, 1, 16 + i, 3, 19);
                this.setBlock(ModBlocks.lightForcestoneStairs, 2, 16 + i, 4, 9);
                this.setBlock(ModBlocks.lightForcestoneStairs, 3, 16 + i, 4, 19);
                this.setBlock(ModBlocks.lightForcestone, 1, 5, 3, 30 + i);
                this.setBlock(ModBlocks.lightForcestoneStairs, 1, 5, 4, 30 + i);
                for (j5 = 0; j5 < 6; ++j5) {
                    this.setBlock(Blocks.field_150344_f, 4, j5, 0, 30 + i);
                }
                for (j5 = 0; j5 < 11; ++j5) {
                    this.setBlock(Blocks.field_150344_f, 4, 16 + i, 0, 9 + j5);
                }
            }
            for (i = 0; i < 12; ++i) {
                this.setBlock(ModBlocks.lightForcestone, 0, 16 + i, 4, 8);
                this.setBlock(ModBlocks.lightForcestone, 0, 16 + i, 4, 20);
                this.setBlock(ModBlocks.lightForcestone, 0, 6, 4, 30 + i);
            }
            for (i = 0; i < 3; ++i) {
                this.setBlock((Block)Blocks.field_150376_bx, 4, 20 + i, 0, 12);
                this.setBlock((Block)Blocks.field_150376_bx, 4, 20 + i, 0, 16);
                this.setBlock((Block)Blocks.field_150376_bx, 4, 2, 0, 34 + i);
                this.setBlock(ModBlocks.lightForcestoneStairs, i == 2 ? 0 : 3, i, 0, 32);
                this.setBlock(ModBlocks.lightForcestoneStairs, i == 2 ? 0 : 2, i, 0, 38);
                for (int j6 = 0; j6 < 5; ++j6) {
                    this.setBlock((Block)Blocks.field_150376_bx, 4, 19 + j6, 0, 13 + i);
                    if (i >= 2) continue;
                    this.setBlock((Block)Blocks.field_150376_bx, 4, i, 0, 33 + j6);
                }
            }
            for (i = 0; i < 2; ++i) {
                this.setBlock(ModBlocks.lightForcestone, 0, 3, 0, 32 + i * 6);
                this.setBlock(ModBlocks.lightForcestoneStairs, 0, 2, 0, 33 + i * 4);
                for (int j7 = 0; j7 < 2; ++j7) {
                    this.setBlock(ModBlocks.lightForcestone, 0, 18 + i * 6, 0, 11 + j7 * 6);
                    this.setBlock(ModBlocks.lightForcestoneStairs, 1 - i, 19 + i * 4, 0, 12 + j7 * 4);
                }
            }
            for (i = 0; i < 5; ++i) {
                this.setBlock(ModBlocks.lightForcestoneStairs, i == 0 ? 1 : (i == 4 ? 0 : 3), 19 + i, 0, 11);
                this.setBlock(ModBlocks.lightForcestoneStairs, i == 0 ? 1 : (i == 4 ? 0 : 2), 19 + i, 0, 17);
                this.setBlock(ModBlocks.lightForcestoneStairs, i == 0 ? 3 : (i == 4 ? 2 : 1), 18, 0, 12 + i);
                this.setBlock(ModBlocks.lightForcestoneStairs, i == 0 ? 3 : (i == 4 ? 2 : 0), 24, 0, 12 + i);
                this.setBlock(ModBlocks.lightForcestoneStairs, i == 0 ? 3 : (i == 4 ? 2 : 0), 3, 0, 33 + i);
            }
            this.setBlock(ModBlocks.lightActivatedForcestone, 0, 21, 0, 14);
            this.setBlock(ModBlocks.lightActivatedForcestone, 0, 0, 0, 35);
            this.setBlock(ModBlocks.holocron, 0, 21, 1, 14);
            this.setBlock(ModBlocks.holocron, 0, 0, 1, 35);
            boolean prevMirrorX = this.mirrorX;
            this.mirrorX = false;
            this.generateTree(random);
            this.zCoord -= 30;
            if (this.simulate) {
                for (int i2 = 0; i2 < this.coverage.size(); ++i2) {
                    StructurePoint p = (StructurePoint)((Object)this.coverage.get(i2));
                    int y = p.field_71572_b;
                    int clearance = this.maxY + 8 - (int)(8.0 * random.nextDouble() * random.nextDouble() * random.nextDouble());
                    while (y > 0 && !this.worldObj.func_147439_a(p.field_71574_a, y - 1, p.field_71573_c).isSideSolid((IBlockAccess)this.worldObj, p.field_71574_a, y - 1, p.field_71573_c, ForgeDirection.UP)) {
                        this.worldObj.func_147449_b(p.field_71574_a, --y, p.field_71573_c, fillerBlock);
                    }
                    for (y = p.field_71572_b; y < clearance; ++y) {
                        if (this.worldObj.func_147437_c(p.field_71574_a, y, p.field_71573_c)) continue;
                        this.worldObj.func_147449_b(p.field_71574_a, y, p.field_71573_c, Blocks.field_150350_a);
                    }
                }
                this.mirrorX = prevMirrorX;
                continue;
            }
            this.generateStructureChestContents(random, (int)(6.0f * ((random.nextFloat() - 0.5f) * 2.0f)), -1, 11 + random.nextInt(12), ChestGenHooks.getItems((String)"jediTemple", (Random)random), ChestGenHooks.getCount((String)"jediTemple", (Random)random));
        }
    }

    public void generateTree(Random random) {
        this.zCoord += 14;
        int height = 7;
        float leafCoverage = 1.5f;
        int leafCoverageI = MathHelper.func_76123_f((float)leafCoverage);
        for (int x = -1; x < 2; ++x) {
            for (int z = -1; z < 2; ++z) {
                for (int y = 0; y < height; ++y) {
                    if (y < 2 || x == 0 || z == 0 || random.nextFloat() > 0.2f + (float)y / (float)height) {
                        this.setBlock(Blocks.field_150364_r, 0, x, y + 1, z);
                        continue;
                    }
                    y = height;
                }
            }
        }
        this.setBlock(Blocks.field_150364_r, 0, 0, 1 + height, 0);
        for (int i = 0; i < MathHelper.func_76136_a((Random)random, (int)18, (int)20); ++i) {
            float rotX = random.nextFloat() * 120.0f;
            float rotY = random.nextFloat() * 360.0f;
            int branchMin = 4;
            int branchMax = 6;
            for (int j = 0; j < (MathHelper.func_76136_a((Random)random, (int)branchMin, (int)branchMax) + MathHelper.func_76136_a((Random)random, (int)branchMin, (int)branchMax)) / 2; ++j) {
                Vec3 vec3 = Vec3.func_72443_a((double)0.0, (double)j, (double)0.0);
                vec3.func_72440_a(rotX * (float)Math.PI / 180.0f);
                vec3.func_72442_b(rotY * (float)Math.PI / 180.0f);
                this.setBlock(Blocks.field_150364_r, 0, MathHelper.func_76128_c((double)vec3.field_72450_a), 1 + height + MathHelper.func_76128_c((double)vec3.field_72448_b), MathHelper.func_76128_c((double)vec3.field_72449_c));
                for (int x = -leafCoverageI; x <= leafCoverageI; ++x) {
                    for (int y = -leafCoverageI; y <= leafCoverageI; ++y) {
                        for (int z = -leafCoverageI; z <= leafCoverageI; ++z) {
                            Vec3 dst;
                            Vec3 src;
                            Block block = this.worldObj.func_147439_a(this.xCoord + MathHelper.func_76128_c((double)vec3.field_72450_a) + x, this.yCoord + 1 + height + MathHelper.func_76128_c((double)vec3.field_72448_b) + y, this.zCoord + MathHelper.func_76128_c((double)vec3.field_72449_c) + z);
                            if (block == Blocks.field_150364_r || !((src = Vec3.func_72443_a((double)((float)MathHelper.func_76128_c((double)vec3.field_72450_a) + 0.5f), (double)((float)(1 + height + MathHelper.func_76128_c((double)vec3.field_72448_b)) + 0.5f), (double)((float)MathHelper.func_76128_c((double)vec3.field_72449_c) + 0.5f))).func_72438_d(dst = src.func_72441_c((double)x, (double)y, (double)z)) <= (double)leafCoverage)) continue;
                            this.setBlock((Block)Blocks.field_150362_t, 0, MathHelper.func_76128_c((double)vec3.field_72450_a) + x, 1 + height + MathHelper.func_76128_c((double)vec3.field_72448_b) + y, MathHelper.func_76128_c((double)vec3.field_72449_c) + z);
                        }
                    }
                }
            }
        }
        this.zCoord -= 14;
    }
}

