/*
 * Decompiled with CFR 0.152.
 */
package com.fiskmods.lightsabers.common.hilt;

import com.fiskmods.lightsabers.common.lightsaber.CrystalColor;
import com.fiskmods.lightsabers.common.lightsaber.FocusingCrystal;
import com.fiskmods.lightsabers.common.lightsaber.LightsaberData;
import com.fiskmods.lightsabers.common.lightsaber.PartType;
import fiskfille.utils.registry.FiskRegistryEntry;
import fiskfille.utils.registry.FiskRegistryNamespaced;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.resources.I18n;

public abstract class Hilt
extends FiskRegistryEntry<Hilt> {
    public static final int MAX_ID = 63;
    public static final FiskRegistryNamespaced<Hilt> REGISTRY = new FiskRegistryNamespaced("lightsabers", "graflex").setMaxId(63);
    public static final Map<String, String> LEGACY_MAPPINGS = new HashMap<String, String>();

    public static void register(int id, String key, Hilt value) {
        REGISTRY.addObject(id, key, value);
    }

    public static void register(String key, Hilt value) {
        REGISTRY.putObject(key, value);
    }

    public static Hilt getHiltFromName(String key) {
        return (Hilt)REGISTRY.getObject(key);
    }

    public static String getNameForHilt(Hilt value) {
        return REGISTRY.getNameForObject(value);
    }

    public static int getIdFromHilt(Hilt value) {
        return value == null ? 0 : REGISTRY.getIDForObject(value);
    }

    public static Hilt getHiltById(int id) {
        return REGISTRY.getObjectById(id);
    }

    public abstract Part[] getParts();

    public abstract CrystalColor getColor();

    public Type getType() {
        return Type.SINGLE;
    }

    public Collection<FocusingCrystal> getFocusingCrystals() {
        return Arrays.asList(new FocusingCrystal[0]);
    }

    public String getUnlocalizedName() {
        return "hilt." + this.delegate.name().replace(':', '.') + ".name";
    }

    public String getLocalizedName() {
        return I18n.func_135052_a((String)this.getUnlocalizedName(), (Object[])new Object[0]).trim();
    }

    public final Part getPart(PartType type) {
        return this.getParts()[type.ordinal()];
    }

    public final LightsaberData createDefault() {
        return new LightsaberData().set(this).set(this.getColor()).set(this.getFocusingCrystals().toArray(new FocusingCrystal[0]));
    }

    public static enum Type {
        SINGLE,
        DOUBLE;

    }

    public static class Part {
        public PartType type;
        public float height;
        public float[] glInstructions;
        public float[] crossguard;

        public Part(PartType type, float height, float ... instructions) {
            this.type = type;
            this.height = height;
            this.glInstructions = instructions;
        }

        public Part addCrossguard(float x, float y, float z) {
            this.crossguard = new float[]{x, y, z};
            return this;
        }

        public boolean hasCrossguard() {
            return this.crossguard != null;
        }
    }
}

