/*
 * Decompiled with CFR 0.152.
 */
package com.fiskmods.lightsabers.common.hilt;

import com.fiskmods.lightsabers.common.hilt.Hilt;
import com.fiskmods.lightsabers.common.hilt.HiltDroideka;
import com.fiskmods.lightsabers.common.hilt.HiltFulcrum;
import com.fiskmods.lightsabers.common.hilt.HiltFury;
import com.fiskmods.lightsabers.common.hilt.HiltGraflex;
import com.fiskmods.lightsabers.common.hilt.HiltImperial;
import com.fiskmods.lightsabers.common.hilt.HiltJuggernaut;
import com.fiskmods.lightsabers.common.hilt.HiltKnighted;
import com.fiskmods.lightsabers.common.hilt.HiltMandalorian;
import com.fiskmods.lightsabers.common.hilt.HiltMauler;
import com.fiskmods.lightsabers.common.hilt.HiltMechanical;
import com.fiskmods.lightsabers.common.hilt.HiltProdigalSon;
import com.fiskmods.lightsabers.common.hilt.HiltRebel;
import com.fiskmods.lightsabers.common.hilt.HiltReborn;
import com.fiskmods.lightsabers.common.hilt.HiltRedeemer;
import com.fiskmods.lightsabers.common.hilt.HiltVaid;
import java.lang.reflect.Field;
import java.util.Locale;

public class HiltManager {
    public static final Hilt GRAFLEX = new HiltGraflex();
    public static final Hilt REDEEMER = new HiltRedeemer();
    public static final Hilt MAULER = new HiltMauler();
    public static final Hilt PRODIGAL_SON = new HiltProdigalSon();
    public static final Hilt KNIGHTED = new HiltKnighted();
    public static final Hilt VAID_ANCIENT = new HiltVaid();
    public static final Hilt VAID_MODERN = new HiltVaid();
    public static final Hilt DROIDEKA = new HiltDroideka();
    public static final Hilt FULCRUM = new HiltFulcrum();
    public static final Hilt JUGGERNAUT = new HiltJuggernaut();
    public static final Hilt MECHANICAL = new HiltMechanical();
    public static final Hilt MANDALORIAN = new HiltMandalorian();
    public static final Hilt FURY = new HiltFury();
    public static final Hilt REBEL = new HiltRebel();
    public static final Hilt IMPERIAL = new HiltImperial();
    public static final Hilt REBORN = new HiltReborn();

    public static void register() {
        for (Field field : HiltManager.class.getFields()) {
            if (!Hilt.class.isAssignableFrom(field.getType())) continue;
            try {
                Hilt.register(field.getName().toLowerCase(Locale.ROOT), (Hilt)field.get(null));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        HiltManager.map(GRAFLEX, "Graflex");
        HiltManager.map(REDEEMER, "Redeemer");
        HiltManager.map(MAULER, "Mauler");
        HiltManager.map(PRODIGAL_SON, "Prodigal Son");
        HiltManager.map(KNIGHTED, "Knighted");
        HiltManager.map(VAID_ANCIENT, "Vaid (Ancient)");
        HiltManager.map(VAID_MODERN, "Vaid (Modern)");
        HiltManager.map(DROIDEKA, "Droideka");
        HiltManager.map(FULCRUM, "Fulcrum");
        HiltManager.map(JUGGERNAUT, "Juggernaut");
        HiltManager.map(MECHANICAL, "Mechanical");
        HiltManager.map(MANDALORIAN, "Mandalorian");
        HiltManager.map(FURY, "Fury");
    }

    private static void map(Hilt value, String legacy) {
        Hilt.LEGACY_MAPPINGS.put(legacy, value.delegate.name());
    }
}

