/*
 * Decompiled with CFR 0.152.
 */
package com.fiskmods.lightsabers.common.item;

import com.fiskmods.lightsabers.common.block.ModBlocks;
import com.fiskmods.lightsabers.common.item.ILightsaberComponent;
import com.fiskmods.lightsabers.common.lightsaber.CrystalColor;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import fiskfille.utils.helper.FiskMath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;
import net.minecraftforge.common.ChestGenHooks;

public class ItemCrystal
extends ItemBlock
implements ILightsaberComponent {
    public static Map<CrystalColor, EnumRarity> rarityMap = Maps.newHashMap();
    public static Map<CrystalColor, String[]> chestMap = Maps.newHashMap();
    private static Map<CrystalColor, Integer> genRarityMap = Maps.newHashMap();
    private static final int[] GEN_RARITY = new int[]{90, 30, 10, 1};
    private static boolean hasInit = false;

    public ItemCrystal(Block block) {
        super(block);
        this.func_77627_a(true);
    }

    @Override
    public long getFingerprint(ItemStack stack, int slot) {
        return (ItemCrystal.getId(stack) & 0xFF) << 24;
    }

    @Override
    public boolean isCompatibleSlot(ItemStack stack, int slot) {
        return slot == 5;
    }

    public WeightedRandomChestContent getChestGenBase(ChestGenHooks chest, Random rand, WeightedRandomChestContent original) {
        ItemStack itemstack = original.field_76297_b;
        String category = "";
        if (itemstack.func_77942_o()) {
            category = itemstack.func_77978_p().func_74779_i("ChestGenCategory");
        }
        ArrayList list = Lists.newArrayList();
        for (CrystalColor color : CrystalColor.values()) {
            if (!Arrays.asList((Object[])chestMap.get((Object)color)).contains(category)) continue;
            for (int i = rarityMap.get((Object)color).ordinal() - 1; i >= 0; --i) {
                list.add(color);
            }
        }
        if (list.isEmpty()) {
            list.addAll(Arrays.asList(CrystalColor.values()));
        }
        return new WeightedRandomChestContent(ItemCrystal.create((CrystalColor)((Object)list.get(rand.nextInt(list.size())))), original.field_76295_d, original.field_76296_e, original.field_76292_a);
    }

    public EnumRarity func_77613_e(ItemStack itemstack) {
        return rarityMap.get((Object)ItemCrystal.get(itemstack));
    }

    public void func_77663_a(ItemStack itemstack, World world, Entity entity, int slot, boolean inHand) {
        if (!world.field_72995_K && itemstack.func_77942_o() && itemstack.func_77978_p().func_150297_b("color", 99)) {
            ItemCrystal.getId(itemstack);
        }
    }

    public void func_77624_a(ItemStack itemstack, EntityPlayer player, List list, boolean advanced) {
        list.add(ItemCrystal.get(itemstack).getLocalizedName());
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack itemstack, int metadata) {
        return ItemCrystal.get((ItemStack)itemstack).color;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
    }

    public static int getId(ItemStack itemstack) {
        if (itemstack.func_77942_o() && itemstack.func_77978_p().func_150297_b("color", 99)) {
            itemstack.func_77964_b(itemstack.func_77978_p().func_74762_e("color"));
            itemstack.func_77978_p().func_82580_o("color");
            if (itemstack.func_77978_p().func_82582_d()) {
                itemstack.func_77982_d(null);
            }
        }
        return itemstack.func_77960_j();
    }

    public static CrystalColor get(ItemStack itemstack) {
        return CrystalColor.get(ItemCrystal.getId(itemstack));
    }

    public static CrystalColor getRandomGen(Random rand) {
        return FiskMath.getWeightedI(rand, genRarityMap);
    }

    public static ItemStack create(CrystalColor color, Item item) {
        return new ItemStack(item, 1, color.id);
    }

    public static ItemStack create(CrystalColor color) {
        return ItemCrystal.create(color, Item.func_150898_a((Block)ModBlocks.lightsaberCrystal));
    }

    public static void registerRarity(CrystalColor color, EnumRarity rarity, String ... chests) {
        rarityMap.put(color, rarity);
        chestMap.put(color, chests);
        genRarityMap.put(color, GEN_RARITY[rarity.ordinal()]);
    }

    private static void init() throws Exception {
        if (hasInit) {
            return;
        }
        hasInit = true;
        ItemCrystal.registerRarity(CrystalColor.DEEP_BLUE, EnumRarity.common, "sithTombCoffin", "sithTombTreasury", "sithTombAnnex", "dungeonChest");
        ItemCrystal.registerRarity(CrystalColor.MEDIUM_BLUE, EnumRarity.common, "sithTombCoffin", "sithTombTreasury", "sithTombAnnex", "dungeonChest");
        ItemCrystal.registerRarity(CrystalColor.LIGHT_BLUE, EnumRarity.common, "sithTombCoffin", "sithTombTreasury", "sithTombAnnex", "dungeonChest");
        ItemCrystal.registerRarity(CrystalColor.AMBER, EnumRarity.common, "sithTombCoffin", "sithTombTreasury", "sithTombAnnex", "pyramidDesertyChest");
        ItemCrystal.registerRarity(CrystalColor.YELLOW, EnumRarity.common, "sithTombCoffin", "sithTombTreasury", "sithTombAnnex", "pyramidDesertyChest");
        ItemCrystal.registerRarity(CrystalColor.GOLD, EnumRarity.common, "sithTombCoffin", "sithTombTreasury", "sithTombAnnex", "pyramidDesertyChest");
        ItemCrystal.registerRarity(CrystalColor.LIME_GREEN, EnumRarity.common, "sithTombCoffin", "sithTombTreasury", "sithTombAnnex", "pyramidJungleChest", "pyramidDesertyChest");
        ItemCrystal.registerRarity(CrystalColor.GREEN, EnumRarity.common, "sithTombCoffin", "sithTombTreasury", "sithTombAnnex", "pyramidJungleChest");
        ItemCrystal.registerRarity(CrystalColor.MINT_GREEN, EnumRarity.common, "sithTombCoffin", "sithTombTreasury", "sithTombAnnex", "pyramidJungleChest");
        ItemCrystal.registerRarity(CrystalColor.MAGENTA, EnumRarity.uncommon, "sithTombCoffin", "sithTombTreasury", "sithTombAnnex", "dungeonChest");
        ItemCrystal.registerRarity(CrystalColor.PINK, EnumRarity.uncommon, "sithTombCoffin", "sithTombTreasury", "sithTombAnnex", "dungeonChest");
        ItemCrystal.registerRarity(CrystalColor.RED, EnumRarity.uncommon, "sithTombCoffin", "sithTombTreasury", "sithTombAnnex", "villageBlacksmith");
        ItemCrystal.registerRarity(CrystalColor.BLOOD_ORANGE, EnumRarity.uncommon, "sithTombCoffin", "sithTombTreasury", "sithTombAnnex", "pyramidDesertyChest");
        ItemCrystal.registerRarity(CrystalColor.INDIGO, EnumRarity.rare, "sithTombCoffin", "sithTombTreasury", "sithTombAnnex", "strongholdLibrary");
        ItemCrystal.registerRarity(CrystalColor.PURPLE, EnumRarity.rare, "sithTombCoffin", "sithTombTreasury", "sithTombAnnex", "strongholdLibrary");
        ItemCrystal.registerRarity(CrystalColor.CYAN, EnumRarity.rare, "sithTombCoffin", "sithTombTreasury", "sithTombAnnex", "strongholdLibrary");
        ItemCrystal.registerRarity(CrystalColor.ARCTIC_BLUE, EnumRarity.epic, "sithTombTreasury", "mineshaftCorridor");
        ItemCrystal.registerRarity(CrystalColor.WHITE, EnumRarity.epic, "sithTombTreasury", "mineshaftCorridor");
    }

    static {
        try {
            ItemCrystal.init();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

