/*
 * Decompiled with CFR 0.152.
 */
package com.fiskmods.lightsabers.common.item;

import com.fiskmods.lightsabers.ALReflection;
import com.fiskmods.lightsabers.common.damage.ALDamageSources;
import com.fiskmods.lightsabers.common.hilt.Hilt;
import com.fiskmods.lightsabers.common.item.ItemLightsaberBase;
import com.fiskmods.lightsabers.common.item.ModItems;
import com.fiskmods.lightsabers.common.lightsaber.FocusingCrystal;
import com.fiskmods.lightsabers.common.lightsaber.LightsaberData;
import com.google.common.collect.Lists;
import cpw.mods.fml.common.Optional;
import fiskfille.utils.helper.NBTHelper;
import fiskfille.utils.helper.VectorHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import mods.battlegear2.api.IAllowItem;
import mods.battlegear2.api.IOffhandWield;
import net.minecraft.command.IEntitySelector;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.potion.Potion;
import net.minecraft.stats.AchievementList;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatList;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

@Optional.InterfaceList(value={@Optional.Interface(modid="battlegear2", iface="mods.battlegear2.api.IOffhandWield"), @Optional.Interface(modid="battlegear2", iface="mods.battlegear2.api.IAllowItem")})
public class ItemDoubleLightsaber
extends ItemLightsaberBase
implements IOffhandWield,
IAllowItem {
    public void func_77663_a(ItemStack itemstack, World world, Entity entity, int slot, boolean inHand) {
        if (!world.field_72995_K && itemstack.func_77942_o() && itemstack.func_77978_p().func_150297_b("UpperLightsaber", 10) && itemstack.func_77978_p().func_150297_b("LowerLightsaber", 10)) {
            ItemDoubleLightsaber.get(itemstack);
        }
    }

    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        LightsaberData[] array = new LightsaberData[2];
        for (Hilt hilt : Hilt.REGISTRY) {
            if (hilt.getType() != Hilt.Type.DOUBLE) continue;
            for (int i = 0; i < array.length; ++i) {
                array[i] = new LightsaberData().set(hilt).set(hilt.getColor()).set(hilt.getFocusingCrystals().toArray(new FocusingCrystal[2]));
            }
            list.add(ItemDoubleLightsaber.create(array));
        }
    }

    public void func_77624_a(ItemStack itemstack, EntityPlayer player, List list, boolean advanced) {
        LightsaberData[] array = ItemDoubleLightsaber.get(itemstack);
        Hilt[][] hilt = new Hilt[][]{array[0].getHilt(), array[1].getHilt()};
        String space = "  ";
        list.add(StatCollector.func_74838_a((String)"lightsaber.color"));
        list.add(space + array[0].getColor().getLocalizedName());
        if (array[0].getColor() != array[1].getColor()) {
            list.add(space + array[1].getColor().getLocalizedName());
        }
        list.add(StatCollector.func_74838_a((String)"lightsaber.hilt"));
        if (array[0].isHiltUniform() && array[1].isHiltUniform()) {
            list.add(space + hilt[0][0].getLocalizedName());
            if (hilt[0][0] != hilt[1][0]) {
                list.add(space + hilt[1][0].getLocalizedName());
            }
        } else {
            for (int i = 0; i < (array[0].getHiltBits() == array[1].getHiltBits() ? 1 : hilt.length); ++i) {
                ArrayList list1 = Lists.newArrayList((Object[])hilt[i]);
                if (i == 1) {
                    Collections.reverse(list1);
                }
                for (int j = 0; j < list1.size(); ++j) {
                    list.add(space + ((Hilt)list1.get(j)).getLocalizedName());
                }
            }
        }
        FocusingCrystal[][] crystals = new FocusingCrystal[][]{array[0].getFocusingCrystals(), array[1].getFocusingCrystals()};
        String[] astring = new String[]{"upper", "lower"};
        if (crystals[0].length > 0 || crystals[1].length > 0) {
            list.add(StatCollector.func_74838_a((String)"lightsaber.focusingCrystals"));
        }
        for (int i = 0; i < astring.length; ++i) {
            if (crystals[i].length <= 0) continue;
            list.add(space + StatCollector.func_74838_a((String)("lightsaber." + astring[i])));
            for (FocusingCrystal crystal : crystals[i]) {
                list.add(space + space + crystal.getLocalizedName());
            }
        }
        if (advanced) {
            list.add(StatCollector.func_74837_a((String)"lightsaber.code.double", (Object[])new Object[]{Long.toHexString(array[0].hash).toUpperCase(Locale.ROOT), Long.toHexString(array[1].hash).toUpperCase(Locale.ROOT)}));
        }
    }

    public boolean func_77644_a(ItemStack itemstack, EntityLivingBase target, EntityLivingBase attacker) {
        float width = attacker.field_70130_N * 2.0f;
        Vec3 vec3 = VectorHelper.getOffsetCoords(attacker, 0.0, 0.0, -0.2f);
        AxisAlignedBB aabb = AxisAlignedBB.func_72330_a((double)(-width), (double)0.0, (double)(-width), (double)width, (double)attacker.field_70131_O, (double)width).func_72317_d(vec3.field_72450_a, attacker.field_70121_D.field_72338_b, vec3.field_72449_c);
        List list = attacker.field_70170_p.func_82733_a(EntityLivingBase.class, aabb, IEntitySelector.field_94557_a);
        for (EntityLivingBase entity : list) {
            boolean success;
            boolean crit;
            if (entity == attacker) continue;
            ItemStack stack = attacker.func_70694_bm();
            if (attacker instanceof EntityPlayer && stack != null && stack.func_77973_b().onLeftClickEntity(stack, (EntityPlayer)attacker, (Entity)entity) || !entity.func_70075_an() || entity.func_85031_j((Entity)attacker)) continue;
            float attackDamage = (float)attacker.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
            float livingModifier = EnchantmentHelper.func_77512_a((EntityLivingBase)attacker, (EntityLivingBase)entity);
            int knockback = EnchantmentHelper.func_77507_b((EntityLivingBase)attacker, (EntityLivingBase)entity);
            if (attacker.func_70051_ag()) {
                ++knockback;
            }
            if (!(attackDamage > 0.0f) && !(livingModifier > 0.0f)) continue;
            boolean bl = crit = attacker.field_70143_R > 0.0f && !attacker.field_70122_E && !attacker.func_70617_f_() && !attacker.func_70090_H() && !attacker.func_70644_a(Potion.field_76440_q) && attacker.field_70154_o == null;
            if (crit && attackDamage > 0.0f) {
                attackDamage *= 1.5f;
            }
            attackDamage += livingModifier;
            boolean onFire = false;
            int fire = EnchantmentHelper.func_90036_a((EntityLivingBase)attacker);
            if (fire > 0 && !entity.func_70027_ad()) {
                onFire = true;
                entity.func_70015_d(1);
            }
            if (success = entity.func_70097_a(ALDamageSources.causeLightsaberDamage((Entity)attacker), attackDamage)) {
                if (knockback > 0) {
                    double d1;
                    double d = (float)knockback * 0.25f;
                    double x = attacker.field_70165_t - entity.field_70165_t;
                    double z = attacker.field_70161_v - entity.field_70161_v;
                    while (Math.sqrt(x * x + z * z) > d) {
                        d1 = 0.95;
                        x *= d1;
                        z *= d1;
                    }
                    while (Math.sqrt(x * x + z * z) < d) {
                        d1 = 1.05;
                        x *= d1;
                        z *= d1;
                    }
                    entity.func_70024_g(-x, 0.1, -z);
                    attacker.field_70159_w *= 0.6;
                    attacker.field_70179_y *= 0.6;
                    attacker.func_70031_b(false);
                }
                if (!(attacker instanceof EntityPlayer)) continue;
                EntityPlayer player = (EntityPlayer)attacker;
                if (crit) {
                    player.func_71009_b((Entity)entity);
                }
                if (livingModifier > 0.0f) {
                    player.func_71047_c((Entity)entity);
                }
                if (attackDamage >= 18.0f) {
                    player.func_71029_a((StatBase)AchievementList.field_75999_E);
                }
                player.func_130011_c((Entity)entity);
                EnchantmentHelper.func_151384_a((EntityLivingBase)entity, (Entity)player);
                EnchantmentHelper.func_151385_b((EntityLivingBase)player, (Entity)entity);
                player.func_71064_a(StatList.field_75951_w, Math.round(attackDamage * 10.0f));
                if (fire > 0) {
                    entity.func_70015_d(fire * 4);
                }
                player.func_71020_j(0.3f);
                continue;
            }
            if (!onFire) continue;
            entity.func_70066_B();
        }
        return true;
    }

    public boolean isOffhandWieldable(ItemStack itemstack, EntityPlayer player) {
        return false;
    }

    public boolean allowOffhand(ItemStack main, ItemStack off) {
        return false;
    }

    public static LightsaberData[] readFromNBT(NBTTagCompound nbt) {
        LightsaberData[] array = new LightsaberData[]{LightsaberData.EMPTY, LightsaberData.EMPTY};
        if (nbt.func_150297_b("UpperLightsaber", 10) && nbt.func_150297_b("LowerLightsaber", 10)) {
            NBTTagList list = new NBTTagList();
            String[] astring = new String[]{"UpperLightsaber", "LowerLightsaber"};
            for (int i = 0; i < astring.length; ++i) {
                NBTTagCompound compound = nbt.func_74775_l(astring[i]);
                compound.func_74782_a("Lightsaber", compound.func_74737_b());
                array[i] = LightsaberData.readFromNBT(compound);
                list.func_74742_a((NBTBase)new NBTTagLong(array[i].hash));
                nbt.func_82580_o(astring[i]);
            }
            nbt.func_74782_a("Lightsaber", (NBTBase)list);
        } else if (nbt.func_150297_b("Lightsaber", 9)) {
            NBTTagList list = nbt.func_150295_c("Lightsaber", 4);
            List tags = ALReflection.tagList.get(list);
            for (int i = 0; i < Math.min(tags.size(), array.length); ++i) {
                LightsaberData data = NBTHelper.readFromNBT((NBTBase)tags.get(i), LightsaberData.class);
                if (data == null) continue;
                array[i] = data.strip();
            }
        }
        return array;
    }

    public static LightsaberData[] get(ItemStack itemstack) {
        if (itemstack != null && itemstack.func_77942_o()) {
            return ItemDoubleLightsaber.readFromNBT(itemstack.func_77978_p());
        }
        return new LightsaberData[]{LightsaberData.EMPTY, LightsaberData.EMPTY};
    }

    public static ItemStack create(LightsaberData[] array) {
        ItemStack itemstack = new ItemStack(ModItems.doubleLightsaber);
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < array.length; ++i) {
            list.func_74742_a((NBTBase)new NBTTagLong(array[i].hash));
        }
        itemstack.func_77982_d(new NBTTagCompound());
        itemstack.func_77978_p().func_74782_a("Lightsaber", (NBTBase)list);
        return itemstack;
    }

    public static ItemStack create(ItemStack upper, ItemStack lower) {
        return ItemDoubleLightsaber.create(new LightsaberData[]{LightsaberData.get(upper), LightsaberData.get(lower)});
    }
}

