/*
 * Decompiled with CFR 0.152.
 */
package com.fiskmods.lightsabers.common.item;

import com.fiskmods.lightsabers.common.hilt.Hilt;
import com.fiskmods.lightsabers.common.item.ItemDoubleLightsaber;
import com.fiskmods.lightsabers.common.item.ItemLightsaberBase;
import com.fiskmods.lightsabers.common.item.ModItems;
import com.fiskmods.lightsabers.common.lightsaber.CrystalColor;
import com.fiskmods.lightsabers.common.lightsaber.FocusingCrystal;
import com.fiskmods.lightsabers.common.lightsaber.LightsaberData;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import mods.battlegear2.api.PlayerEventChild;
import mods.battlegear2.api.weapons.IBattlegearWeapon;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

@Optional.InterfaceList(value={@Optional.Interface(modid="battlegear2", iface="mods.battlegear2.api.weapons.IBattlegearWeapon")})
public class ItemLightsaber
extends ItemLightsaberBase
implements IBattlegearWeapon {
    public String func_77653_i(ItemStack itemstack) {
        if (itemstack.func_77942_o() && itemstack.func_77978_p().func_150297_b("Special", 8)) {
            return "FISHSTICKS!!";
        }
        return super.func_77653_i(itemstack);
    }

    public EnumRarity func_77613_e(ItemStack itemstack) {
        if (itemstack.func_77942_o() && itemstack.func_77978_p().func_150297_b("Special", 8)) {
            return EnumRarity.rare;
        }
        return EnumRarity.common;
    }

    public WeightedRandomChestContent getChestGenBase(ChestGenHooks chest, Random rand, WeightedRandomChestContent original) {
        ItemStack itemstack = original.field_76297_b;
        if (itemstack.func_77942_o() && itemstack.func_77978_p().func_74767_n("SithTombLoot")) {
            itemstack = LightsaberData.createRandom(rand, rand.nextInt(5) == 0 ? CrystalColor.PURPLE : CrystalColor.RED);
            if (rand.nextInt(4) == 0) {
                itemstack = ItemDoubleLightsaber.create(itemstack, itemstack);
            }
        } else if (itemstack.func_77942_o() && itemstack.func_77978_p().func_74767_n("JediTempleLoot")) {
            itemstack = LightsaberData.createRandom(rand, rand.nextBoolean() ? CrystalColor.MEDIUM_BLUE : CrystalColor.GREEN);
            if (rand.nextInt(8) == 0) {
                itemstack = ItemDoubleLightsaber.create(itemstack, itemstack);
            }
        } else {
            itemstack = LightsaberData.createRandom(rand);
        }
        return new WeightedRandomChestContent(itemstack, original.field_76295_d, original.field_76296_e, original.field_76292_a);
    }

    public void func_77663_a(ItemStack itemstack, World world, Entity entity, int slot, boolean inHand) {
        if (!world.field_72995_K && itemstack.func_77942_o() && itemstack.func_77978_p().func_150297_b("Lightsaber", 10)) {
            LightsaberData.get(itemstack);
        }
    }

    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        for (Hilt hilt : Hilt.REGISTRY) {
            if (hilt.getType() != Hilt.Type.SINGLE) continue;
            list.add(hilt.createDefault().create());
        }
    }

    public void func_77624_a(ItemStack itemstack, EntityPlayer player, List list, boolean advanced) {
        LightsaberData data = LightsaberData.get(itemstack);
        Hilt[] hilt = data.getHilt();
        String space = "  ";
        list.add(StatCollector.func_74838_a((String)"lightsaber.color"));
        list.add(space + data.getColor().getLocalizedName());
        list.add(StatCollector.func_74838_a((String)"lightsaber.hilt"));
        if (data.isHiltUniform()) {
            list.add(space + hilt[0].getLocalizedName());
        } else {
            for (int i = 0; i < hilt.length; ++i) {
                list.add(space + hilt[i].getLocalizedName());
            }
        }
        FocusingCrystal[] crystals = data.getFocusingCrystals();
        if (crystals.length > 0) {
            list.add(StatCollector.func_74838_a((String)"lightsaber.focusingCrystals"));
            for (FocusingCrystal crystal : crystals) {
                list.add(space + crystal.getLocalizedName());
            }
        }
        if (advanced) {
            list.add(StatCollector.func_74837_a((String)"lightsaber.code.single", (Object[])new Object[]{Long.toHexString(data.hash).toUpperCase(Locale.ROOT)}));
        }
    }

    public boolean allowOffhand(ItemStack main, ItemStack off) {
        return main == null || main.func_77973_b() != ModItems.doubleLightsaber;
    }

    public boolean sheatheOnBack(ItemStack item) {
        return false;
    }

    public boolean isOffhandHandDual(ItemStack off) {
        return true;
    }

    public boolean offhandAttackEntity(PlayerEventChild.OffhandAttackEvent event, ItemStack mainhandItem, ItemStack offhandItem) {
        return false;
    }

    public boolean offhandClickAir(PlayerInteractEvent event, ItemStack mainhandItem, ItemStack offhandItem) {
        return false;
    }

    public boolean offhandClickBlock(PlayerInteractEvent event, ItemStack mainhandItem, ItemStack offhandItem) {
        return false;
    }

    public void performPassiveEffects(Side effectiveSide, ItemStack mainhandItem, ItemStack offhandItem) {
    }
}

