/*
 * Decompiled with CFR 0.152.
 */
package com.fiskmods.lightsabers.common.item;

import com.fiskmods.lightsabers.common.hilt.Hilt;
import com.fiskmods.lightsabers.common.item.ILightsaberComponent;
import com.fiskmods.lightsabers.common.item.ModItems;
import com.fiskmods.lightsabers.common.lightsaber.PartType;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraftforge.common.ChestGenHooks;

public class ItemLightsaberPart
extends Item
implements ILightsaberComponent {
    public final PartType partType;

    public ItemLightsaberPart(PartType type) {
        this.func_77625_d(16);
        this.func_77627_a(true);
        this.partType = type;
    }

    @Override
    public long getFingerprint(ItemStack stack, int slot) {
        return Hilt.REGISTRY.getIDForObject(ItemLightsaberPart.get(stack)) << this.partType.ordinal() * 6;
    }

    @Override
    public boolean isCompatibleSlot(ItemStack stack, int slot) {
        return slot == this.partType.ordinal();
    }

    public WeightedRandomChestContent getChestGenBase(ChestGenHooks chest, Random rand, WeightedRandomChestContent original) {
        return new WeightedRandomChestContent(ItemLightsaberPart.create(ItemLightsaberPart.getRandomType(rand), (Hilt)Hilt.REGISTRY.getRandom(rand)), original.field_76295_d, original.field_76296_e, original.field_76292_a);
    }

    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        for (Hilt hilt : Hilt.REGISTRY) {
            list.add(ItemLightsaberPart.create(this.partType, hilt));
        }
    }

    public void func_77624_a(ItemStack itemstack, EntityPlayer player, List list, boolean flag) {
        list.add(ItemLightsaberPart.get(itemstack).getLocalizedName());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
    }

    public static Hilt get(ItemStack itemstack) {
        int id = 0;
        if (itemstack.func_77942_o()) {
            if (itemstack.func_77978_p().func_150297_b("lightsaber", 8)) {
                id = Hilt.REGISTRY.getIDForObject((Hilt)Hilt.REGISTRY.getObject(Hilt.LEGACY_MAPPINGS.get(itemstack.func_77978_p().func_74779_i("lightsaber"))));
                itemstack.func_77978_p().func_82580_o("lightsaber");
                itemstack.func_77978_p().func_82580_o("type");
                itemstack.func_77978_p().func_74774_a("Type", (byte)id);
            } else if (itemstack.func_77978_p().func_150297_b("Type", 99)) {
                id = itemstack.func_77978_p().func_74771_c("Type");
            }
        }
        return Hilt.REGISTRY.getObjectById(id);
    }

    public static Item getItem(PartType type) {
        switch (type) {
            case EMITTER: {
                return ModItems.emitter;
            }
            case SWITCH_SECTION: {
                return ModItems.switchSection;
            }
            case BODY: {
                return ModItems.grip;
            }
            case POMMEL: {
                return ModItems.pommel;
            }
        }
        return null;
    }

    public static ItemStack create(PartType type, Hilt hilt) {
        ItemStack itemstack = new ItemStack(ItemLightsaberPart.getItem(type));
        itemstack.func_77982_d(new NBTTagCompound());
        itemstack.func_77978_p().func_74774_a("Type", (byte)Hilt.REGISTRY.getIDForObject(hilt));
        return itemstack;
    }

    public static PartType getType(ItemStack itemstack) {
        return itemstack.func_77973_b() instanceof ItemLightsaberPart ? ((ItemLightsaberPart)itemstack.func_77973_b()).partType : null;
    }

    public static PartType getRandomType(Random rand) {
        return PartType.values()[rand.nextInt(PartType.values().length)];
    }

    public static PartType getRandomType() {
        return ItemLightsaberPart.getRandomType(new Random());
    }
}

