/*
 * Decompiled with CFR 0.152.
 */
package com.fiskmods.lightsabers.common.lightsaber;

import java.util.Locale;
import java.util.Random;
import net.minecraft.util.StatCollector;

public enum CrystalColor {
    DEEP_BLUE(0, 255),
    MEDIUM_BLUE(1, 27647),
    LIGHT_BLUE(2, 5880319),
    ARCTIC_BLUE(3, 0xDDF6FF),
    WHITE(4, 0xFFFFFF),
    INDIGO(5, 6095103),
    PURPLE(6, 0xAD00AD),
    MAGENTA(7, 0xFF00FF),
    PINK(8, 16748474),
    RED(9, 0xFF0000),
    BLOOD_ORANGE(10, 0xFF8000),
    AMBER(11, 16758272),
    YELLOW(12, 0xFFFF00),
    GOLD(13, 0xFFFF3A),
    LIME_GREEN(14, 0xBFFF00),
    GREEN(15, 65280),
    MINT_GREEN(16, 65435),
    CYAN(17, 65535);

    public static final float[][] COLOR_VALUES;
    public static final CrystalColor[] GROUP_BLUE;
    public static final CrystalColor[] GROUP_PURPLE;
    public static final CrystalColor[] GROUP_RED;
    public static final CrystalColor[] GROUP_ORANGE;
    public static final CrystalColor[] GROUP_YELLOW;
    public static final CrystalColor[] GROUP_GREEN;
    public static final CrystalColor[] GROUP_COLD;
    public static final CrystalColor[] GROUP_HOT;
    public static final CrystalColor[] GROUP_NEUTRAL;
    public final int id;
    public final int color;

    private CrystalColor(int id, int color) {
        this.id = id;
        this.color = color;
    }

    public String getUnlocalizedName() {
        return "lightsaber.color." + this.name().toLowerCase(Locale.ROOT);
    }

    public String getLocalizedName() {
        return StatCollector.func_74838_a((String)this.getUnlocalizedName()).trim();
    }

    public float[] getRGB() {
        return COLOR_VALUES[this.ordinal()];
    }

    private static float[] getRGB(int hex) {
        float r = (float)((hex & 0xFF0000) >> 16) / 255.0f;
        float g = (float)((hex & 0xFF00) >> 8) / 255.0f;
        float b = (float)(hex & 0xFF) / 255.0f;
        return new float[]{r, g, b};
    }

    public static CrystalColor get(int id) {
        return CrystalColor.values()[Math.abs(id) % CrystalColor.values().length];
    }

    public static CrystalColor getRandom(Random rand) {
        return CrystalColor.values()[rand.nextInt(CrystalColor.values().length)];
    }

    public static CrystalColor getRandom() {
        return CrystalColor.getRandom(new Random());
    }

    static {
        COLOR_VALUES = new float[CrystalColor.values().length][3];
        GROUP_BLUE = new CrystalColor[]{DEEP_BLUE, MEDIUM_BLUE, LIGHT_BLUE, ARCTIC_BLUE, CYAN, INDIGO};
        GROUP_PURPLE = new CrystalColor[]{INDIGO, PURPLE, MAGENTA, PINK};
        GROUP_RED = new CrystalColor[]{PINK, RED, BLOOD_ORANGE};
        GROUP_ORANGE = new CrystalColor[]{BLOOD_ORANGE, AMBER};
        GROUP_YELLOW = new CrystalColor[]{AMBER, YELLOW, GOLD};
        GROUP_GREEN = new CrystalColor[]{LIME_GREEN, GREEN, MINT_GREEN, CYAN};
        GROUP_COLD = new CrystalColor[]{DEEP_BLUE, MEDIUM_BLUE, LIGHT_BLUE, ARCTIC_BLUE, WHITE, INDIGO, PURPLE, CYAN};
        GROUP_HOT = new CrystalColor[]{MAGENTA, PINK, RED, BLOOD_ORANGE, AMBER, YELLOW, GOLD};
        GROUP_NEUTRAL = new CrystalColor[]{PINK, LIME_GREEN, GREEN, MINT_GREEN, CYAN};
        for (CrystalColor color : CrystalColor.values()) {
            CrystalColor.COLOR_VALUES[color.ordinal()] = CrystalColor.getRGB(color.color);
        }
    }
}

