/*
 * Decompiled with CFR 0.152.
 */
package com.fiskmods.lightsabers.common.lightsaber;

import com.fiskmods.lightsabers.Lightsabers;
import com.fiskmods.lightsabers.common.hilt.Hilt;
import com.fiskmods.lightsabers.common.item.ItemDoubleLightsaber;
import com.fiskmods.lightsabers.common.item.ItemFocusingCrystal;
import com.fiskmods.lightsabers.common.item.ModItems;
import com.fiskmods.lightsabers.common.lightsaber.CrystalColor;
import com.fiskmods.lightsabers.common.lightsaber.FocusingCrystal;
import com.fiskmods.lightsabers.common.lightsaber.PartType;
import com.fiskmods.lightsabers.saberbuilder.AbstractLightsaberData;
import com.google.common.collect.Lists;
import fiskfille.utils.helper.FiskComparators;
import fiskfille.utils.helper.NBTHelper;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagLong;

public class LightsaberData
extends AbstractLightsaberData
implements NBTHelper.ISerializableObject<LightsaberData> {
    public static final LightsaberData EMPTY = new LightsaberData();
    public static final float MIN_LENGTH_CM = 19.0f;

    public LightsaberData() {
        this(0L);
    }

    public LightsaberData(long hashCode) {
        this.hash = hashCode;
    }

    @Override
    protected int getIDForObject(Hilt hilt) {
        return Hilt.REGISTRY.getIDForObject(hilt);
    }

    @Override
    protected Hilt getObjectById(int id) {
        return Hilt.REGISTRY.getObjectById(id);
    }

    @Override
    protected LightsaberData createNew(long hashCode) {
        return new LightsaberData(hashCode);
    }

    @Override
    public LightsaberData copy() {
        return (LightsaberData)super.copy();
    }

    @Override
    public LightsaberData strip() {
        return (LightsaberData)super.strip();
    }

    public boolean isTooShort() {
        return this.getHeightCm() < 19.0f;
    }

    public float[] getRGB(ItemStack itemstack) {
        if (itemstack.func_82833_r().equals("jeb_")) {
            EntityPlayer player = Lightsabers.proxy.getPlayer();
            int time = 25;
            float[][] rgb = CrystalColor.COLOR_VALUES;
            float f = ((float)(player.field_70173_aa % time) + Lightsabers.proxy.getRenderTick()) / (float)time;
            int i = player.field_70173_aa / time;
            int j = i % rgb.length;
            int k = (i + 1) % rgb.length;
            return new float[]{rgb[j][0] * (1.0f - f) + rgb[k][0] * f, rgb[j][1] * (1.0f - f) + rgb[k][1] * f, rgb[j][2] * (1.0f - f) + rgb[k][2] * f};
        }
        return this.getColor().getRGB();
    }

    @Override
    public LightsaberData set(PartType type, Hilt hilt) {
        return (LightsaberData)super.set(type, hilt);
    }

    @Override
    public LightsaberData set(Hilt ... hilt) {
        return (LightsaberData)super.set(hilt);
    }

    @Override
    public LightsaberData set(Hilt hilt) {
        return (LightsaberData)super.set(hilt);
    }

    @Override
    public LightsaberData set(CrystalColor color) {
        return (LightsaberData)super.set(color);
    }

    @Override
    public LightsaberData set(FocusingCrystal ... crystals) {
        return (LightsaberData)super.set(crystals);
    }

    @Override
    public LightsaberData add(FocusingCrystal crystal) {
        return (LightsaberData)super.add(crystal);
    }

    @Override
    public LightsaberData remove(FocusingCrystal crystal) {
        return (LightsaberData)super.remove(crystal);
    }

    public ItemStack create() {
        ItemStack itemstack = new ItemStack(ModItems.lightsaber);
        itemstack.func_77982_d(new NBTTagCompound());
        itemstack.func_77978_p().func_74772_a("Lightsaber", this.strip().hash);
        return itemstack;
    }

    @Override
    public NBTBase writeToNBT() {
        return new NBTTagLong(this.hash);
    }

    @Override
    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.hash);
    }

    public static LightsaberData readFromNBT(NBTTagCompound nbt) {
        if (nbt.func_150297_b("Lightsaber", 10)) {
            NBTTagCompound compound = nbt.func_74775_l("Lightsaber");
            LightsaberData data = new LightsaberData().set(CrystalColor.get(compound.func_74762_e("color")));
            if (compound.func_150297_b("FocusingCrystals", 11)) {
                for (int id : compound.func_74759_k("FocusingCrystals")) {
                    data.add(ItemFocusingCrystal.get(id));
                }
            }
            for (PartType type : PartType.values()) {
                data.set(type, (Hilt)Hilt.REGISTRY.getObject(Hilt.LEGACY_MAPPINGS.get(compound.func_74779_i(type.name().toLowerCase(Locale.ROOT)))));
            }
            nbt.func_82580_o("Lightsaber");
            nbt.func_74772_a("Lightsaber", data.hash);
            return data;
        }
        if (nbt.func_150297_b("Lightsaber", 99)) {
            return new LightsaberData(nbt.func_74763_f("Lightsaber")).strip();
        }
        if (nbt.func_150297_b("Lightsaber", 8)) {
            try {
                return new LightsaberData(Long.decode(nbt.func_74779_i("Lightsaber"))).strip();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return EMPTY;
    }

    public static LightsaberData get(ItemStack itemstack) {
        if (itemstack != null && itemstack.func_77942_o()) {
            return LightsaberData.readFromNBT(itemstack.func_77978_p());
        }
        return EMPTY;
    }

    public static Hilt get(ItemStack itemstack, PartType type) {
        return LightsaberData.get(itemstack).get(type);
    }

    public static Hilt[] getHilt(ItemStack itemstack) {
        return LightsaberData.get(itemstack).getHilt();
    }

    public static Hilt.Part getPart(ItemStack itemstack, PartType type) {
        return LightsaberData.get(itemstack).getPart(type);
    }

    public static float getHeight(ItemStack itemstack) {
        if (itemstack.func_77973_b() == ModItems.doubleLightsaber) {
            LightsaberData[] array = ItemDoubleLightsaber.get(itemstack);
            return array[0].getHeight() + array[1].getHeight();
        }
        return LightsaberData.get(itemstack).getHeight();
    }

    public static float getHeightCm(ItemStack itemstack) {
        return LightsaberData.getHeight(itemstack) * 0.575f;
    }

    public static CrystalColor getColor(ItemStack itemstack) {
        return LightsaberData.get(itemstack).getColor();
    }

    public static FocusingCrystal[] getFocusingCrystals(ItemStack itemstack) {
        return LightsaberData.get(itemstack).getFocusingCrystals();
    }

    public static boolean hasFocusingCrystal(ItemStack itemstack, FocusingCrystal crystal) {
        return LightsaberData.get(itemstack).hasFocusingCrystal(crystal);
    }

    public static ItemStack createRandom(Random rand, CrystalColor color) {
        Hilt[] hilt = new Hilt[4];
        for (int i = 0; i < 4; ++i) {
            hilt[i] = (Hilt)Hilt.REGISTRY.getRandom(rand);
        }
        LightsaberData data = new LightsaberData().set(hilt);
        if (data.isTooShort()) {
            return LightsaberData.createRandom(rand, color);
        }
        if (color == null) {
            color = CrystalColor.getRandom(rand);
        }
        data.set(color);
        if (rand.nextInt(10) == 0) {
            ArrayList crystals = Lists.newArrayList((Object[])FocusingCrystal.values());
            Collections.sort(crystals, FiskComparators.random(rand));
            data.add((FocusingCrystal)((Object)crystals.get(0)));
            if (rand.nextInt(20) == 0) {
                data.add((FocusingCrystal)((Object)crystals.get(1)));
            }
        }
        return data.create();
    }

    public static ItemStack createRandom(Random rand) {
        return LightsaberData.createRandom(rand, null);
    }

    public static class Adapter
    implements NBTHelper.ISaveAdapter<LightsaberData> {
        @Override
        public LightsaberData readFromNBT(NBTBase tag) {
            if (tag instanceof NBTBase.NBTPrimitive) {
                return new LightsaberData(((NBTBase.NBTPrimitive)tag).func_150291_c());
            }
            return null;
        }

        @Override
        public LightsaberData fromBytes(ByteBuf buf) {
            return new LightsaberData(buf.readLong());
        }
    }
}

