/*
 * Decompiled with CFR 0.152.
 */
package com.fiskmods.lightsabers.common.network;

import com.fiskmods.lightsabers.common.data.ALData;
import cpw.mods.fml.relauncher.Side;
import fiskfille.utils.Log;
import fiskfille.utils.common.network.AbstractMessage;
import fiskfille.utils.helper.NBTHelper;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;

public class MessagePlayerData
extends AbstractMessage<MessagePlayerData> {
    private int id;
    private ALData type;
    private Object value;

    public MessagePlayerData() {
    }

    public MessagePlayerData(EntityPlayer player, ALData data, Object obj) {
        this.id = player.func_145782_y();
        this.type = data;
        this.value = obj;
    }

    public void fromBytes(ByteBuf buf) {
        this.id = buf.readInt();
        this.type = ALData.REGISTRY.getObjectById(buf.readShort());
        this.value = NBTHelper.fromBytes(buf, this.type.typeClass);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.id);
        buf.writeShort(ALData.REGISTRY.getIDForObject(this.type));
        NBTHelper.toBytes(buf, this.value);
    }

    @Override
    public void receive() throws AbstractMessage.MessageException {
        Side senderSide;
        EntityPlayer player = this.getSender(this.id);
        Side side = senderSide = this.context.side.isClient() ? Side.SERVER : Side.CLIENT;
        if (!this.type.hasPerms(senderSide)) {
            Log.warn("Player %s tried to set %s to %s on illegal side %s!", player.func_70005_c_(), this.type, this.value, senderSide);
            return;
        }
        if (this.context.side.isClient()) {
            this.type.setWithoutNotify((Entity)player, this.value);
        } else {
            this.type.set(player, this.value);
        }
    }
}

