/*
 * Decompiled with CFR 0.152.
 */
package com.fiskmods.lightsabers.common.network;

import com.fiskmods.lightsabers.common.data.ALData;
import com.fiskmods.lightsabers.common.data.ALPlayerData;
import com.fiskmods.lightsabers.common.data.effect.StatusEffect;
import com.google.common.collect.Lists;
import fiskfille.utils.common.network.AbstractMessage;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;

public abstract class MessageSyncBase<REQ extends MessageSyncBase>
extends AbstractMessage<REQ> {
    protected Map<ALData, Object> playerData;
    protected List<StatusEffect> activeEffects;

    public MessageSyncBase() {
    }

    protected MessageSyncBase(EntityPlayer player) {
        this.playerData = ALPlayerData.getData((EntityPlayer)player).data;
        this.activeEffects = StatusEffect.get((EntityLivingBase)player);
    }

    public void fromBytes(ByteBuf buf) {
        this.playerData = ALData.fromBytes(buf, new HashMap<ALData, Object>());
        this.activeEffects = Lists.newArrayList();
        int length = buf.readInt();
        for (int j = 0; j < length; ++j) {
            StatusEffect effect = StatusEffect.fromBytes(buf);
            if (effect == null) continue;
            this.activeEffects.add(effect);
        }
    }

    public void toBytes(ByteBuf buf) {
        ALData.toBytes(buf, this.playerData);
        buf.writeInt(this.activeEffects.size());
        for (StatusEffect effect : this.activeEffects) {
            effect.toBytes(buf);
        }
    }
}

