/*
 * Decompiled with CFR 0.152.
 */
package com.fiskmods.lightsabers.common.network;

import com.fiskmods.lightsabers.common.data.ALEntityData;
import com.fiskmods.lightsabers.common.data.effect.StatusEffect;
import com.google.common.collect.Lists;
import fiskfille.utils.common.network.AbstractMessage;
import io.netty.buffer.ByteBuf;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;

public class MessageUpdateEffects
extends AbstractMessage<MessageUpdateEffects> {
    private int id;
    private List<StatusEffect> activeEffects;

    public MessageUpdateEffects() {
    }

    public MessageUpdateEffects(EntityLivingBase entity, List<StatusEffect> list) {
        this.id = entity.func_145782_y();
        this.activeEffects = list;
    }

    public void fromBytes(ByteBuf buf) {
        this.id = buf.readInt();
        this.activeEffects = Lists.newArrayList();
        int length = buf.readInt();
        for (int i = 0; i < length; ++i) {
            StatusEffect effect = StatusEffect.fromBytes(buf);
            if (effect == null) continue;
            this.activeEffects.add(effect);
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.id);
        buf.writeInt(this.activeEffects.size());
        for (StatusEffect effect : this.activeEffects) {
            effect.toBytes(buf);
        }
    }

    @Override
    public void receive() throws AbstractMessage.MessageException {
        ALEntityData.getData((EntityLivingBase)this.getEntity(EntityLivingBase.class, (int)this.id)).activeEffects = this.activeEffects;
        if (!this.activeEffects.isEmpty()) {
            Collections.sort(this.activeEffects);
        }
    }
}

