/*
 * Decompiled with CFR 0.152.
 */
package com.fiskmods.lightsabers.common.network;

import com.fiskmods.lightsabers.Lightsabers;
import com.fiskmods.lightsabers.client.sound.ALSounds;
import com.fiskmods.lightsabers.common.data.ALData;
import com.fiskmods.lightsabers.common.data.ALPlayerData;
import com.fiskmods.lightsabers.common.force.Power;
import com.fiskmods.lightsabers.common.force.PowerStats;
import com.fiskmods.lightsabers.common.force.PowerType;
import com.fiskmods.lightsabers.common.network.ALNetworkManager;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.StringUtils;

public class PacketRightClick
implements IMessage {
    public int id;
    private Power power;

    public PacketRightClick() {
    }

    public PacketRightClick(EntityPlayer player, Power p) {
        this.id = player.func_145782_y();
        this.power = p;
    }

    public void fromBytes(ByteBuf buf) {
        this.id = buf.readInt();
        this.power = Power.getPowerFromName(ByteBufUtils.readUTF8String((ByteBuf)buf));
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.id);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.power.getName());
    }

    public static void onMessage(EntityPlayer player, Power power, Side side) {
        ALPlayerData data = ALPlayerData.getData(player);
        PowerStats stats = power.powerStats;
        float force = ((Float)ALData.FORCE_POWER.get((Entity)player)).floatValue();
        if (force >= power.getUseCost(player)) {
            if (power.powerStats.powerType == PowerType.PER_USE) {
                if (power.powerEffect.execute(player, side)) {
                    String sound = power.powerEffect.getCastSound(power.getSide());
                    if (!StringUtils.func_151246_b((String)sound)) {
                        player.func_85030_a(sound, power.powerEffect.getCastSoundVolume(power.getSide()), power.powerEffect.getCastSoundPitch(power.getSide()));
                    }
                    ALData.FORCE_POWER.incrWithoutNotify((Entity)player, Float.valueOf(-power.getUseCost(player)));
                    ALData.USE_POWER_COOLDOWN.setWithoutNotify((Entity)player, 20);
                } else if (side.isClient()) {
                    player.func_85030_a(ALSounds.player_force_fail, 1.0f, 1.0f);
                }
            } else if (power.powerEffect.execute(player, side)) {
                ALData.FORCE_POWER.incrWithoutNotify((Entity)player, Float.valueOf(-power.getUseCost(player) / 20.0f));
            }
        }
    }

    public static class Handler
    implements IMessageHandler<PacketRightClick, IMessage> {
        public IMessage onMessage(PacketRightClick message, MessageContext ctx) {
            EntityPlayer clientPlayer;
            Object object = clientPlayer = ctx.side.isClient() ? Lightsabers.proxy.getPlayer() : ctx.getServerHandler().field_147369_b;
            if (clientPlayer != null && clientPlayer.field_70170_p.func_73045_a(message.id) instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)clientPlayer.field_70170_p.func_73045_a(message.id);
                if (ctx.side.isServer() || player != clientPlayer) {
                    PacketRightClick.onMessage(player, message.power, ctx.side);
                    if (ctx.side.isServer()) {
                        ALNetworkManager.wrapper.sendToDimension((IMessage)new PacketRightClick(player, message.power), clientPlayer.field_71093_bK);
                    }
                }
            }
            return null;
        }
    }
}

