/*
 * Decompiled with CFR 0.152.
 */
package com.fiskmods.lightsabers.common.tileentity;

import com.fiskmods.lightsabers.common.hilt.Hilt;
import com.fiskmods.lightsabers.common.item.ItemCrystal;
import com.fiskmods.lightsabers.common.item.ItemDoubleLightsaber;
import com.fiskmods.lightsabers.common.item.ItemFocusingCrystal;
import com.fiskmods.lightsabers.common.item.ItemLightsaberBase;
import com.fiskmods.lightsabers.common.item.ItemLightsaberPart;
import com.fiskmods.lightsabers.common.item.ModItems;
import com.fiskmods.lightsabers.common.lightsaber.CrystalColor;
import com.fiskmods.lightsabers.common.lightsaber.FocusingCrystal;
import com.fiskmods.lightsabers.common.lightsaber.LightsaberData;
import com.fiskmods.lightsabers.common.lightsaber.PartType;
import com.fiskmods.lightsabers.helper.ALHelper;
import com.google.common.collect.ImmutableMap;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;

public class TileEntityDisassemblyStation
extends TileEntity
implements ISidedInventory {
    public static final int TICKS_DISASSEMBLY = 2400;
    public static final int INPUT = 0;
    public static final int FUEL = 1;
    private static final int[] SLOTS_TOP = new int[]{0};
    private static final int[] SLOTS_BOTTOM = new int[]{2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 1};
    private static final int[] SLOTS_SIDES = new int[]{0, 1};
    private ItemStack[] itemstacks = new ItemStack[17];
    public int fuelTicks;
    public int maxFuelTicks;
    public int progress;
    private static final Map<ItemStack, Integer> FUELS = new HashMap<ItemStack, Integer>();

    public void func_145845_h() {
        boolean burning = this.fuelTicks > 0;
        boolean dirty = false;
        if (this.fuelTicks > 0) {
            --this.fuelTicks;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.fuelTicks != 0 || this.itemstacks[1] != null && this.itemstacks[0] != null) {
                if (this.fuelTicks == 0 && TileEntityDisassemblyStation.canDisassemble(this.itemstacks[0])) {
                    this.maxFuelTicks = this.fuelTicks = TileEntityDisassemblyStation.getItemBurnTime(this.itemstacks[1]);
                    if (this.fuelTicks > 0) {
                        dirty = true;
                        if (this.itemstacks[1] != null) {
                            --this.itemstacks[1].field_77994_a;
                            if (this.itemstacks[1].field_77994_a <= 0) {
                                this.itemstacks[1] = null;
                            }
                        }
                    }
                }
                if (this.isBurning() && TileEntityDisassemblyStation.canDisassemble(this.itemstacks[0])) {
                    ++this.progress;
                    if (this.progress >= 2400) {
                        this.progress = 0;
                        this.disassembleItem();
                        dirty = true;
                    }
                } else {
                    this.progress = 0;
                }
            }
            if (burning != this.fuelTicks > 0) {
                dirty = true;
            }
        }
        if (dirty) {
            this.func_70296_d();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int getCookProgressScaled(int scale) {
        return this.progress * scale / 2400;
    }

    @SideOnly(value=Side.CLIENT)
    public int getBurnTimeRemainingScaled(int scale) {
        if (this.maxFuelTicks == 0) {
            this.maxFuelTicks = 200;
        }
        return this.fuelTicks * scale / this.maxFuelTicks;
    }

    public boolean isBurning() {
        return this.fuelTicks > 0;
    }

    public static boolean canDisassemble(ItemStack stack) {
        return stack != null && stack.func_77973_b() instanceof ItemLightsaberBase;
    }

    public void disassembleItem() {
        if (TileEntityDisassemblyStation.canDisassemble(this.itemstacks[0])) {
            Map<ItemStack, Float> drops = TileEntityDisassemblyStation.getOutput(this.itemstacks[0]);
            for (Map.Entry<ItemStack, Float> e : drops.entrySet()) {
                if (!(e.getValue().floatValue() > this.field_145850_b.field_73012_v.nextFloat())) continue;
                this.addOutputItem(e.getKey());
            }
            --this.itemstacks[0].field_77994_a;
            if (this.itemstacks[0].field_77994_a <= 0) {
                this.itemstacks[0] = null;
            }
        }
    }

    public void addOutputItem(ItemStack stack) {
        stack = stack.func_77946_l();
        for (int i = 2; i < this.func_70302_i_(); ++i) {
            if (this.itemstacks[i] == null) {
                this.itemstacks[i] = stack.func_77946_l();
                return;
            }
            if (!ItemStack.func_77989_b((ItemStack)stack, (ItemStack)this.itemstacks[i])) continue;
            int j = Math.min(stack.field_77994_a, stack.func_77976_d() - this.itemstacks[i].field_77994_a);
            this.itemstacks[i].field_77994_a += j;
            stack.field_77994_a -= j;
            if (stack.field_77994_a > 0) continue;
            return;
        }
        ALHelper.dropItem(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, stack, this.field_145850_b.field_73012_v);
    }

    public static Map<ItemStack, Float> getOutput(ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemDoubleLightsaber) {
            LightsaberData[] data = ItemDoubleLightsaber.get(stack);
            Map<ItemStack, Float> drops = TileEntityDisassemblyStation.getOutput(data[0], true);
            drops.putAll(TileEntityDisassemblyStation.getOutput(data[1], true));
            return drops;
        }
        return TileEntityDisassemblyStation.getOutput(LightsaberData.get(stack), !stack.func_77942_o() || !stack.func_77978_p().func_74764_b("Special"));
    }

    public static Map<ItemStack, Float> getOutput(LightsaberData data, boolean salvageColor) {
        int n;
        LinkedHashMap<ItemStack, Float> drops = new LinkedHashMap<ItemStack, Float>();
        drops.put(new ItemStack(ModItems.circuitry), Float.valueOf(0.25f));
        if (data.isHiltUniform()) {
            PartType[] partTypeArray = PartType.values();
            int n2 = partTypeArray.length;
            for (n = 0; n < n2; ++n) {
                PartType type = partTypeArray[n];
                drops.put(ItemLightsaberPart.create(type, data.get(type)), Float.valueOf(1.0f));
            }
        } else {
            FocusingCrystal[] hilts = new HashMap();
            for (Hilt hilt : data.getHilt()) {
                hilts.put(hilt, hilts.getOrDefault(hilt, -1) + 1);
            }
            PartType[] partTypeArray = PartType.values();
            n = partTypeArray.length;
            for (int type = 0; type < n; ++type) {
                PartType type2 = partTypeArray[type];
                Hilt hilt = data.get(type2);
                drops.put(ItemLightsaberPart.create(type2, hilt), Float.valueOf(0.66f + 0.05f * (float)((Integer)hilts.get(hilt)).intValue()));
            }
        }
        for (FocusingCrystal crystal : data.getFocusingCrystals()) {
            drops.put(ItemFocusingCrystal.create(crystal), Float.valueOf(0.725f));
        }
        if (salvageColor) {
            CrystalColor color = data.getColor();
            drops.put(ItemCrystal.create(color), Float.valueOf(0.35f + 0.125f * (float)ItemCrystal.rarityMap.get((Object)color).ordinal()));
        }
        return drops;
    }

    public int func_70302_i_() {
        return this.itemstacks.length;
    }

    public ItemStack func_70301_a(int slot) {
        return this.itemstacks[slot];
    }

    public ItemStack func_70298_a(int slot, int amount) {
        if (this.itemstacks[slot] != null) {
            if (this.itemstacks[slot].field_77994_a <= amount) {
                return this.func_70304_b(slot);
            }
            ItemStack stack = this.itemstacks[slot].func_77979_a(amount);
            if (this.itemstacks[slot].field_77994_a <= 0) {
                this.itemstacks[slot] = null;
            }
            return stack;
        }
        return null;
    }

    public ItemStack func_70304_b(int slot) {
        if (this.itemstacks[slot] != null) {
            ItemStack stack = this.itemstacks[slot];
            this.itemstacks[slot] = null;
            return stack;
        }
        return null;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.itemstacks[slot] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return "gui.disassembly_station";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 1)).func_72314_b(1.5, 1.0, 1.5);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagList list = nbt.func_150295_c("Items", 10);
        this.itemstacks = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound tag = list.func_150305_b(i);
            byte slot = tag.func_74771_c("Slot");
            if (slot < 0 || slot >= this.itemstacks.length) continue;
            this.itemstacks[slot] = ItemStack.func_77949_a((NBTTagCompound)tag);
        }
        this.fuelTicks = nbt.func_74765_d("BurnTime");
        this.progress = nbt.func_74765_d("DisassemblyTime");
        this.maxFuelTicks = TileEntityDisassemblyStation.getItemBurnTime(this.itemstacks[1]);
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74777_a("BurnTime", (short)this.fuelTicks);
        nbt.func_74777_a("DisassemblyTime", (short)this.progress);
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.itemstacks.length; ++i) {
            if (this.itemstacks[i] == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a("Slot", (byte)i);
            list.func_74742_a((NBTBase)this.itemstacks[i].func_77955_b(tag));
        }
        nbt.func_74782_a("Items", (NBTBase)list);
    }

    public int func_70297_j_() {
        return 64;
    }

    public static int getItemBurnTime(ItemStack stack) {
        return stack != null ? TileEntityDisassemblyStation.getFuelValue(stack) : 0;
    }

    public static boolean isItemFuel(ItemStack stack) {
        return TileEntityDisassemblyStation.getItemBurnTime(stack) > 0;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return slot == 0 && TileEntityDisassemblyStation.canDisassemble(stack) || slot == 1 && TileEntityDisassemblyStation.isItemFuel(stack);
    }

    public int[] func_94128_d(int side) {
        return side == 0 ? SLOTS_BOTTOM : (side == 1 ? SLOTS_TOP : SLOTS_SIDES);
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return this.func_94041_b(slot, stack);
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return side != 0 || slot != 1;
    }

    public static void registerFuel(ItemStack stack, int ticks) {
        FUELS.put(stack, ticks);
    }

    public static int getFuelValue(ItemStack stack) {
        for (Map.Entry<ItemStack, Integer> e : FUELS.entrySet()) {
            if (!e.getKey().func_77969_a(stack)) continue;
            return e.getValue();
        }
        return 0;
    }

    public static ImmutableMap<ItemStack, Integer> getFuels() {
        return ImmutableMap.copyOf(FUELS);
    }

    static {
        TileEntityDisassemblyStation.registerFuel(new ItemStack(Items.field_151137_ax), 300);
        TileEntityDisassemblyStation.registerFuel(new ItemStack(Blocks.field_150451_bX), 2700);
    }
}

