/*
 * Decompiled with CFR 0.152.
 */
package com.fiskmods.lightsabers.common.tileentity;

import com.fiskmods.lightsabers.common.block.BlockSithCoffin;
import java.util.Random;
import net.minecraft.block.BlockDirectional;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;

public class TileEntitySithCoffin
extends TileEntity
implements IInventory {
    public static final int LID_OPEN_MAX = 60;
    private ItemStack[] itemstacks = new ItemStack[28];
    public boolean hasBeenOpened = false;
    public boolean isLidOpen = false;
    public int lidOpenTimer = 0;
    public int prevLidOpenTimer = 0;

    public void func_145845_h() {
        this.prevLidOpenTimer = this.lidOpenTimer;
        if (!this.isLidOpen) {
            if (this.lidOpenTimer > 0) {
                --this.lidOpenTimer;
            }
        } else if (this.lidOpenTimer < 60) {
            ++this.lidOpenTimer;
        }
        int metadata = this.func_145832_p();
        int dir = BlockDirectional.func_149895_l((int)metadata);
        if (!BlockSithCoffin.isBlockFrontOfCoffin(metadata) && !this.hasBeenOpened) {
            if (this.lidOpenTimer < 60) {
                double radius = 0.5;
                for (double y = 0.0; y <= (double)((float)this.lidOpenTimer / 5.0f); y += 0.025) {
                    Random rand = new Random();
                    double d = Math.cos(y * 2.0);
                    double x = radius * Math.cos(y + (double)((float)this.lidOpenTimer / 2.0f)) * d;
                    double z = radius * Math.sin(y + (double)((float)this.lidOpenTimer / 2.0f)) * d;
                    double motionX = (double)((rand.nextFloat() - 0.5f) * 0.5f) * d;
                    double motionY = (rand.nextFloat() - 0.5f) * 0.1f;
                    double motionZ = (double)((rand.nextFloat() - 0.5f) * 0.5f) * d;
                    this.field_145850_b.func_72869_a("smoke", (double)((float)this.field_145851_c + 0.5f) + x + (double)((float)BlockSithCoffin.DIRECTIONS[dir][0] * 0.5f), (double)((float)this.field_145848_d + 0.8f) + y, (double)((float)this.field_145849_e + 0.5f) + z + (double)((float)BlockSithCoffin.DIRECTIONS[dir][1] * 0.5f), motionX, motionY, motionZ);
                }
            } else {
                this.hasBeenOpened = true;
            }
        }
    }

    public float getLidOpenTimer(float partialTicks) {
        float f = this.lidOpenTimer - this.prevLidOpenTimer;
        return ((float)this.prevLidOpenTimer + f * partialTicks) / 60.0f;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 1)).func_72314_b(1.0, 0.0, 1.0);
    }

    public int func_70302_i_() {
        return this.itemstacks.length;
    }

    public ItemStack func_70301_a(int slot) {
        return this.itemstacks[slot];
    }

    public ItemStack func_70298_a(int slot, int amount) {
        if (this.itemstacks[slot] != null) {
            if (this.itemstacks[slot].field_77994_a <= amount) {
                ItemStack itemstack = this.itemstacks[slot];
                this.itemstacks[slot] = null;
                return itemstack;
            }
            ItemStack itemstack = this.itemstacks[slot].func_77979_a(amount);
            if (this.itemstacks[slot].field_77994_a == 0) {
                this.itemstacks[slot] = null;
            }
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int slot) {
        if (this.itemstacks[slot] != null) {
            ItemStack itemstack = this.itemstacks[slot];
            this.itemstacks[slot] = null;
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int slot, ItemStack itemstack) {
        this.itemstacks[slot] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return "gui.sith_coffin";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagList nbttaglist = nbt.func_150295_c("Items", 10);
        this.itemstacks = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            byte slot = nbttagcompound1.func_74771_c("Slot");
            if (slot < 0 || slot >= this.itemstacks.length) continue;
            this.itemstacks[slot] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
        this.hasBeenOpened = nbt.func_74767_n("HasBeenOpened");
        this.isLidOpen = nbt.func_74767_n("IsLidOpen");
        this.lidOpenTimer = nbt.func_74762_e("LidOpenTimer");
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.itemstacks.length; ++i) {
            if (this.itemstacks[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            this.itemstacks[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbt.func_74782_a("Items", (NBTBase)nbttaglist);
        nbt.func_74757_a("HasBeenOpened", this.hasBeenOpened);
        nbt.func_74757_a("IsLidOpen", this.isLidOpen);
        nbt.func_74768_a("LidOpenTimer", this.lidOpenTimer);
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this ? false : player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return true;
    }

    public Packet func_145844_m() {
        NBTTagCompound syncData = new NBTTagCompound();
        this.func_145841_b(syncData);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, syncData);
    }

    public void onDataPacket(NetworkManager netManager, S35PacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }
}

