/*
 * Decompiled with CFR 0.152.
 */
package com.fiskmods.lightsabers.helper;

import com.fiskmods.lightsabers.client.render.Lightning;
import com.fiskmods.lightsabers.common.data.ALData;
import com.fiskmods.lightsabers.common.data.effect.Effect;
import com.fiskmods.lightsabers.common.data.effect.StatusEffect;
import com.fiskmods.lightsabers.common.force.ForceSide;
import com.fiskmods.lightsabers.common.force.Power;
import com.fiskmods.lightsabers.common.force.PowerData;
import com.fiskmods.lightsabers.helper.ALPredicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import fiskfille.utils.helper.VectorHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class ALHelper {
    public static int getXpBarCap(int level) {
        return level >= 30 ? 62 + (level - 30) * 7 : (level >= 15 ? 17 + (level - 15) * 3 : 17);
    }

    public static int getTotalXp(EntityPlayer player) {
        int totalXp = Math.round((float)player.func_71050_bK() * player.field_71106_cc);
        for (int i = 0; i < player.field_71068_ca; ++i) {
            totalXp += ALHelper.getXpBarCap(i);
        }
        return totalXp;
    }

    public static int getTotalXpToReachLevel(EntityPlayer player, int level) {
        int i = 0;
        for (int j = 0; j < level; ++j) {
            i += ALHelper.getXpBarCap(j + 1);
        }
        return i;
    }

    public static void removeExperience(EntityPlayer player, int amount) {
        player.field_71067_cb = ALHelper.getTotalXp(player);
        if (player.field_71106_cc > 0.0f && player.field_71068_ca >= 0) {
            --player.field_71067_cb;
            player.field_71106_cc -= 1.0f / (float)player.func_71050_bK();
        } else if (player.field_71068_ca > 0) {
            --player.field_71067_cb;
            --player.field_71068_ca;
            player.field_71106_cc = (float)(player.func_71050_bK() - 2) / (float)player.func_71050_bK();
        }
    }

    public static String getConventionalName(String s) {
        String s1 = ALHelper.getUnconventionalName(s);
        return s1.substring(0, 1).toLowerCase(Locale.ROOT) + s1.substring(1);
    }

    public static String getUnconventionalName(String s) {
        s = s.toLowerCase(Locale.ROOT);
        for (int i = 0; i < s.length(); ++i) {
            if (i <= 0 || s.charAt(i - 1) != '_' || i >= s.length()) continue;
            s = s.substring(0, i) + s.substring(i, i + 1).toUpperCase() + s.substring(i + 1);
        }
        s = s.replace(" ", "").replace("'", "").replace("/", "").replace("\\", "").replace("_", "").replace("-", "").replace("(", "").replace(")", "");
        return s.substring(0, 1).toUpperCase() + s.substring(1);
    }

    public static List<Power> getPowers(ForceSide side) {
        ArrayList list = Lists.newArrayList();
        for (Power power : Power.POWERS) {
            if (side != power.getSide()) continue;
            list.add(power);
        }
        return list;
    }

    public static float getCompletion(EntityPlayer player, ForceSide side) {
        int powers = ALHelper.getPowers(side).size();
        float f = 0.0f;
        for (PowerData data : ALData.POWERS.get((Entity)player)) {
            if (!data.isUnlocked() || data.power == side.getPower() || side != data.power.getSide()) continue;
            f += 1.0f / (float)(powers - 1);
        }
        return f;
    }

    public static float getForceBalance(EntityPlayer player) {
        float light = ALHelper.getCompletion(player, ForceSide.LIGHT);
        float dark = ALHelper.getCompletion(player, ForceSide.DARK);
        if (light != 0.0f || dark != 0.0f) {
            if (light > dark) {
                return 1.0f - dark / light;
            }
            if (dark > light) {
                return -1.0f + light / dark;
            }
        }
        return 0.0f;
    }

    public static byte getBasePower(EntityPlayer player) {
        return ALData.POWERS.get((Entity)player).getBasePower();
    }

    public static int getForcePowerMax(EntityPlayer player) {
        return ALData.POWERS.get((Entity)player).getForceMax();
    }

    public static float getForcePowerRegen(EntityPlayer player) {
        return ALData.POWERS.get((Entity)player).getRegen();
    }

    public static List<PowerData> getRelevantPowers(EntityPlayer player) {
        return Lists.newArrayList((Iterable)Iterables.filter((Iterable)ALData.POWERS.get((Entity)player), ALPredicates.isRelevant(player)));
    }

    public static Set<Power> getUnlockedChildren(EntityPlayer player, Power power) {
        return Sets.filter(power.children, ALPredicates.isUnlocked(player));
    }

    public static boolean isAlly(EntityLivingBase to, EntityLivingBase entity) {
        if (entity instanceof EntityTameable && ((EntityTameable)entity).func_70902_q() == to) {
            return true;
        }
        if (entity instanceof EntityMob || entity.func_70643_av() == to) {
            return false;
        }
        if (entity.func_96124_cp() != null && entity.func_96124_cp().func_142054_a(to.func_96124_cp())) {
            return true;
        }
        if (to.func_110144_aD() == entity) {
            return to.func_142013_aG() > 1200;
        }
        return to.field_70154_o == entity;
    }

    public static EntityLivingBase getForceLightningTarget(EntityLivingBase caster) {
        StatusEffect effect = StatusEffect.get(caster, Effect.LIGHTNING);
        if (effect != null) {
            Vec3 src = VectorHelper.getOffsetCoords(caster, 0.0, 0.0, 0.0);
            Vec3 dst = VectorHelper.getOffsetCoords(caster, 0.0, 0.0, 7.0);
            Vec3 hitVec = null;
            MovingObjectPosition rayTrace = caster.field_70170_p.func_72933_a(VectorHelper.copy(src), VectorHelper.copy(dst));
            hitVec = rayTrace == null ? dst : rayTrace.field_72307_f;
            double distance = caster.func_70011_f(hitVec.field_72450_a, hitVec.field_72448_b, hitVec.field_72449_c);
            block0: for (double point = 0.0; point <= distance; point += 0.15) {
                Vec3 particleVec = VectorHelper.getOffsetCoords(caster, 0.0, 0.0, point);
                for (EntityLivingBase entity : VectorHelper.getEntitiesNear(EntityLivingBase.class, caster.field_70170_p, particleVec, 1.0)) {
                    if (entity == null || entity == caster || caster.field_70154_o == entity) continue;
                    hitVec.field_72450_a = entity.field_70165_t;
                    hitVec.field_72448_b = entity.field_70163_u;
                    hitVec.field_72449_c = entity.field_70161_v;
                    rayTrace = new MovingObjectPosition((Entity)entity, hitVec);
                    distance = caster.func_70011_f(hitVec.field_72450_a, hitVec.field_72448_b, hitVec.field_72449_c);
                    continue block0;
                }
            }
            if (rayTrace != null && rayTrace.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY && rayTrace.field_72308_g instanceof EntityLivingBase) {
                EntityLivingBase entity = (EntityLivingBase)rayTrace.field_72308_g;
                return entity;
            }
        }
        return null;
    }

    public static Lightning createLightning(Vec3 color, long seed, float length) {
        Random rand = new Random();
        if (seed != 0L) {
            rand.setSeed(seed);
        }
        Lightning lightning = new Lightning(rand.nextFloat() * length, color).setRotation(rand.nextFloat() * 360.0f, rand.nextFloat() * 360.0f, rand.nextFloat() * 360.0f);
        ALHelper.branchLightning(lightning, rand, length, 0);
        return lightning;
    }

    private static void branchLightning(Lightning lightning, Random rand, float length, int branch) {
        Lightning lightning1 = new Lightning(rand.nextFloat() * length).setRotation(rand.nextFloat() * rand.nextFloat() * 90.0f, rand.nextFloat() * rand.nextFloat() * 90.0f, rand.nextFloat() * rand.nextFloat() * 90.0f);
        lightning.addChild(lightning1);
        if (branch < 10 && rand.nextDouble() < 1.0 - (double)branch * 0.1) {
            ALHelper.branchLightning(lightning1, rand, length, ++branch);
        }
        if (rand.nextDouble() < 0.1) {
            ALHelper.branchLightning(lightning, rand, length, 7);
        }
    }

    public static void dropItem(World world, int x, int y, int z, ItemStack stack, Random rand) {
        float f = rand.nextFloat() * 0.8f + 0.1f;
        float f1 = rand.nextFloat() * 0.8f + 0.1f;
        float f2 = rand.nextFloat() * 0.8f + 0.1f;
        while (stack.field_77994_a > 0) {
            int i = rand.nextInt(21) + 10;
            if (i > stack.field_77994_a) {
                i = stack.field_77994_a;
            }
            stack.field_77994_a -= i;
            EntityItem entity = new EntityItem(world, (double)((float)x + f), (double)((float)y + f1), (double)((float)z + f2), new ItemStack(stack.func_77973_b(), i, stack.func_77960_j()));
            if (stack.func_77942_o()) {
                entity.func_92059_d().func_77982_d((NBTTagCompound)stack.func_77978_p().func_74737_b());
            }
            float f3 = 0.05f;
            entity.field_70159_w = (float)rand.nextGaussian() * f3;
            entity.field_70181_x = (float)rand.nextGaussian() * f3 + 0.2f;
            entity.field_70179_y = (float)rand.nextGaussian() * f3;
            world.func_72838_d((Entity)entity);
        }
    }
}

