/*
 * Decompiled with CFR 0.152.
 */
package com.fiskmods.lightsabers.helper;

import com.fiskmods.lightsabers.client.model.ModelLightsaberBlade;
import com.fiskmods.lightsabers.client.render.Lightning;
import com.fiskmods.lightsabers.client.render.hilt.HiltRenderer;
import com.fiskmods.lightsabers.common.config.ModConfig;
import com.fiskmods.lightsabers.common.data.effect.Effect;
import com.fiskmods.lightsabers.common.data.effect.StatusEffect;
import com.fiskmods.lightsabers.common.event.ClientEventHandler;
import com.fiskmods.lightsabers.common.hilt.Hilt;
import com.fiskmods.lightsabers.common.item.ItemDoubleLightsaber;
import com.fiskmods.lightsabers.common.item.ItemLightsaberBase;
import com.fiskmods.lightsabers.common.item.ModItems;
import com.fiskmods.lightsabers.common.lightsaber.LightsaberData;
import com.fiskmods.lightsabers.common.lightsaber.PartType;
import java.awt.Color;
import java.nio.FloatBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.shader.ShaderGroup;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class ALRenderHelper {
    private static Minecraft mc = Minecraft.func_71410_x();
    public static final ResourceLocation SHADER_GRAY = new ResourceLocation("shaders/post/desaturate.json");
    public static final ResourceLocation SHADER_BLUE = new ResourceLocation("lightsabers", "shaders/post/blue.json");
    public static final ResourceLocation SHADER_BLUR = new ResourceLocation("lightsabers", "shaders/post/mild_phosphor.json");
    private static final ModelLightsaberBlade LIGHTSABER_BLADE = new ModelLightsaberBlade(38);
    private static final ModelLightsaberBlade CROSSGUARD_BLADE = new ModelLightsaberBlade(4);
    public static boolean overrideColor = false;
    private static float lastBrightnessX;
    private static float lastBrightnessY;
    public static final int LIGHTING_LUMINOUS = 61680;

    public static void setLighting(int lighting) {
        ALRenderHelper.storeLighting();
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)(lighting % 65536 / 255), (float)(lighting / 65536 / 255));
    }

    public static void storeLighting() {
        lastBrightnessX = OpenGlHelper.lastBrightnessX;
        lastBrightnessY = OpenGlHelper.lastBrightnessY;
    }

    public static void resetLighting() {
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lastBrightnessX, (float)lastBrightnessY);
    }

    public static void setGlColor(Color color, float alpha) {
        GL11.glColor4f((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)alpha);
    }

    public static void setGlColor(Color color) {
        ALRenderHelper.setGlColor(color, (float)color.getAlpha() / 255.0f);
    }

    public static void setVecColor(Vec3 vec) {
        GL11.glColor4f((float)((float)vec.field_72450_a), (float)((float)vec.field_72448_b), (float)((float)vec.field_72449_c), (float)1.0f);
    }

    public static void applyColorFromItemStack(ItemStack itemstack, int pass) {
        int color = itemstack.func_77973_b().func_82790_a(itemstack, pass);
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        GL11.glColor4f((float)r, (float)g, (float)b, (float)1.0f);
    }

    public static Vec3 getColorFromHex(int hex) {
        float r = (float)(hex >> 16 & 0xFF) / 255.0f;
        float g = (float)(hex >> 8 & 0xFF) / 255.0f;
        float b = (float)(hex & 0xFF) / 255.0f;
        return Vec3.func_72443_a((double)r, (double)g, (double)b);
    }

    public static int getHex(Vec3 color) {
        int r = (int)Math.round(color.field_72450_a * 255.0);
        int g = (int)Math.round(color.field_72448_b * 255.0);
        int b = (int)Math.round(color.field_72449_c * 255.0);
        return r << 16 | g << 8 | b;
    }

    public static void setAlpha(float alpha) {
        FloatBuffer floatBuffer = BufferUtils.createFloatBuffer((int)16);
        floatBuffer.rewind();
        GL11.glGetFloat((int)2816, (FloatBuffer)floatBuffer);
        GL11.glColor4f((float)floatBuffer.get(), (float)floatBuffer.get(), (float)floatBuffer.get(), (float)alpha);
    }

    public static float getAlpha() {
        FloatBuffer floatBuffer = BufferUtils.createFloatBuffer((int)16);
        floatBuffer.rewind();
        GL11.glGetFloat((int)2816, (FloatBuffer)floatBuffer);
        return floatBuffer.get(3);
    }

    public static void overrideColor(boolean override) {
        overrideColor = override;
    }

    public static void renderLightsaber(LightsaberData data, ItemStack itemstack, boolean inWorld) {
        ALRenderHelper.renderLightsaberHilt(data);
        GL11.glScalef((float)3.0f, (float)3.0f, (float)3.0f);
        GL11.glTranslatef((float)0.0f, (float)(-(data.getPart((PartType)PartType.SWITCH_SECTION).height + data.getPart((PartType)PartType.EMITTER).height) * 0.0234375f), (float)0.0f);
        ALRenderHelper.renderLightsaberBlade(data, itemstack, inWorld);
    }

    public static void renderLightsaber(LightsaberData[] array, ItemStack itemstack, boolean inWorld) {
        for (int i = 0; i < array.length; ++i) {
            GL11.glPushMatrix();
            if (i == 1) {
                GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
            GL11.glTranslatef((float)0.0f, (float)(-array[i].getHeight() / 32.0f), (float)0.0f);
            ALRenderHelper.renderLightsaber(array[i], itemstack, inWorld);
            GL11.glPopMatrix();
        }
    }

    public static void renderLightsaber(ItemStack itemstack, boolean inWorld) {
        if (itemstack.func_77973_b() == ModItems.doubleLightsaber) {
            ALRenderHelper.renderLightsaber(ItemDoubleLightsaber.get(itemstack), itemstack, inWorld);
        } else {
            ALRenderHelper.renderLightsaber(LightsaberData.get(itemstack), itemstack, inWorld);
        }
    }

    public static void renderLightsaberHilt(LightsaberData data) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glTranslatef((float)0.0f, (float)(-(data.getPart((PartType)PartType.BODY).height + data.getPart((PartType)PartType.POMMEL).height - data.getHeight() / 2.0f) / 16.0f), (float)0.0f);
        block4: for (PartType type : PartType.values()) {
            HiltRenderer renderer = HiltRenderer.get(data.get(type));
            ModelBase model = renderer.getModel(type);
            mc.func_110434_K().func_110577_a(renderer.getTexture(type));
            switch (type) {
                case EMITTER: {
                    GL11.glPushMatrix();
                    GL11.glTranslatef((float)0.0f, (float)(-data.getPart((PartType)PartType.SWITCH_SECTION).height / 16.0f), (float)0.0f);
                    model.func_78088_a(null, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
                    GL11.glPopMatrix();
                    continue block4;
                }
                case POMMEL: {
                    GL11.glPushMatrix();
                    Hilt.Part body = data.getPart(PartType.BODY);
                    float[] insn = body.glInstructions;
                    if (insn != null && insn.length > 0) {
                        for (int i = 0; i < insn.length; ++i) {
                            float f = insn[i];
                            if ((i & 1) == 0) {
                                GL11.glTranslatef((float)0.0f, (float)(f / 16.0f), (float)0.0f);
                                continue;
                            }
                            GL11.glRotatef((float)f, (float)1.0f, (float)0.0f, (float)0.0f);
                        }
                    } else {
                        GL11.glTranslatef((float)0.0f, (float)(body.height / 16.0f), (float)0.0f);
                    }
                    model.func_78088_a(null, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
                    GL11.glPopMatrix();
                    continue block4;
                }
                default: {
                    model.func_78088_a(null, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
                }
            }
        }
    }

    public static void renderLightsaberHilt(LightsaberData[] array) {
        for (int i = 0; i < array.length; ++i) {
            GL11.glPushMatrix();
            if (i == 1) {
                GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
            GL11.glTranslatef((float)0.0f, (float)(-array[i].getHeight() / 32.0f), (float)0.0f);
            ALRenderHelper.renderLightsaberHilt(array[i]);
            GL11.glPopMatrix();
        }
    }

    public static void renderLightsaberBlade(LightsaberData data, ItemStack itemstack, boolean inWorld) {
        if (ItemLightsaberBase.isActive(itemstack)) {
            int i;
            Item item;
            if (itemstack.func_77942_o() && itemstack.func_77978_p().func_150297_b("Special", 8) && (item = (Item)Item.field_150901_e.func_82594_a(itemstack.func_77978_p().func_74779_i("Special"))) != null) {
                IIcon icon = item.func_77617_a(0);
                Tessellator tessellator = Tessellator.field_78398_a;
                float f = (float)ALRenderHelper.mc.field_71439_g.field_70173_aa + ClientEventHandler.renderTick;
                if (icon == null) {
                    icon = ((TextureMap)mc.func_110434_K().func_110581_b(TextureMap.field_110576_c)).func_110572_b("missingno");
                }
                mc.func_110434_K().func_110577_a(TextureMap.field_110576_c);
                TextureUtil.func_152777_a((boolean)false, (boolean)false, (float)1.0f);
                GL11.glPushMatrix();
                GL11.glEnable((int)32826);
                GL11.glScaled((double)-2.0, (double)(-2.0f + MathHelper.func_76134_b((float)f) * 0.1f), (double)(2.0f + MathHelper.func_76126_a((float)f) * 0.15f));
                GL11.glRotated((double)(-(1.0f - 2.0f * MathHelper.func_76134_b((float)(f / 2.0f + 1.0f)))), (double)0.0, (double)0.0, (double)1.0);
                GL11.glRotated((double)(1.0f - 2.0f * MathHelper.func_76126_a((float)(f / 2.0f + 3.0f))), (double)1.0, (double)0.0, (double)0.0);
                GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glTranslatef((float)0.705f, (float)0.4f, (float)0.03125f);
                GL11.glRotatef((float)135.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                ItemRenderer.func_78439_a((Tessellator)tessellator, (float)icon.func_94212_f(), (float)icon.func_94206_g(), (float)icon.func_94209_e(), (float)icon.func_94210_h(), (int)icon.func_94211_a(), (int)icon.func_94216_b(), (float)0.0625f);
                GL11.glDisable((int)32826);
                GL11.glPopMatrix();
                TextureUtil.func_147945_b();
                return;
            }
            Hilt.Part emitter = data.getPart(PartType.EMITTER);
            boolean prevCull = GL11.glGetBoolean((int)2884);
            float[] crossguard = emitter.crossguard;
            float[] rgb = data.getRGB(itemstack);
            GL11.glPushMatrix();
            GL11.glDisable((int)2896);
            GL11.glDisable((int)3553);
            ALRenderHelper.setLighting(MathHelper.func_76123_f((float)(61680.0f * ModConfig.renderLightingMultiplier)));
            GL11.glDepthMask((boolean)false);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)32772);
            GL11.glTranslatef((float)0.0f, (float)0.095f, (float)0.0f);
            GL11.glAlphaFunc((int)516, (float)0.99f);
            GL11.glDisable((int)3008);
            GL11.glDisable((int)2884);
            if (emitter.hasCrossguard()) {
                for (i = -1; i <= 1; i += 2) {
                    GL11.glPushMatrix();
                    GL11.glTranslatef((float)crossguard[0], (float)crossguard[1], (float)(crossguard[2] * (float)(-i)));
                    GL11.glRotatef((float)(i * 90), (float)1.0f, (float)0.0f, (float)0.0f);
                    if (i == 1) {
                        GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    }
                    CROSSGUARD_BLADE.renderCrossguardOuter(data, itemstack, rgb, inWorld);
                    GL11.glPopMatrix();
                }
            }
            LIGHTSABER_BLADE.renderOuter(data, itemstack, rgb, inWorld);
            GL11.glDisable((int)3042);
            GL11.glDepthMask((boolean)true);
            GL11.glAlphaFunc((int)516, (float)0.1f);
            GL11.glPushMatrix();
            if (emitter.hasCrossguard()) {
                for (i = -1; i <= 1; i += 2) {
                    GL11.glPushMatrix();
                    GL11.glTranslatef((float)crossguard[0], (float)crossguard[1], (float)(crossguard[2] * (float)(-i)));
                    GL11.glRotatef((float)(i * 90), (float)1.0f, (float)0.0f, (float)0.0f);
                    if (i == 1) {
                        GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    }
                    CROSSGUARD_BLADE.renderInner(data, itemstack, rgb, inWorld, true);
                    GL11.glPopMatrix();
                }
            }
            LIGHTSABER_BLADE.renderInner(data, itemstack, rgb, inWorld, false);
            GL11.glPopMatrix();
            GL11.glEnable((int)3553);
            GL11.glEnable((int)2896);
            GL11.glEnable((int)3008);
            GL11.glBlendFunc((int)770, (int)771);
            if (prevCull) {
                GL11.glEnable((int)2884);
            }
            ALRenderHelper.resetLighting();
            GL11.glPopMatrix();
        }
    }

    public static void drawTip(float size, float tip) {
        float f = 0.0625f;
        float f1 = f / 2.0f;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78377_a((double)size, (double)size, 0.0);
        tessellator.func_78377_a((double)(-size), (double)size, 0.0);
        tessellator.func_78377_a((double)(-size + f1), (double)(-size - tip), (double)(-f1));
        tessellator.func_78377_a((double)(size - f1), (double)(-size - tip), (double)(-f1));
        tessellator.func_78377_a((double)size, (double)size, (double)(-f));
        tessellator.func_78377_a((double)(-size), (double)size, (double)(-f));
        tessellator.func_78377_a((double)(-size + f1), (double)(-size - tip), (double)(-f + f1));
        tessellator.func_78377_a((double)(size - f1), (double)(-size - tip), (double)(-f + f1));
        tessellator.func_78377_a((double)(-f1), (double)size, (double)(size - f1));
        tessellator.func_78377_a((double)(-f1), (double)size, (double)(-size - f1));
        tessellator.func_78377_a(0.0, (double)(-size - tip), (double)(-size));
        tessellator.func_78377_a(0.0, (double)(-size - tip), (double)(size - f));
        tessellator.func_78377_a((double)f1, (double)size, (double)(size - f1));
        tessellator.func_78377_a((double)f1, (double)size, (double)(-size - f1));
        tessellator.func_78377_a(0.0, (double)(-size - tip), (double)(-size));
        tessellator.func_78377_a(0.0, (double)(-size - tip), (double)(size - f));
        tessellator.func_78381_a();
    }

    public static void startGlScissor(int x, int y, int width, int height) {
        ScaledResolution reso = new ScaledResolution(mc, ALRenderHelper.mc.field_71443_c, ALRenderHelper.mc.field_71440_d);
        double scaleW = (double)ALRenderHelper.mc.field_71443_c / reso.func_78327_c();
        double scaleH = (double)ALRenderHelper.mc.field_71440_d / reso.func_78324_d();
        if (width <= 0 || height <= 0) {
            return;
        }
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        GL11.glEnable((int)3089);
        GL11.glScissor((int)((int)Math.floor((double)x * scaleW)), (int)((int)Math.floor((double)ALRenderHelper.mc.field_71440_d - (double)(y + height) * scaleH)), (int)((int)Math.floor((double)(x + width) * scaleW) - (int)Math.floor((double)x * scaleW)), (int)((int)Math.floor((double)ALRenderHelper.mc.field_71440_d - (double)y * scaleH) - (int)Math.floor((double)ALRenderHelper.mc.field_71440_d - (double)(y + height) * scaleH)));
    }

    public static void endGlScissor() {
        GL11.glDisable((int)3089);
    }

    public static float median(double curr, double prev) {
        return (float)(prev + (curr - prev) * (double)ClientEventHandler.renderTick);
    }

    public static void startShaders(ResourceLocation resourcelocation) {
        if (OpenGlHelper.field_148824_g && (ALRenderHelper.mc.field_71460_t.field_147707_d == null || !ALRenderHelper.mc.field_71460_t.field_147707_d.func_148022_b().equals(resourcelocation.toString()))) {
            if (ALRenderHelper.mc.field_71460_t.field_147707_d != null) {
                ALRenderHelper.mc.field_71460_t.field_147707_d.func_148021_a();
            }
            try {
                ALRenderHelper.mc.field_71460_t.field_147707_d = new ShaderGroup(mc.func_110434_K(), mc.func_110442_L(), mc.func_147110_a(), resourcelocation);
                ALRenderHelper.mc.field_71460_t.field_147707_d.func_148026_a(ALRenderHelper.mc.field_71443_c, ALRenderHelper.mc.field_71440_d);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void stopShaders() {
        ALRenderHelper.mc.field_71460_t.func_147703_b();
    }

    public static boolean canGazeEntity(EntityPlayer player, EntityLivingBase entity, int amplifier) {
        StatusEffect status = StatusEffect.get((EntityLivingBase)player, Effect.GAZE);
        if (amplifier == 0) {
            return !entity.func_98034_c(player) && !(entity instanceof EntityPlayer);
        }
        if (amplifier == 1) {
            return !entity.func_98034_c(player);
        }
        return true;
    }

    public static void renderLightning(Lightning lightning, float opacity) {
        if (lightning.rotateAngleZ != 0.0f) {
            GL11.glRotatef((float)lightning.rotateAngleZ, (float)0.0f, (float)0.0f, (float)1.0f);
        }
        if (lightning.rotateAngleY != 0.0f) {
            GL11.glRotatef((float)lightning.rotateAngleY, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        if (lightning.rotateAngleX != 0.0f) {
            GL11.glRotatef((float)lightning.rotateAngleX, (float)1.0f, (float)0.0f, (float)0.0f);
        }
        ALRenderHelper.drawLightningLine(Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0), Vec3.func_72443_a((double)0.0, (double)lightning.length, (double)0.0), 5.0f, 1.0f, lightning.lightningColor, opacity);
        GL11.glTranslatef((float)0.0f, (float)lightning.length, (float)0.0f);
        for (Lightning lightning1 : lightning.children) {
            GL11.glPushMatrix();
            ALRenderHelper.renderLightning(lightning1, opacity);
            GL11.glPopMatrix();
        }
    }

    public static void drawLightningLine(Vec3 start, Vec3 end, float lineWidth, float innerLineWidth, Vec3 color, float alpha) {
        if (start == null || end == null) {
            return;
        }
        Tessellator tessellator = Tessellator.field_78398_a;
        float prevWidth = GL11.glGetFloat((int)2849);
        if (lineWidth > 0.0f) {
            GL11.glLineWidth((float)lineWidth);
            tessellator.func_78371_b(3);
            tessellator.func_78369_a((float)color.field_72450_a, (float)color.field_72448_b, (float)color.field_72449_c, alpha);
            tessellator.func_78377_a(start.field_72450_a, start.field_72448_b, start.field_72449_c);
            tessellator.func_78377_a(end.field_72450_a, end.field_72448_b, end.field_72449_c);
            tessellator.func_78381_a();
        }
        if (innerLineWidth > 0.0f) {
            GL11.glLineWidth((float)innerLineWidth);
            tessellator.func_78371_b(3);
            tessellator.func_78369_a(1.0f, 1.0f, 1.0f, MathHelper.func_76131_a((float)(alpha - 0.2f), (float)0.0f, (float)1.0f));
            tessellator.func_78377_a(start.field_72450_a, start.field_72448_b, start.field_72449_c);
            tessellator.func_78377_a(end.field_72450_a, end.field_72448_b, end.field_72449_c);
            tessellator.func_78381_a();
        }
        GL11.glLineWidth((float)prevWidth);
    }

    public static void setupRenderLightning() {
        GL11.glBlendFunc((int)770, (int)32772);
        GL11.glPushMatrix();
        GL11.glDisable((int)3553);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3042);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glBlendFunc((int)770, (int)1);
        GL11.glAlphaFunc((int)516, (float)0.003921569f);
        GL11.glDepthMask((boolean)false);
        ALRenderHelper.setLighting(61680);
    }

    public static void finishRenderLightning() {
        ALRenderHelper.resetLighting();
        GL11.glDepthMask((boolean)true);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)3553);
        GL11.glPopMatrix();
        GL11.glBlendFunc((int)770, (int)771);
    }

    public static void setupRenderItemIntoGUI() {
        GL11.glEnable((int)32826);
        GL11.glEnable((int)2903);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)3042);
        RenderHelper.func_74520_c();
    }

    public static void finishRenderItemIntoGUI() {
        GL11.glDisable((int)3042);
        GL11.glDisable((int)2896);
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2929);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void faceVec(Vec3 src, Vec3 dst) {
        double d0 = dst.field_72450_a - src.field_72450_a;
        double d1 = dst.field_72448_b - src.field_72448_b;
        double d2 = dst.field_72449_c - src.field_72449_c;
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        float yaw = (float)(Math.atan2(d2, d0) * 180.0 / Math.PI) - 90.0f;
        float pitch = (float)(-(Math.atan2(d1, d3) * 180.0 / Math.PI));
        GL11.glRotated((double)(-yaw), (double)0.0, (double)1.0, (double)0.0);
        GL11.glRotated((double)pitch, (double)1.0, (double)0.0, (double)0.0);
    }
}

