/*
 * Decompiled with CFR 0.152.
 */
package com.fiskmods.lightsabers.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.fiskmods.lightsabers.client.gui.GuiDisassemblyStation;
import com.fiskmods.lightsabers.common.hilt.Hilt;
import com.fiskmods.lightsabers.common.item.ItemCrystal;
import com.fiskmods.lightsabers.common.item.ItemDoubleLightsaber;
import com.fiskmods.lightsabers.common.item.ItemFocusingCrystal;
import com.fiskmods.lightsabers.common.item.ItemLightsaberBase;
import com.fiskmods.lightsabers.common.item.ItemLightsaberPart;
import com.fiskmods.lightsabers.common.item.ModItems;
import com.fiskmods.lightsabers.common.lightsaber.LightsaberData;
import com.fiskmods.lightsabers.common.tileentity.TileEntityDisassemblyStation;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;

public class DisassemblyRecipeHandler
extends TemplateRecipeHandler {
    private Minecraft mc = Minecraft.func_71410_x();
    public static ArrayList<FuelPair> afuels;

    @Override
    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(34, 25, 24, 17), this.getOverlayIdentifier(), new Object[0]));
    }

    @Override
    public Class<? extends GuiContainer> getGuiClass() {
        return GuiDisassemblyStation.class;
    }

    @Override
    public String getRecipeName() {
        return StatCollector.func_74838_a((String)"recipe.disassembly_station");
    }

    @Override
    public TemplateRecipeHandler newInstance() {
        if (afuels == null || afuels.isEmpty()) {
            DisassemblyRecipeHandler.findFuels();
        }
        return super.newInstance();
    }

    @Override
    public int recipiesPerPage() {
        return 2;
    }

    @Override
    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getOverlayIdentifier())) {
            this.loadCraftingRecipes(new ItemStack(ModItems.circuitry));
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    @Override
    public void loadCraftingRecipes(ItemStack result) {
        try {
            Item item = result.func_77973_b();
            if (item == ModItems.circuitry) {
                for (Hilt hilt : Hilt.REGISTRY) {
                    this.addRecipe(hilt.createDefault().create());
                }
            } else if (item instanceof ItemLightsaberPart) {
                this.addRecipe(ItemLightsaberPart.get(result).createDefault().create());
            } else if (item instanceof ItemFocusingCrystal) {
                this.addRecipe(new LightsaberData().set(ItemFocusingCrystal.get(result)).create());
            } else if (item instanceof ItemCrystal) {
                this.addRecipe(new LightsaberData().set(ItemCrystal.get(result)).create());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addRecipe(ItemStack stack) {
        this.arecipes.add(new CachedDisassemblyRecipe(stack, TileEntityDisassemblyStation.getOutput(stack)));
        stack = ItemDoubleLightsaber.create(stack, stack);
        this.arecipes.add(new CachedDisassemblyRecipe(stack, TileEntityDisassemblyStation.getOutput(stack)));
    }

    @Override
    public void loadUsageRecipes(ItemStack ingredient) {
        try {
            if (ingredient.func_77973_b() instanceof ItemLightsaberBase) {
                this.arecipes.add(new CachedDisassemblyRecipe(ingredient, TileEntityDisassemblyStation.getOutput(ingredient)));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getGuiTexture() {
        return "lightsabers:textures/gui/container/disassembly_station.png";
    }

    @Override
    public String getOverlayIdentifier() {
        return "disassembly_station";
    }

    @Override
    public void drawExtras(int recipe) {
        this.drawProgressBar(12, 26, 176, 0, 14, 14, 48, 7);
        this.drawProgressBar(34, 25, 176, 14, 24, 16, 48, 0);
    }

    @Override
    public void drawBackground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)5, (int)11, (int)166, (int)66);
    }

    @Override
    public List<String> handleItemTooltip(GuiRecipe gui, ItemStack stack, List<String> currenttip, int recipe) {
        CachedDisassemblyRecipe crecipe = (CachedDisassemblyRecipe)this.arecipes.get(recipe);
        for (Map.Entry<PositionedStack, Float> e : crecipe.results.entrySet()) {
            if (!gui.isMouseOver(e.getKey(), recipe)) continue;
            currenttip.add(String.format("%s%%", ItemStack.field_111284_a.format(e.getValue().floatValue() * 100.0f)));
            break;
        }
        return currenttip;
    }

    private static void findFuels() {
        afuels = new ArrayList();
        for (Map.Entry e : TileEntityDisassemblyStation.getFuels().entrySet()) {
            afuels.add(new FuelPair(((ItemStack)e.getKey()).func_77946_l(), (Integer)e.getValue()));
        }
    }

    public static class FuelPair {
        public PositionedStack stack;
        public int burnTime;

        public FuelPair(ItemStack ingred, int burnTime) {
            this.stack = new PositionedStack(ingred, 11, 43, false);
            this.burnTime = burnTime;
        }
    }

    public class CachedDisassemblyRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public Map<PositionedStack, Float> results;
        public PositionedStack ingredient;

        public CachedDisassemblyRecipe(ItemStack input, Map<ItemStack, Float> outputs) {
            super(DisassemblyRecipeHandler.this);
            input.field_77994_a = 1;
            this.ingredient = new PositionedStack(input, 11, 7);
            this.results = new HashMap<PositionedStack, Float>();
            ArrayList<ItemEntry> list = new ArrayList<ItemEntry>();
            for (Map.Entry<ItemStack, Float> e : outputs.entrySet()) {
                ItemEntry entry = new ItemEntry(e);
                if (list.contains(entry)) {
                    ((ItemEntry)list.get((int)list.indexOf((Object)entry))).getKey().field_77994_a += e.getKey().field_77994_a;
                    continue;
                }
                list.add(entry);
            }
            list.sort(Comparator.naturalOrder());
            for (int i = 0; i < list.size(); ++i) {
                this.addOutput(72 + 18 * (i % 5), 18 + 18 * (i / 5), (ItemEntry)list.get(i));
            }
        }

        private void addOutput(int x, int y, ItemEntry e) {
            this.results.put(new PositionedStack(e.getKey(), x - 5, y - 11, false), Float.valueOf(e.getValue()));
        }

        @Override
        public PositionedStack getIngredient() {
            return this.ingredient;
        }

        @Override
        public PositionedStack getResult() {
            return null;
        }

        @Override
        public List<PositionedStack> getOtherStacks() {
            ArrayList<PositionedStack> stacks = new ArrayList<PositionedStack>(this.results.keySet());
            PositionedStack stack = this.getOtherStack();
            if (stack != null) {
                stacks.add(stack);
            }
            return stacks;
        }

        @Override
        public PositionedStack getOtherStack() {
            return DisassemblyRecipeHandler.afuels.get((int)(DisassemblyRecipeHandler.this.cycleticks / 48 % DisassemblyRecipeHandler.afuels.size())).stack;
        }
    }

    private class ItemEntry
    implements Comparable<ItemEntry> {
        private final Map.Entry<ItemStack, Float> e;

        public ItemEntry(Map.Entry<ItemStack, Float> e) {
            this.e = e;
        }

        public ItemStack getKey() {
            return this.e.getKey();
        }

        public float getValue() {
            return this.e.getValue().floatValue();
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.getKey().func_77960_j();
            result = 31 * result + (this.getKey().func_77973_b() == null ? 0 : this.getKey().func_77973_b().hashCode());
            result = 31 * result + (this.getKey().func_77978_p() == null ? 0 : this.getKey().func_77978_p().hashCode());
            result = 31 * result + Float.floatToIntBits(this.getValue());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            ItemEntry other = (ItemEntry)obj;
            if (this.getKey().func_77960_j() != other.getKey().func_77960_j()) {
                return false;
            }
            if (Float.floatToIntBits(this.getValue()) != Float.floatToIntBits(other.getValue())) {
                return false;
            }
            if (this.getKey().func_77973_b() == null ? other.getKey().func_77973_b() != null : !this.getKey().func_77973_b().equals(other.getKey().func_77973_b())) {
                return false;
            }
            return !(this.getKey().func_77978_p() == null ? other.getKey().func_77978_p() != null : !this.getKey().func_77978_p().equals((Object)other.getKey().func_77978_p()));
        }

        @Override
        public int compareTo(ItemEntry o) {
            return Float.compare(o.getValue(), this.getValue());
        }
    }
}

