/*
 * Decompiled with CFR 0.152.
 */
package com.fiskmods.lightsabers.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.fiskmods.lightsabers.client.gui.GuiLightsaberForge;
import com.fiskmods.lightsabers.client.sound.ALSounds;
import com.fiskmods.lightsabers.common.block.ModBlocks;
import com.fiskmods.lightsabers.common.event.ClientEventHandler;
import com.fiskmods.lightsabers.common.hilt.Hilt;
import com.fiskmods.lightsabers.common.item.ItemCrystal;
import com.fiskmods.lightsabers.common.item.ItemFocusingCrystal;
import com.fiskmods.lightsabers.common.item.ItemLightsaberBase;
import com.fiskmods.lightsabers.common.item.ItemLightsaberPart;
import com.fiskmods.lightsabers.common.item.ModItems;
import com.fiskmods.lightsabers.common.lightsaber.CrystalColor;
import com.fiskmods.lightsabers.common.lightsaber.FocusingCrystal;
import com.fiskmods.lightsabers.common.lightsaber.LightsaberData;
import com.fiskmods.lightsabers.common.lightsaber.PartType;
import com.fiskmods.lightsabers.helper.ALRenderHelper;
import com.google.common.collect.Iterables;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;

public class LightsaberForgeRecipeHandler
extends TemplateRecipeHandler {
    private Minecraft mc = Minecraft.func_71410_x();

    @Override
    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(126, 54, 26, 17), this.getOverlayIdentifier(), new Object[0]));
    }

    @Override
    public Class<? extends GuiContainer> getGuiClass() {
        return GuiLightsaberForge.class;
    }

    @Override
    public String getRecipeName() {
        return StatCollector.func_74838_a((String)"recipe.lightsaber_forge");
    }

    @Override
    public int recipiesPerPage() {
        return 1;
    }

    @Override
    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getOverlayIdentifier())) {
            this.loadUsageRecipes(new ItemStack(ModItems.circuitry));
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    @Override
    public void loadCraftingRecipes(ItemStack result) {
        try {
            if (result.func_77973_b() == ModItems.lightsaber) {
                if (result.func_82833_r().equalsIgnoreCase("sweet dreams")) {
                    this.mc.field_71439_g.func_85030_a(ALSounds.player_lightsaber_sweet_dreams, 1.0f, 1.0f);
                }
                LightsaberData data = LightsaberData.get(result);
                Object[] inputs = new Object[8];
                inputs[4] = new ItemStack(ModItems.circuitry);
                inputs[5] = ItemCrystal.create(data.getColor());
                FocusingCrystal[] crystals = data.getFocusingCrystals();
                Hilt[] hilt = data.getHilt();
                for (PartType type : PartType.values()) {
                    inputs[type.ordinal()] = ItemLightsaberPart.create(type, hilt[type.ordinal()]);
                }
                for (int i = 0; i < Math.min(crystals.length, 2); ++i) {
                    inputs[i + 6] = ItemFocusingCrystal.create(crystals[i]);
                }
                CachedLightsaberForgeRecipe recipe = new CachedLightsaberForgeRecipe(LightsaberData.get(result), inputs);
                recipe.computeVisuals();
                this.arecipes.add(recipe);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void loadUsageRecipes(ItemStack ingredient) {
        try {
            Item item = ingredient.func_77973_b();
            ingredient = ingredient.func_77946_l();
            ingredient.field_77994_a = 1;
            if (item instanceof ItemLightsaberPart) {
                Hilt hilt = ItemLightsaberPart.get(ingredient);
                Object[] inputs = new Object[8];
                for (PartType partType : PartType.values()) {
                    inputs[partType.ordinal()] = ItemLightsaberPart.create(partType, hilt);
                }
                inputs[4] = new ItemStack(ModItems.circuitry);
                for (Enum enum_ : CrystalColor.values()) {
                    inputs[5] = ItemCrystal.create((CrystalColor)enum_);
                    CachedLightsaberForgeRecipe recipe = new CachedLightsaberForgeRecipe(new LightsaberData().set(hilt).set((CrystalColor)enum_), inputs);
                    recipe.computeVisuals();
                    this.arecipes.add(recipe);
                }
            } else if (item == Item.func_150898_a((Block)ModBlocks.lightsaberCrystal)) {
                CrystalColor color = ItemCrystal.get(ingredient);
                Object[] inputs = new Object[8];
                inputs[4] = new ItemStack(ModItems.circuitry);
                inputs[5] = ingredient;
                for (Hilt hilt : Hilt.REGISTRY) {
                    for (PartType type : PartType.values()) {
                        inputs[type.ordinal()] = ItemLightsaberPart.create(type, hilt);
                    }
                    CachedLightsaberForgeRecipe recipe = new CachedLightsaberForgeRecipe(new LightsaberData().set(hilt).set(color), inputs);
                    recipe.computeVisuals();
                    this.arecipes.add(recipe);
                }
            } else if (item == ModItems.focusingCrystal) {
                FocusingCrystal crystal = ItemFocusingCrystal.get(ingredient);
                Object[] inputs = new Object[8];
                inputs[4] = new ItemStack(ModItems.circuitry);
                inputs[5] = ItemCrystal.create(CrystalColor.get(0));
                inputs[6] = ingredient;
                for (Hilt hilt2 : Hilt.REGISTRY) {
                    for (PartType type : PartType.values()) {
                        inputs[type.ordinal()] = ItemLightsaberPart.create(type, hilt2);
                    }
                    CachedLightsaberForgeRecipe recipe = new CachedLightsaberForgeRecipe(new LightsaberData().set(hilt2).add(crystal), inputs);
                    recipe.computeVisuals();
                    this.arecipes.add(recipe);
                }
            } else if (item == ModItems.circuitry) {
                for (Hilt hilt : Hilt.REGISTRY) {
                    void var8_34;
                    void var8_32;
                    Object[] inputs = new Object[8];
                    inputs[4] = ingredient;
                    PartType[] hilt2 = PartType.values();
                    int recipe = hilt2.length;
                    boolean bl = false;
                    while (var8_32 < recipe) {
                        PartType type = hilt2[var8_32];
                        inputs[type.ordinal()] = ItemLightsaberPart.create(type, hilt);
                        ++var8_32;
                    }
                    LightsaberData data = new LightsaberData().set(hilt).set(hilt.getColor());
                    Collection<FocusingCrystal> crystals = hilt.getFocusingCrystals();
                    boolean bl2 = false;
                    while (var8_34 < Math.min(crystals.size(), 2)) {
                        FocusingCrystal crystal = (FocusingCrystal)((Object)Iterables.get(crystals, (int)var8_34));
                        inputs[var8_34 + 6] = ItemFocusingCrystal.create(crystal);
                        data.add(crystal);
                        ++var8_34;
                    }
                    inputs[5] = ItemCrystal.create(hilt.getColor());
                    CachedLightsaberForgeRecipe cachedLightsaberForgeRecipe = new CachedLightsaberForgeRecipe(data, inputs);
                    cachedLightsaberForgeRecipe.computeVisuals();
                    this.arecipes.add(cachedLightsaberForgeRecipe);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getGuiTexture() {
        return "lightsabers:textures/gui/container/lightsaber_forge.png";
    }

    @Override
    public String getOverlayIdentifier() {
        return "lightsaber_forge";
    }

    @Override
    public void drawExtras(int recipe) {
        CachedLightsaberForgeRecipe recipe1 = (CachedLightsaberForgeRecipe)this.arecipes.get(recipe);
        GuiDraw.drawString((String)StatCollector.func_74837_a((String)"%s cm", (Object[])new Object[]{ItemStack.field_111284_a.format(recipe1.data.getHeightCm())}), (int)40, (int)(54 - GuiDraw.fontRenderer.field_78288_b), (int)-1);
    }

    @Override
    public void drawBackground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)5, (int)11, (int)166, (int)102);
        int guiLeft = (this.mc.field_71462_r.field_146294_l - 176) / 2;
        int guiTop = (this.mc.field_71462_r.field_146295_m - 166) / 2;
        float spin = (float)this.mc.field_71439_g.field_70173_aa + ClientEventHandler.renderTick;
        CachedLightsaberForgeRecipe recipe1 = (CachedLightsaberForgeRecipe)this.arecipes.get(recipe);
        GL11.glEnable((int)32826);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        GL11.glEnable((int)2903);
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glTranslatef((float)105.0f, (float)29.0f, (float)20.0f);
        GL11.glRotatef((float)((float)Math.sin(spin / 20.0f) * 2.5f), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)((float)Math.sin(spin / 20.0f + 2.0f) * 2.5f), (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)(90.0f + spin), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glScalef((float)-20.0f, (float)20.0f, (float)20.0f);
        RenderHelper.func_74520_c();
        ALRenderHelper.startGlScissor(guiLeft + 43, guiTop + 22, 113, 47);
        ALRenderHelper.renderLightsaber(recipe1.data, recipe1.result.item, false);
        ALRenderHelper.endGlScissor();
        RenderHelper.func_74518_a();
        GL11.glPopMatrix();
    }

    public class CachedLightsaberForgeRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public ArrayList<PositionedStack> ingredients;
        public PositionedStack result;
        public final LightsaberData data;

        public CachedLightsaberForgeRecipe(LightsaberData output, Object[] inputs) {
            super(LightsaberForgeRecipeHandler.this);
            this.result = new PositionedStack(ItemLightsaberBase.setActive(output.create(), true), 131, 76);
            this.ingredients = new ArrayList();
            this.data = output;
            this.addSlotToContainer(0, 20, 17, inputs);
            this.addSlotToContainer(1, 20, 35, inputs);
            this.addSlotToContainer(2, 20, 53, inputs);
            this.addSlotToContainer(3, 20, 71, inputs);
            this.addSlotToContainer(4, 43, 71, inputs);
            this.addSlotToContainer(5, 66, 71, inputs);
            this.addSlotToContainer(6, 89, 71, inputs);
            this.addSlotToContainer(7, 107, 71, inputs);
        }

        private void addSlotToContainer(int id, int x, int y, Object[] inputs) {
            if (inputs[id] != null) {
                PositionedStack stack = new PositionedStack(inputs[id], x - 5, y - 11, false);
                this.ingredients.add(stack);
            }
        }

        @Override
        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(LightsaberForgeRecipeHandler.this.cycleticks / 20, this.ingredients);
        }

        @Override
        public PositionedStack getResult() {
            return this.result;
        }

        public void computeVisuals() {
            for (PositionedStack p : this.ingredients) {
                p.generatePermutations();
            }
        }
    }
}

