/*
 * Decompiled with CFR 0.152.
 */
package com.fiskmods.lightsabers.saberbuilder;

import com.fiskmods.lightsabers.common.hilt.Hilt;
import com.fiskmods.lightsabers.common.lightsaber.CrystalColor;
import com.fiskmods.lightsabers.common.lightsaber.FocusingCrystal;
import com.fiskmods.lightsabers.common.lightsaber.PartType;

public abstract class AbstractLightsaberData {
    public long hash;

    public AbstractLightsaberData() {
        this(0L);
    }

    public AbstractLightsaberData(long hashCode) {
        this.hash = hashCode;
    }

    protected abstract int getIDForObject(Hilt var1);

    protected abstract Hilt getObjectById(int var1);

    protected abstract AbstractLightsaberData createNew(long var1);

    public AbstractLightsaberData copy() {
        return this.createNew(this.hash);
    }

    public AbstractLightsaberData strip() {
        this.hash = this.createNew((long)0L).set((Hilt[])this.getHilt()).set((CrystalColor)this.getColor()).set((FocusingCrystal[])this.getFocusingCrystals()).hash;
        return this;
    }

    public Hilt get(PartType type) {
        return this.getObjectById((int)(this.hash >> type.ordinal() * 6) & 0x3F);
    }

    public Hilt[] getHilt() {
        Hilt[] hilt = new Hilt[4];
        for (int i = 0; i < hilt.length; ++i) {
            hilt[i] = this.get(PartType.values()[i]);
        }
        return hilt;
    }

    public boolean isHiltUniform() {
        Hilt[] hilt = this.getHilt();
        for (int i = 0; i < hilt.length; ++i) {
            if (i <= 0 || hilt[i - 1] == hilt[i]) continue;
            return false;
        }
        return true;
    }

    public long getHiltBits() {
        return this.hash & 0xFFFFFFL;
    }

    public Hilt.Part getPart(PartType type) {
        return this.get(type).getPart(type);
    }

    public float getHeight() {
        float height = 0.0f;
        for (PartType type : PartType.values()) {
            height += this.getPart((PartType)type).height;
        }
        return height;
    }

    public float getHeightCm() {
        return this.getHeight() * 0.575f;
    }

    public CrystalColor getColor() {
        return CrystalColor.get((int)(this.hash >> 24 & 0xFFL));
    }

    public FocusingCrystal[] getFocusingCrystals() {
        FocusingCrystal[] array;
        FocusingCrystal[] crystals = new FocusingCrystal[FocusingCrystal.values().length];
        int i = -1;
        for (FocusingCrystal crystal : FocusingCrystal.values()) {
            if (!this.hasFocusingCrystal(crystal)) continue;
            crystals[++i] = crystal;
        }
        if ((array = new FocusingCrystal[++i]).length > 0) {
            System.arraycopy(crystals, 0, array, 0, i);
        }
        return array;
    }

    public boolean hasFocusingCrystal(FocusingCrystal crystal) {
        return (this.hash >> 32 & crystal.getCode()) == crystal.getCode();
    }

    public AbstractLightsaberData set(PartType type, Hilt hilt) {
        int shift = type.ordinal() * 6;
        this.hash &= 63L << shift ^ 0xFFFFFFFFFFFFFFFFL;
        this.hash |= (long)(this.getIDForObject(hilt) << shift);
        return this;
    }

    public AbstractLightsaberData set(Hilt ... hilt) {
        for (int i = 0; i < Math.min(PartType.values().length, hilt.length); ++i) {
            this.set(PartType.values()[i], hilt[i]);
        }
        return this;
    }

    public AbstractLightsaberData set(Hilt hilt) {
        return this.set(hilt, hilt, hilt, hilt);
    }

    public AbstractLightsaberData set(CrystalColor color) {
        this.hash &= 0xFFFFFFFF00FFFFFFL;
        this.hash |= (long)((color.id & 0xFF) << 24);
        return this;
    }

    public AbstractLightsaberData set(FocusingCrystal ... crystals) {
        this.hash &= 0xFFFF0000FFFFFFFFL;
        for (FocusingCrystal crystal : crystals) {
            if (crystal == null) continue;
            this.add(crystal);
        }
        return this;
    }

    public AbstractLightsaberData add(FocusingCrystal crystal) {
        this.hash |= crystal.getCode() << 32;
        return this;
    }

    public AbstractLightsaberData remove(FocusingCrystal crystal) {
        this.hash &= crystal.getCode() << 32 ^ 0xFFFFFFFFFFFFFFFFL;
        return this;
    }

    public int hashCode() {
        return (int)(this.hash & 0xFFFFFFFL) * 31 + (int)(this.hash >> 32);
    }

    public boolean equals(Object obj) {
        return obj instanceof AbstractLightsaberData && this.hash == ((AbstractLightsaberData)obj).hash;
    }
}

