/*
 * Decompiled with CFR 0.152.
 */
package com.fiskmods.lightsabers.saberbuilder;

import com.fiskmods.lightsabers.common.hilt.Hilt;
import com.fiskmods.lightsabers.common.hilt.HiltManager;
import com.fiskmods.lightsabers.common.lightsaber.CrystalColor;
import com.fiskmods.lightsabers.common.lightsaber.FocusingCrystal;
import com.fiskmods.lightsabers.common.lightsaber.PartType;
import com.fiskmods.lightsabers.saberbuilder.AbstractLightsaberData;
import com.fiskmods.ui.UIWindow;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class SaberBuilder
extends UIWindow {
    private static final Map<String, Hilt> HILTS = new LinkedHashMap<String, Hilt>();
    private static final BiMap<Hilt, Integer> HILT_IDS = HashBiMap.create();
    private final int margin = 5;
    private final int width;
    private AbstractLightsaberData data = new LData(0L);
    private final String[] partNames = new String[]{"Emitter", "Switch Section", "Grip", "Pommel"};
    private final JComboBox[] hiltParts = new JComboBox[this.partNames.length];
    private final JComboBox[] focusingCrystals = new JComboBox[2];
    private final JComboBox colorCrystal = new JComboBox<CrystalColor>(CrystalColor.values());
    private final JButton colorPreview = new JButton();
    private final JTextField hexField = new JTextField("#0");
    private final JTextField commandField = new JTextField();

    private SaberBuilder(String title, int width, int height) {
        super(title, width, height);
        this.width = width;
        Vector<String> v = new Vector<String>(HILTS.keySet());
        int i = 0;
        while (i < this.partNames.length) {
            JComboBox<String> box = this.hiltParts[i] = new JComboBox<String>(v);
            this.add(i % 2 + 1, 2, this.partNames[i], box, i / 2);
            int j = i++;
            box.addActionListener(e -> {
                this.data.set(PartType.values()[j], HILTS.get(box.getSelectedItem()));
                this.updateScreen();
            });
        }
        ArrayList list = Lists.newArrayList((Object[])FocusingCrystal.values());
        list.add(0, "-");
        Vector v2 = new Vector(list);
        this.focusingCrystals[0] = new JComboBox(v2);
        this.add(1, 2, "Focusing Crystals", this.focusingCrystals[0], 2);
        this.focusingCrystals[1] = new JComboBox(v2);
        this.add(2, 2, "", this.focusingCrystals[1], 2);
        for (int i2 = 0; i2 < 2; ++i2) {
            this.focusingCrystals[i2].addActionListener(e -> {
                this.data.set(this.getFocusingCrystal(0), this.getFocusingCrystal(1));
                this.updateScreen();
            });
        }
        this.colorPreview.setFocusable(false);
        this.colorPreview.setBorderPainted(true);
        this.colorCrystal.addActionListener(e -> {
            this.data.set(this.getColor());
            this.updateScreen();
        });
        this.add(1, 2, "Color", this.colorCrystal, 3);
        this.add(2, 2, "", this.colorPreview, 3);
        Font f = this.hexField.getFont();
        this.hexField.setFont(new Font(f.getName(), 1, f.getSize() * 2));
        this.hexField.addActionListener(e -> this.loadHex());
        this.hexField.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                SaberBuilder.this.updateScreen();
            }

            @Override
            public void focusGained(FocusEvent e) {
                String s = SaberBuilder.this.hexField.getText();
                if (s.startsWith("#")) {
                    SaberBuilder.this.hexField.setText(s.substring(1));
                }
            }
        });
        this.add(this.hexField, 5, height - 40 - 5, (width - 5) / 2, 40);
        f = this.commandField.getFont();
        this.commandField.setEditable(false);
        this.commandField.setFont(new Font(f.getName(), 1, f.getSize()));
        this.add(1, 1, "Command", this.commandField, 4);
        this.updateScreen();
    }

    private void loadHex() {
        String s = this.hexField.getText();
        if (s.isEmpty()) {
            s = "0";
        } else if (!s.startsWith("#")) {
            s = "#" + s;
        }
        this.setHash(Long.decode(s));
        this.updateScreen();
    }

    private void setHash(long hash) {
        this.data = new LData(hash).strip();
        this.colorCrystal.setSelectedItem((Object)this.data.getColor());
        for (int i = 0; i < this.partNames.length; ++i) {
            int id = (Integer)HILT_IDS.getOrDefault((Object)this.data.get(PartType.values()[i]), (Object)0);
            if (id >= HILTS.size()) {
                id = 0;
            }
            this.hiltParts[i].setSelectedIndex(id);
        }
        FocusingCrystal[] crystals = this.data.getFocusingCrystals();
        this.focusingCrystals[0].setSelectedIndex(0);
        this.focusingCrystals[1].setSelectedIndex(0);
        for (int i = 0; i < crystals.length; ++i) {
            this.focusingCrystals[i].setSelectedIndex(crystals[i].ordinal() + 1);
        }
    }

    private void updateScreen() {
        String s = Long.toHexString(this.data.hash).toUpperCase(Locale.ROOT);
        if (!this.hexField.hasFocus()) {
            s = "#" + s;
        }
        this.hexField.setText(s);
        this.colorPreview.setBackground(new Color(this.getColor().color));
        if (!s.startsWith("#")) {
            s = "#" + s;
        }
        this.commandField.setText(String.format("/give @p %s:lightsaber 1 0 {%s:\"%s\"}", "lightsabers", "Lightsaber", s));
    }

    private FocusingCrystal getFocusingCrystal(int slot) {
        Object obj = this.focusingCrystals[slot].getSelectedItem();
        if (obj instanceof FocusingCrystal) {
            return (FocusingCrystal)((Object)obj);
        }
        return null;
    }

    private CrystalColor getColor() {
        return (CrystalColor)((Object)this.colorCrystal.getSelectedItem());
    }

    private void add(int index, int stack, String text, JComponent comp, int row) {
        int w = this.width - 5 * (stack - 1);
        this.add(text, comp, 5 * index + w / stack * (index - 1), 5 + row * 45, w / stack);
    }

    private void add(String text, JComponent comp, int x, int y, int width) {
        if (!text.isEmpty()) {
            this.add(text, x, y, width - 5, 20);
        }
        this.add(comp, x, y + 20, width, 20);
    }

    public static void main(String[] args) {
        try {
            int nextId = -1;
            for (Field field : HiltManager.class.getFields()) {
                if (!Hilt.class.isAssignableFrom(field.getType())) continue;
                Hilt hilt = (Hilt)field.get(null);
                HILTS.put(field.getName().toLowerCase(Locale.ROOT), hilt);
                HILT_IDS.put((Object)hilt, (Object)(++nextId));
            }
            new SaberBuilder("Lightsaber Builder", 400, 300).open();
        }
        catch (Exception e) {
            int width = 400;
            int height = 200;
            UIWindow window = new UIWindow("Lightsaber Builder", width, height);
            StringWriter w = new StringWriter();
            JTextArea log = new JTextArea();
            e.printStackTrace(new PrintWriter(w));
            log.setText(w.getBuffer().toString());
            log.setForeground(Color.RED);
            log.setEditable(false);
            window.add("A critical error occurred:", 5, 5, width - 10, 20);
            window.add(new JButton("Close"), width / 4, height - 25, width / 2, 20, event -> System.exit(-1));
            window.add(log, 5, 30, width - 10, height - 65);
            window.open();
        }
    }

    private static class LData
    extends AbstractLightsaberData {
        private LData(long hashCode) {
            super(hashCode);
        }

        @Override
        protected int getIDForObject(Hilt hilt) {
            return (Integer)HILT_IDS.getOrDefault((Object)hilt, (Object)0);
        }

        @Override
        protected Hilt getObjectById(int id) {
            return (Hilt)HILT_IDS.inverse().getOrDefault((Object)id, HILT_IDS.inverse().get((Object)0));
        }

        @Override
        protected AbstractLightsaberData createNew(long hashCode) {
            return new LData(hashCode);
        }
    }
}

