/*
 * Decompiled with CFR 0.152.
 */
package com.fiskmods.ui;

import com.fiskmods.ui.ComponentWrapper;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import javax.swing.AbstractButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class UIWindow
extends JFrame {
    public final Map<String, Component> components = new HashMap<String, Component>();
    public final Map<Component, Predicate<Component>> enabled = new HashMap<Component, Predicate<Component>>();
    public final JPanel panel = new JPanel();
    private Thread updateThread;

    public UIWindow(String title, int width, int height) {
        this.panel.setLayout(null);
        this.panel.setPreferredSize(new Dimension(width, height));
        this.updateThread = new Thread(() -> {
            try {
                while (true) {
                    this.update();
                    this.updateUI();
                }
            }
            catch (ThreadDeath threadDeath) {
                return;
            }
        });
        this.setTitle(title);
        this.setContentPane(this.panel);
        this.setLocationRelativeTo(null);
        this.setLocation(this.getX() - width / 2, this.getY() - height / 2);
        this.setDefaultCloseOperation(3);
    }

    public void update() {
    }

    public void updateUI() {
        this.enabled.forEach((key, value) -> key.setEnabled(value.test(key)));
    }

    public ComponentWrapper add(Component component, int x, int y, int width, int height) {
        this.add(component);
        component.setBounds(x, y, width, height);
        return new ComponentWrapper(this, component);
    }

    public ComponentWrapper add(AbstractButton button, int x, int y, int width, int height, ActionListener listener) {
        button.addActionListener(listener);
        return this.add(button, x, y, width, height);
    }

    public ComponentWrapper add(String text, int x, int y, int width, int height) {
        return this.add(new JLabel(text), x, y, width, height);
    }

    public void open() {
        this.pack();
        this.setVisible(true);
        this.setResizable(false);
        this.updateThread.start();
    }

    public void close() {
        this.dispose();
        this.updateThread.stop();
    }
}

