/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.utils;

import com.fiskmods.lightsabers.Lightsabers;
import com.google.common.collect.Maps;
import fiskfille.utils.Log;
import fiskfille.utils.common.interaction.InteractionHandler;
import fiskfille.utils.common.keybinds.FiskKeyHandler;
import fiskfille.utils.common.network.FiskNetworkManager;
import fiskfille.utils.helper.FiskServerUtils;
import java.util.Map;

public class FiskUtils {
    public static final String MODID = "fiskutils";
    private static final Map<Hook, String> HOOK_OWNERS = Maps.newHashMap();

    public static void hook(Hook hook) {
        if (HOOK_OWNERS.containsKey((Object)hook)) {
            Log.debug("%s hook ignored, already handled by %s", new Object[]{hook, HOOK_OWNERS.get((Object)hook)});
            return;
        }
        Log.debug("Adding hook %s", new Object[]{hook});
        HOOK_OWNERS.put(hook, FiskServerUtils.getActiveModId());
        switch (hook) {
            case PREINIT: {
                if (Lightsabers.proxy.getSide().isClient()) {
                    FiskKeyHandler.register();
                }
                FiskNetworkManager.register();
                InteractionHandler.register();
            }
        }
    }

    public static enum Hook {
        PREINIT,
        INIT,
        POSTINIT;

    }
}

