/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.utils;

import com.google.common.collect.Maps;
import fiskfille.utils.helper.FiskServerUtils;
import java.util.Map;
import net.minecraft.util.StringUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Log {
    private static Map<String, Logger> loggers = Maps.newHashMap();

    private static Logger fetchLogger(String key) {
        Logger logger = loggers.get(key);
        if (logger == null) {
            logger = LogManager.getLogger((String)key);
            loggers.put(key, logger);
        }
        return logger;
    }

    private static Logger getLogger(String prefix) {
        String name = FiskServerUtils.getActiveModName();
        if (!StringUtils.func_151246_b((String)prefix)) {
            name = String.format("%s/%s", name, prefix);
        }
        return Log.fetchLogger(name);
    }

    public static boolean warn2(String prefix, String message, Object ... args) {
        return Log.log(Level.WARN, prefix, message, args);
    }

    public static boolean error2(String prefix, String message, Object ... args) {
        return Log.log(Level.ERROR, prefix, message, args);
    }

    public static boolean info2(String prefix, String message, Object ... args) {
        return Log.log(Level.INFO, prefix, message, args);
    }

    public static boolean debug2(String prefix, String message, Object ... args) {
        return Log.log(Level.DEBUG, prefix, message, args);
    }

    public static boolean warn(String message, Object ... args) {
        return Log.warn2("", message, args);
    }

    public static boolean error(String message, Object ... args) {
        return Log.error2("", message, args);
    }

    public static boolean info(String message, Object ... args) {
        return Log.info2("", message, args);
    }

    public static boolean debug(String message, Object ... args) {
        return Log.debug2("", message, args);
    }

    private static boolean log(Level level, String prefix, String message, Object ... args) {
        Logger logger = Log.getLogger(prefix);
        if (args.length > 0) {
            message = String.format(message, args);
        }
        logger.log(level, message);
        return logger.isEnabled(level);
    }
}

