/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.utils;

import com.google.common.collect.Maps;
import fiskfille.utils.Log;
import java.util.Map;

public class TaskTimer {
    private static Map<String, TaskTimer> timers = Maps.newHashMap();
    private final String task;
    private long startTime;

    private TaskTimer(String s) {
        this.task = s;
    }

    public static void start(String task) {
        TaskTimer.get((String)task).startTime = System.currentTimeMillis();
    }

    public static void stop(String task) {
        Log.info2("Tasks", "Finished task %s in %s ms", task, System.currentTimeMillis() - TaskTimer.get((String)task).startTime);
    }

    private static TaskTimer get(String task) {
        TaskTimer timer = timers.get(task);
        if (timer == null) {
            timer = new TaskTimer(task);
            timers.put(task, timer);
        }
        return timer;
    }
}

