/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.utils.common.damage;

import net.minecraft.util.DamageSource;

public interface IExtendedDamage {
    public int getFlags();

    public static interface DamageTypeCallback {
        public boolean isPresent(DamageType var1, DamageSource var2);

        public static class Impl
        implements DamageTypeCallback {
            @Override
            public boolean isPresent(DamageType type, DamageSource source) {
                return source instanceof IExtendedDamage && (((IExtendedDamage)source).getFlags() & type.getFlag()) == type.getFlag();
            }
        }
    }

    public static enum DamageType {
        KINETIC(new DamageTypeCallback.Impl(){

            @Override
            public boolean isPresent(DamageType type, DamageSource source) {
                return source == DamageSource.field_76379_h || super.isPresent(type, source);
            }
        }),
        INTERNAL(new DamageTypeCallback.Impl(){

            @Override
            public boolean isPresent(DamageType type, DamageSource source) {
                return source == DamageSource.field_76369_e || source == DamageSource.field_76366_f || super.isPresent(type, source);
            }
        }),
        COLD,
        ENERGY,
        SOUND,
        LIGHTNING;

        private final DamageTypeCallback hook;

        private DamageType(DamageTypeCallback callback) {
            this.hook = callback;
        }

        private DamageType() {
            this(new DamageTypeCallback.Impl());
        }

        public int getFlag() {
            return 1 << this.ordinal();
        }

        public boolean isPresent(DamageSource source) {
            return this.hook.isPresent(this, source);
        }

        public static int with(int flags, DamageType ... types) {
            for (DamageType type : types) {
                flags |= type.getFlag();
            }
            return flags;
        }
    }
}

