/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.utils.common.entity.attribute;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import fiskfille.utils.common.entity.attribute.AttributePair;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.ai.attributes.IAttribute;

public class AttributeWrapper {
    private final List<AttributePair> modifiers = Lists.newArrayList();
    public final IAttribute attribute;

    public AttributeWrapper(IAttribute attribute) {
        this.attribute = attribute;
    }

    protected List<Double> getModifiers(int operation) {
        ArrayList list = Lists.newArrayList();
        for (AttributePair pair : this.modifiers) {
            if (operation != pair.operation) continue;
            list.add(pair.amount);
        }
        return list;
    }

    public ImmutableList<AttributePair> getModifiers() {
        return ImmutableList.copyOf(this.modifiers);
    }

    public void apply(double amount, int operation) {
        this.modifiers.add(new AttributePair(amount, operation));
    }

    public boolean isEmpty() {
        return this.modifiers.isEmpty();
    }

    public double getValue(double baseValue) {
        double amount;
        ArrayList list = Lists.newArrayList(this.getModifiers(1));
        list.addAll(this.getModifiers(2));
        Iterator<Object> iter = list.iterator();
        while (iter.hasNext()) {
            amount = (Double)iter.next();
            baseValue *= 1.0 + amount;
        }
        iter = this.getModifiers(0).iterator();
        while (iter.hasNext()) {
            amount = (Double)iter.next();
            baseValue += amount;
        }
        return this.attribute.func_111109_a(baseValue);
    }

    public float getValue(float baseValue) {
        return (float)this.getValue((double)baseValue);
    }
}

