/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.utils.common.interaction;

import com.google.common.collect.ImmutableList;
import cpw.mods.fml.relauncher.Side;
import fiskfille.utils.common.interaction.Interaction;
import fiskfille.utils.common.interaction.InteractionHandler;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;

public abstract class InteractionBase
extends Interaction {
    protected final ImmutableList<InteractionHandler.InteractionType> reqTypes;

    public InteractionBase(InteractionHandler.InteractionType ... types) {
        this.reqTypes = ImmutableList.builder().add((Object[])types).build();
    }

    public InteractionBase() {
        this(InteractionHandler.InteractionType.RIGHT_CLICK_AIR);
    }

    @Override
    public boolean listen(EntityPlayer sender, EntityPlayer clientPlayer, InteractionHandler.InteractionType type, Side side, int x, int y, int z, List<Integer> args) {
        if (!this.reqTypes.contains((Object)type)) {
            return false;
        }
        if (side.isClient() && sender == clientPlayer && !this.clientRequirements(sender, type, x, y, z)) {
            return false;
        }
        return this.serverRequirements(sender, type, x, y, z);
    }

    public abstract boolean serverRequirements(EntityPlayer var1, InteractionHandler.InteractionType var2, int var3, int var4, int var5);

    public abstract boolean clientRequirements(EntityPlayer var1, InteractionHandler.InteractionType var2, int var3, int var4, int var5);
}

