/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.utils.common.network;

import com.fiskmods.lightsabers.Lightsabers;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;

public abstract class AbstractMessage<REQ extends AbstractMessage>
implements IMessage,
IMessageHandler<REQ, IMessage> {
    protected MessageContext context;

    public final IMessage onMessage(REQ message, MessageContext ctx) {
        ((AbstractMessage)message).context = ctx;
        try {
            ((AbstractMessage)message).receive();
        }
        catch (MessageException messageException) {
            // empty catch block
        }
        return null;
    }

    public abstract void receive() throws MessageException;

    public EntityPlayer getPlayer() throws MessageException {
        EntityPlayer player;
        Object object = player = this.context.side.isClient() ? Lightsabers.proxy.getPlayer() : this.context.getServerHandler().field_147369_b;
        if (player != null) {
            return player;
        }
        throw new EntityCastException();
    }

    public <T extends Entity> T getEntity(World world, Class<? extends T> type, int id) throws MessageException {
        Entity entity = world.func_73045_a(id);
        if (entity != null && type.isInstance(entity)) {
            return (T)entity;
        }
        throw new EntityCastException();
    }

    public <T extends Entity> T getEntity(Class<? extends T> type, int id) throws MessageException {
        return this.getEntity(this.getWorld(), type, id);
    }

    public EntityPlayer getPlayer(World world, int id) throws MessageException {
        return this.getEntity(world, EntityPlayer.class, id);
    }

    public EntityPlayer getPlayer(int id) throws MessageException {
        return this.getPlayer(this.getWorld(), id);
    }

    public EntityPlayer getSender(World world, int id) throws MessageException {
        return this.context.side.isServer() ? this.getPlayer() : this.getPlayer(world, id);
    }

    public EntityPlayer getSender(int id) throws MessageException {
        return this.getSender(this.getWorld(), id);
    }

    public World getWorld() throws MessageException {
        return this.getPlayer().field_70170_p;
    }

    public World getWorld(int dimension) throws MessageException {
        if (dimension == this.getWorld().field_73011_w.field_76574_g) {
            return this.getWorld();
        }
        if (this.context.side.isServer()) {
            return MinecraftServer.func_71276_C().func_71218_a(dimension);
        }
        throw new InvalidSideException();
    }

    protected static class InvalidSideException
    extends MessageException {
        protected InvalidSideException() {
        }
    }

    protected static class EntityCastException
    extends MessageException {
        protected EntityCastException() {
        }
    }

    protected static class MessageException
    extends Exception {
        protected MessageException() {
        }
    }
}

