/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.utils.common.network;

import com.google.common.collect.Maps;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import cpw.mods.fml.relauncher.Side;
import fiskfille.utils.helper.FiskServerUtils;
import java.util.Map;

public class FiskNetworkHelper {
    private static Map<String, SimpleNetworkWrapper> wrappers = Maps.newHashMap();
    private static Map<String, Integer> ids = Maps.newHashMap();

    public static <REQ extends IMessage & IMessageHandler<REQ, IMessage>> void registerMessage(Class<REQ> msg) {
        FiskNetworkHelper.registerMessage(msg, Side.CLIENT);
        FiskNetworkHelper.registerMessage(msg, Side.SERVER);
    }

    public static <REQ extends IMessage & IMessageHandler<REQ, IMessage>> void registerMessage(Class<REQ> msg, Side side) {
        String modid = FiskServerUtils.getActiveModId();
        FiskNetworkHelper.getWrapper(modid).registerMessage(msg, msg, FiskNetworkHelper.getNextId(modid), side);
    }

    public static SimpleNetworkWrapper getWrapper(String modid) {
        SimpleNetworkWrapper wrapper = wrappers.get(modid);
        if (wrapper == null) {
            wrapper = new SimpleNetworkWrapper(modid);
            wrappers.put(modid, wrapper);
        }
        return wrapper;
    }

    protected static int getNextId(String modid) {
        Integer id = ids.get(modid) != null ? ids.get(modid) : Integer.valueOf(0);
        ids.put(modid, id + 1);
        return id;
    }
}

