/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.utils.common.network;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import fiskfille.utils.common.interaction.Interaction;
import fiskfille.utils.common.interaction.InteractionHandler;
import fiskfille.utils.common.network.AbstractMessage;
import fiskfille.utils.common.network.FiskNetworkManager;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;

public class MessageInteraction
extends AbstractMessage<MessageInteraction> {
    private int id;
    private int x;
    private int y;
    private int z;
    private Interaction interaction;
    private InteractionHandler.InteractionType type;

    public MessageInteraction() {
    }

    public MessageInteraction(EntityPlayer player, Interaction interaction, InteractionHandler.InteractionType type, int x, int y, int z) {
        this.id = player.func_145782_y();
        this.interaction = interaction;
        this.type = type;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void fromBytes(ByteBuf buf) {
        this.id = buf.readInt();
        this.interaction = Interaction.REGISTRY.getObjectById(buf.readByte());
        this.type = InteractionHandler.InteractionType.values()[Math.abs(buf.readByte()) % InteractionHandler.InteractionType.values().length];
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.id);
        buf.writeByte(Interaction.REGISTRY.getIDForObject(this.interaction));
        buf.writeByte(this.type.ordinal());
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
    }

    @Override
    public void receive() throws AbstractMessage.MessageException {
        EntityPlayer sender = this.getSender(this.id);
        EntityPlayer clientPlayer = this.getPlayer();
        if (this.context.side.isClient()) {
            if (sender != clientPlayer) {
                this.interaction.listen(sender, clientPlayer, this.type, Side.CLIENT, this.x, this.y, this.z);
            }
        } else if (this.interaction.listen(sender, clientPlayer, this.type, Side.SERVER, this.x, this.y, this.z)) {
            NetworkRegistry.TargetPoint target = this.interaction.getTargetPoint(sender, this.x, this.y, this.z);
            if (target == null) {
                FiskNetworkManager.wrapper.sendToDimension((IMessage)this, sender.field_71093_bK);
            } else if (target.range > 0.0) {
                FiskNetworkManager.wrapper.sendToAllAround((IMessage)this, target);
            }
        }
    }
}

