/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.utils.helper;

import java.util.Map;
import java.util.Random;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;

public class FiskMath {
    public static final double KMPH = 0.0049467960817423;

    public static <T> T getWeightedD(Random rand, Map<T, Double> map) {
        double totalWeight = 0.0;
        for (Map.Entry<T, Double> e : map.entrySet()) {
            totalWeight += e.getValue().doubleValue();
        }
        double random = rand.nextDouble() * totalWeight;
        for (Map.Entry<T, Double> e : map.entrySet()) {
            if (!((random -= e.getValue().doubleValue()) <= 0.0)) continue;
            return e.getKey();
        }
        return null;
    }

    public static <T> T getWeightedF(Random rand, Map<T, Float> map) {
        float totalWeight = 0.0f;
        for (Map.Entry<T, Float> e : map.entrySet()) {
            totalWeight += e.getValue().floatValue();
        }
        float random = rand.nextFloat() * totalWeight;
        for (Map.Entry<T, Float> e : map.entrySet()) {
            if (!((random -= e.getValue().floatValue()) <= 0.0f)) continue;
            return e.getKey();
        }
        return null;
    }

    public static <T> T getWeightedI(Random rand, Map<T, Integer> map) {
        int totalWeight = 1;
        for (Map.Entry<T, Integer> e : map.entrySet()) {
            totalWeight += e.getValue().intValue();
        }
        int random = rand.nextInt(totalWeight);
        for (Map.Entry<T, Integer> e : map.entrySet()) {
            if ((random -= e.getValue().intValue()) > 0) continue;
            return e.getKey();
        }
        return null;
    }

    public static boolean containsAABB(AxisAlignedBB within, AxisAlignedBB aabb) {
        return aabb.field_72340_a > within.field_72340_a && aabb.field_72338_b > within.field_72338_b && aabb.field_72339_c > within.field_72339_c && aabb.field_72336_d < within.field_72336_d && aabb.field_72337_e < within.field_72337_e && aabb.field_72334_f < within.field_72334_f;
    }

    public static double getScaledDistance(Vec3 src, Vec3 dst, double radius) {
        return (radius - Math.min(src.func_72438_d(dst), radius)) / radius;
    }

    public static float getScaledDistance(Vec3 src, Vec3 dst, float radius) {
        return (float)FiskMath.getScaledDistance(src, dst, (double)radius);
    }

    public static float animate(float frame, float duration, float frameStart) {
        return frame >= frameStart && frame <= frameStart + duration ? (frame - frameStart) / duration : 0.0f;
    }

    public static float animate(float frame, float duration, float frameStart, float fadeIn, float fadeOut) {
        fadeIn = MathHelper.func_76131_a((float)fadeIn, (float)0.0f, (float)duration);
        fadeOut = MathHelper.func_76131_a((float)fadeOut, (float)0.0f, (float)(duration - fadeIn));
        if (frame >= frameStart && frame <= frameStart + duration) {
            float pos = frame - frameStart;
            if (pos > fadeIn && frame < duration - fadeOut) {
                return 1.0f;
            }
            if (pos > fadeIn) {
                frame = frameStart + duration - pos;
                fadeIn = fadeOut;
            }
            return FiskMath.animate(frame, duration, frameStart) * duration / fadeIn;
        }
        return 0.0f;
    }

    public static float curveCrests(float f) {
        return MathHelper.func_76126_a((float)((float)((double)f * Math.PI / 2.0)));
    }

    public static float curve(float f) {
        return (FiskMath.curveCrests(f * 2.0f - 1.0f) + 1.0f) / 2.0f;
    }
}

