/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.utils.helper;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;

public class FiskPredicates {
    public static final Map<Class, Map<String, Predicate>> METHODS = Maps.newHashMap();
    public static final Predicate<Entity> ON_GROUND = new Predicate<Entity>(){

        public boolean apply(Entity input) {
            return input.field_70122_E;
        }
    };
    public static final Predicate<Entity> ALIVE = new Predicate<Entity>(){

        public boolean apply(Entity input) {
            return input.func_70089_S();
        }
    };
    public static final Predicate<Entity> IS_FLYING = new Predicate<Entity>(){

        public boolean apply(Entity input) {
            return input instanceof EntityPlayer && ((EntityPlayer)input).field_71075_bZ.field_75100_b;
        }
    };

    public static <T> Predicate<T> forInput(Class<T> clazz, String input) {
        String[] astring;
        ArrayList list = Lists.newArrayList();
        for (String s : astring = input.split(" && ")) {
            boolean inverted = false;
            while (s.startsWith("!")) {
                s = s.substring(1);
                inverted = !inverted;
            }
            Predicate p = FiskPredicates.getHook(clazz, s);
            if (p == null) continue;
            if (inverted) {
                p = Predicates.not((Predicate)p);
            }
            list.add(p);
        }
        return Predicates.and((Iterable)list);
    }

    public static <T> void addHook(String key, Class<T> clazz, Predicate<T> p) {
        FiskPredicates.getHooks(clazz).put(key, p);
    }

    public static Map<String, Predicate> getHooks(Class clazz) {
        HashMap map = METHODS.get(clazz);
        if (map == null) {
            map = Maps.newHashMap();
            METHODS.put(clazz, map);
        }
        return map;
    }

    public static Predicate getHook(Class clazz, String key) {
        Predicate p = FiskPredicates.getHooks(clazz).get(key);
        return p == null ? Predicates.alwaysFalse() : p;
    }

    public static <K, V> Predicate<Map.Entry<K, V>> filterKeys(final Predicate<K> p) {
        return new Predicate<Map.Entry<K, V>>(){

            public boolean apply(Map.Entry<K, V> input) {
                return p.apply(input.getKey());
            }
        };
    }

    public static <K, V> Predicate<Map.Entry<K, V>> filterValues(final Predicate<V> p) {
        return new Predicate<Map.Entry<K, V>>(){

            public boolean apply(Map.Entry<K, V> input) {
                return p.apply(input.getValue());
            }
        };
    }

    public static Predicate<Object> ofType(final Class<?> type) {
        return new Predicate<Object>(){

            public boolean apply(Object input) {
                return type.isInstance(input);
            }
        };
    }

    static {
        FiskPredicates.addHook("hasTab", Item.class, new Predicate<Item>(){

            public boolean apply(Item input) {
                return input.func_77640_w() != null;
            }
        });
        for (final ModContainer mod : Loader.instance().getModList()) {
            FiskPredicates.addHook("fromMod_" + mod.getModId(), Item.class, new Predicate<Item>(){

                public boolean apply(Item input) {
                    return input.delegate.name().startsWith(mod.getModId() + ":");
                }
            });
        }
    }
}

