/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.utils.helper;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class FiskServerUtils {
    private static final Random rand = new Random();

    public static String getActiveModId() {
        ModContainer container = Loader.instance().activeModContainer();
        if (container != null) {
            return container.getModId();
        }
        return "minecraft";
    }

    public static String getActiveModName() {
        ModContainer container = Loader.instance().activeModContainer();
        if (container != null) {
            return container.getName();
        }
        return "Minecraft";
    }

    public static ItemStack getStackFrom(Object obj) {
        if (obj instanceof Item) {
            return new ItemStack((Item)obj);
        }
        if (obj instanceof Block) {
            return new ItemStack((Block)obj);
        }
        if (obj instanceof ItemStack) {
            return (ItemStack)obj;
        }
        return null;
    }

    public static ItemStack getStackInSlot(EntityPlayer player, int slot) {
        if (slot >= 0 && slot < player.field_71071_by.func_70302_i_()) {
            return player.field_71071_by.func_70301_a(slot);
        }
        return null;
    }

    public static boolean cure(EntityLivingBase entity, Potion potion) {
        if (entity.func_70644_a(potion)) {
            entity.func_82170_o(potion.field_76415_H);
            return true;
        }
        return false;
    }

    public static boolean canEntityEdit(Entity entity, int x, int y, int z, int side, ItemStack heldItem) {
        if (entity instanceof EntityPlayer) {
            return ((EntityPlayer)entity).func_82247_a(x, y, z, side, heldItem);
        }
        if (entity instanceof EntityLivingBase) {
            return entity.field_70170_p.func_82736_K().func_82766_b("mobGriefing");
        }
        return false;
    }

    public static boolean canEntityEdit(Entity entity, MovingObjectPosition mop, ItemStack heldItem) {
        return FiskServerUtils.canEntityEdit(entity, mop.field_72311_b, mop.field_72312_c, mop.field_72309_d, mop.field_72310_e, heldItem);
    }

    public static boolean isMeleeDamage(DamageSource source) {
        return source.func_76346_g() != null && !source.func_82725_o() && !source.func_94541_c() && !source.func_76352_a() && !source.func_76347_k();
    }

    public static boolean isEntityLookingAt(EntityLivingBase observer, Entity entity, double accuracy) {
        Vec3 vec3 = observer.func_70040_Z().func_72432_b();
        Vec3 vec31 = Vec3.func_72443_a((double)(entity.field_70165_t - observer.field_70165_t), (double)(entity.field_70121_D.field_72338_b + (double)(entity.field_70131_O / 2.0f) - (observer.field_70163_u + (double)observer.func_70047_e())), (double)(entity.field_70161_v - observer.field_70161_v));
        double d0 = vec31.func_72433_c();
        double d1 = vec3.func_72430_b(vec31.func_72432_b());
        return d1 > 1.0 - accuracy / d0;
    }

    public static boolean isEntityLookingAt(EntityLivingBase observer, Entity entity) {
        return FiskServerUtils.isEntityLookingAt(observer, entity, 0.5) && observer.func_70685_l(entity);
    }

    public static double interpolate(double a, double b, double progress) {
        return a + (b - a) * progress;
    }

    public static float interpolate(float a, float b, float progress) {
        return (float)FiskServerUtils.interpolate((double)a, (double)b, (double)progress);
    }

    public static <T> T nonNull(T[] iter) {
        for (T t : iter) {
            if (t == null) continue;
            return t;
        }
        return null;
    }

    public static <T> T nonNull(Iterable<T> iter) {
        for (T t : iter) {
            if (t == null) continue;
            return t;
        }
        return null;
    }

    public static <T> T nonNull(Iterable iter, Class<T> filter) {
        for (Object obj : iter) {
            if (obj == null || !filter.isInstance(obj)) continue;
            return obj;
        }
        return null;
    }

    public static void dropItems(World world, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof IInventory) {
            IInventory inventory = (IInventory)tile;
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                ItemStack itemstack = inventory.func_70301_a(i);
                if (itemstack == null) continue;
                float f = rand.nextFloat() * 0.8f + 0.1f;
                float f1 = rand.nextFloat() * 0.8f + 0.1f;
                float f2 = rand.nextFloat() * 0.8f + 0.1f;
                while (itemstack.field_77994_a > 0) {
                    int j = rand.nextInt(21) + 10;
                    if (j > itemstack.field_77994_a) {
                        j = itemstack.field_77994_a;
                    }
                    itemstack.field_77994_a -= j;
                    EntityItem entityitem = new EntityItem(world, (double)((float)x + f), (double)((float)y + f1), (double)((float)z + f2), new ItemStack(itemstack.func_77973_b(), j, itemstack.func_77960_j()));
                    if (itemstack.func_77942_o()) {
                        entityitem.func_92059_d().func_77982_d((NBTTagCompound)itemstack.func_77978_p().func_74737_b());
                    }
                    float f3 = 0.05f;
                    entityitem.field_70159_w = rand.nextGaussian() * (double)f3;
                    entityitem.field_70181_x = rand.nextGaussian() * (double)f3 + 0.2;
                    entityitem.field_70179_y = rand.nextGaussian() * (double)f3;
                    world.func_72838_d((Entity)entityitem);
                }
            }
        }
    }
}

