/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.utils.helper;

import com.fiskmods.lightsabers.ALReflection;
import com.fiskmods.lightsabers.common.data.ALData;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import cpw.mods.fml.common.network.ByteBufUtils;
import fiskfille.utils.DimensionalCoords;
import fiskfille.utils.registry.FiskRegistryEntry;
import fiskfille.utils.registry.FiskSimpleRegistry;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;

public class NBTHelper {
    private static final Map<Class<? extends ISerializableObject>, ISaveAdapter> ADAPTERS = Maps.newHashMap();

    public static List<NBTBase> getTags(NBTTagList nbttaglist) {
        return ALReflection.tagList.get(nbttaglist);
    }

    public static NBTBase writeToNBT(Object obj) {
        if (obj instanceof ISerializableObject) {
            return ((ISerializableObject)obj).writeToNBT();
        }
        if (obj instanceof Byte) {
            return new NBTTagByte(((Byte)obj).byteValue());
        }
        if (obj instanceof Short) {
            return new NBTTagShort(((Short)obj).shortValue());
        }
        if (obj instanceof Integer) {
            return new NBTTagInt(((Integer)obj).intValue());
        }
        if (obj instanceof Long) {
            return new NBTTagLong(((Long)obj).longValue());
        }
        if (obj instanceof Float) {
            return new NBTTagFloat(((Float)obj).floatValue());
        }
        if (obj instanceof Double) {
            return new NBTTagDouble(((Double)obj).doubleValue());
        }
        if (obj instanceof Boolean) {
            return new NBTTagByte((byte)((Boolean)obj != false ? 1 : 0));
        }
        if (obj instanceof String) {
            String s = (String)obj;
            if (s != null) {
                return new NBTTagString(s);
            }
        } else {
            if (obj instanceof List) {
                List list = (List)obj;
                NBTTagList nbttaglist = new NBTTagList();
                for (int i = 0; i < list.size(); ++i) {
                    NBTBase tag = NBTHelper.writeToNBT(list.get(i));
                    if (tag == null) continue;
                    nbttaglist.func_74742_a(tag);
                }
                return nbttaglist;
            }
            if (obj instanceof ItemStack) {
                return ((ItemStack)obj).func_77955_b(new NBTTagCompound());
            }
            if (obj instanceof DimensionalCoords) {
                DimensionalCoords coords = (DimensionalCoords)((Object)obj);
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74768_a("x", coords.field_71574_a);
                nbt.func_74768_a("y", coords.field_71572_b);
                nbt.func_74768_a("z", coords.field_71573_c);
                nbt.func_74768_a("dim", coords.dimension);
                return nbt;
            }
        }
        return null;
    }

    public static <T> T readFromNBT(NBTBase tag, Class<T> type) {
        return NBTHelper.readFromNBT(tag, new ALData.ClassType<T>(type));
    }

    public static <T> T readFromNBT(NBTBase tag, ALData.ClassType<T> typeClass) {
        if (ISerializableObject.class.isAssignableFrom(typeClass.getType())) {
            if (ADAPTERS.containsKey(typeClass.getType())) {
                return ADAPTERS.get(typeClass.getType()).readFromNBT(tag);
            }
            return null;
        }
        if (tag instanceof NBTBase.NBTPrimitive) {
            NBTBase.NBTPrimitive nbt = (NBTBase.NBTPrimitive)tag;
            if (typeClass.getType() == Byte.class) {
                return (T)Byte.valueOf(nbt.func_150290_f());
            }
            if (typeClass.getType() == Short.class) {
                return (T)Short.valueOf(nbt.func_150289_e());
            }
            if (typeClass.getType() == Integer.class) {
                return (T)Integer.valueOf(nbt.func_150287_d());
            }
            if (typeClass.getType() == Long.class) {
                return (T)Long.valueOf(nbt.func_150291_c());
            }
            if (typeClass.getType() == Float.class) {
                return (T)Float.valueOf(nbt.func_150288_h());
            }
            if (typeClass.getType() == Double.class) {
                return (T)Double.valueOf(nbt.func_150286_g());
            }
            if (typeClass.getType() == Boolean.class) {
                return (T)Boolean.valueOf(nbt.func_150290_f() != 0);
            }
        } else {
            if (typeClass.getType() == String.class && tag instanceof NBTTagString) {
                return (T)((NBTTagString)tag).func_150285_a_();
            }
            if (typeClass.getType() == List.class && tag instanceof NBTTagList) {
                List<NBTBase> tags = NBTHelper.getTags((NBTTagList)tag);
                ArrayList list = Lists.newArrayList();
                for (int i = 0; i < tags.size(); ++i) {
                    T entry = NBTHelper.readFromNBT(tags.get(i), typeClass.getParamSafe());
                    if (entry == null) continue;
                    list.add(entry);
                }
                return (T)list;
            }
            if (tag instanceof NBTTagCompound) {
                NBTTagCompound nbt = (NBTTagCompound)tag;
                if (typeClass.getType() == ItemStack.class) {
                    return (T)ItemStack.func_77949_a((NBTTagCompound)nbt);
                }
                if (typeClass.getType() == DimensionalCoords.class) {
                    return (T)((Object)new DimensionalCoords(nbt.func_74762_e("x"), nbt.func_74762_e("y"), nbt.func_74762_e("z"), nbt.func_74762_e("dim")));
                }
            }
        }
        return null;
    }

    public static void toBytes(ByteBuf buf, Object obj) {
        if (obj instanceof Byte) {
            buf.writeByte((int)((Byte)obj).byteValue());
        } else if (obj instanceof Short) {
            buf.writeShort((int)((Short)obj).shortValue());
        } else if (obj instanceof Integer) {
            buf.writeInt(((Integer)obj).intValue());
        } else if (obj instanceof Long) {
            buf.writeLong(((Long)obj).longValue());
        } else if (obj instanceof Float) {
            buf.writeFloat(((Float)obj).floatValue());
        } else if (obj instanceof Double) {
            buf.writeDouble(((Double)obj).doubleValue());
        } else if (obj instanceof Boolean) {
            buf.writeBoolean(((Boolean)obj).booleanValue());
        } else {
            buf.writeBoolean(obj != null);
            if (obj instanceof ISerializableObject) {
                ((ISerializableObject)obj).toBytes(buf);
            } else if (obj instanceof String) {
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)((String)obj));
            } else if (obj instanceof List) {
                List list = (List)obj;
                buf.writeInt(list.size());
                for (int i = 0; i < list.size(); ++i) {
                    NBTHelper.toBytes(buf, list.get(i));
                }
            } else if (obj instanceof ItemStack) {
                ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)((ItemStack)obj));
            } else if (obj instanceof DimensionalCoords) {
                DimensionalCoords coords = (DimensionalCoords)((Object)obj);
                buf.writeInt(coords.field_71574_a);
                buf.writeInt(coords.field_71572_b);
                buf.writeInt(coords.field_71573_c);
                buf.writeInt(coords.dimension);
            }
        }
    }

    public static <T> T fromBytes(ByteBuf buf, Class<T> type) {
        return NBTHelper.fromBytes(buf, new ALData.ClassType<T>(type));
    }

    public static <T> T fromBytes(ByteBuf buf, ALData.ClassType<T> typeClass) {
        if (typeClass.getType() == Byte.class) {
            return (T)Byte.valueOf(buf.readByte());
        }
        if (typeClass.getType() == Short.class) {
            return (T)Short.valueOf(buf.readShort());
        }
        if (typeClass.getType() == Integer.class) {
            return (T)Integer.valueOf(buf.readInt());
        }
        if (typeClass.getType() == Long.class) {
            return (T)Long.valueOf(buf.readLong());
        }
        if (typeClass.getType() == Float.class) {
            return (T)Float.valueOf(buf.readFloat());
        }
        if (typeClass.getType() == Double.class) {
            return (T)Double.valueOf(buf.readDouble());
        }
        if (typeClass.getType() == Boolean.class) {
            return (T)Boolean.valueOf(buf.readBoolean());
        }
        if (buf.readBoolean()) {
            if (ISerializableObject.class.isAssignableFrom(typeClass.getType())) {
                if (ADAPTERS.containsKey(typeClass.getType())) {
                    return ADAPTERS.get(typeClass.getType()).fromBytes(buf);
                }
            } else {
                if (typeClass.getType() == String.class) {
                    return (T)ByteBufUtils.readUTF8String((ByteBuf)buf);
                }
                if (typeClass.getType() == List.class) {
                    ArrayList list = Lists.newArrayList();
                    int size = buf.readInt();
                    for (int i = 0; i < size; ++i) {
                        T entry = NBTHelper.fromBytes(buf, typeClass.getParamSafe());
                        if (entry == null) continue;
                        list.add(entry);
                    }
                    return (T)list;
                }
                if (typeClass.getType() == ItemStack.class) {
                    return (T)ByteBufUtils.readItemStack((ByteBuf)buf);
                }
                if (typeClass.getType() == DimensionalCoords.class) {
                    return (T)((Object)new DimensionalCoords(buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt()));
                }
            }
        }
        return null;
    }

    public static <T extends FiskRegistryEntry<T>> List<T> readNBTList(NBTTagCompound compound, String name, FiskSimpleRegistry<T> registry) {
        ArrayList list = null;
        if (compound.func_150297_b(name, 9)) {
            NBTTagList tagList = compound.func_150295_c(name, 8);
            list = Lists.newArrayList();
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                T entry = registry.getObject(tagList.func_150307_f(i));
                if (entry == null) continue;
                list.add(entry);
            }
        }
        return list;
    }

    public static NBTTagCompound getCompound(String s) {
        try {
            NBTBase tag = JsonToNBT.func_150315_a((String)s);
            if (tag instanceof NBTTagCompound) {
                return (NBTTagCompound)tag;
            }
        }
        catch (NBTException nBTException) {
            // empty catch block
        }
        return new NBTTagCompound();
    }

    public static <T extends ISerializableObject<T>> void registerAdapter(Class<? extends T> type, Class<? extends ISaveAdapter<T>> adapter) {
        try {
            ADAPTERS.put(type, adapter.newInstance());
        }
        catch (Exception e) {
            throw new RuntimeException("An unexpected error occurred while registering save adapter:", e);
        }
    }

    public static interface ISaveAdapter<T extends ISerializableObject<T>> {
        public T readFromNBT(NBTBase var1);

        public T fromBytes(ByteBuf var1);
    }

    public static interface ISerializableObject<T extends ISerializableObject<T>> {
        public NBTBase writeToNBT();

        public void toBytes(ByteBuf var1);
    }
}

