/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.utils.helper;

import com.fiskmods.lightsabers.Lightsabers;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class VectorHelper {
    public static Vec3 getOffsetCoords(EntityLivingBase entity, double xOffset, double yOffset, double zOffset, float partialTicks) {
        Vec3 vec3 = Vec3.func_72443_a((double)xOffset, (double)yOffset, (double)zOffset);
        vec3.func_72440_a(-(entity.field_70125_A + (entity.field_70125_A - entity.field_70127_C) * partialTicks) * (float)Math.PI / 180.0f);
        vec3.func_72442_b(-(entity.field_70177_z + (entity.field_70177_z - entity.field_70126_B) * partialTicks) * (float)Math.PI / 180.0f);
        return Vec3.func_72443_a((double)(entity.field_70165_t + vec3.field_72450_a), (double)(entity.field_70163_u + VectorHelper.getOffset(entity) + vec3.field_72448_b), (double)(entity.field_70161_v + vec3.field_72449_c));
    }

    public static Vec3 getOffsetCoords(EntityLivingBase entity, double xOffset, double yOffset, double zOffset) {
        return VectorHelper.getOffsetCoords(entity, xOffset, yOffset, zOffset, 1.0f);
    }

    public static Vec3 copy(Vec3 vec3) {
        return Vec3.func_72443_a((double)vec3.field_72450_a, (double)vec3.field_72448_b, (double)vec3.field_72449_c);
    }

    public static Vec3 add(Vec3 vec3, Vec3 vec31) {
        return Vec3.func_72443_a((double)(vec3.field_72450_a + vec31.field_72450_a), (double)(vec3.field_72448_b + vec31.field_72448_b), (double)(vec3.field_72449_c + vec31.field_72449_c));
    }

    public static Vec3 multiply(Vec3 vec3, Vec3 vec31) {
        return Vec3.func_72443_a((double)(vec3.field_72450_a * vec31.field_72450_a), (double)(vec3.field_72448_b * vec31.field_72448_b), (double)(vec3.field_72449_c * vec31.field_72449_c));
    }

    public static Vec3 multiply(Vec3 vec3, double factor) {
        return VectorHelper.multiply(vec3, Vec3.func_72443_a((double)factor, (double)factor, (double)factor));
    }

    public static Vec3 interpolate(Vec3 vec3, Vec3 vec31, double distance) {
        double d = distance / vec3.func_72438_d(vec31);
        return VectorHelper.add(VectorHelper.multiply(vec3, d), VectorHelper.multiply(vec31, 1.0 - d));
    }

    public static Vec3 centerOf(Entity entity) {
        return Vec3.func_72443_a((double)entity.field_70165_t, (double)(entity.field_70121_D.field_72338_b + (double)(entity.field_70131_O / 2.0f)), (double)entity.field_70161_v);
    }

    public static Vec3 getPosition(Entity entity, float partialTicks) {
        if (partialTicks == 1.0f) {
            return Vec3.func_72443_a((double)entity.field_70165_t, (double)entity.field_70163_u, (double)entity.field_70161_v);
        }
        double d0 = entity.field_70169_q + (entity.field_70165_t - entity.field_70169_q) * (double)partialTicks;
        double d1 = entity.field_70167_r + (entity.field_70163_u - entity.field_70167_r) * (double)partialTicks;
        double d2 = entity.field_70166_s + (entity.field_70161_v - entity.field_70166_s) * (double)partialTicks;
        return Vec3.func_72443_a((double)d0, (double)d1, (double)d2);
    }

    public static double getOffset(EntityLivingBase entity) {
        double yOffset = entity.func_70047_e();
        if (entity instanceof EntityPlayer && entity.field_70170_p.field_72995_K) {
            yOffset -= (double)((EntityPlayer)entity).getDefaultEyeHeight();
            if (!Lightsabers.proxy.isClientPlayer(entity)) {
                yOffset += (double)1.62f;
            }
        }
        return yOffset;
    }

    public static Vec3 getBackSideCoordsRenderYawOffset(EntityLivingBase entity, double amount, boolean side, double backAmount, boolean pitch) {
        Vec3 front = VectorHelper.getFrontCoordsRenderYawOffset(entity, backAmount, pitch).func_72441_c(-entity.field_70165_t, -(entity.field_70163_u + VectorHelper.getOffset(entity)), -entity.field_70161_v);
        return VectorHelper.getSideCoordsRenderYawOffset(entity, amount, side).func_72441_c(front.field_72450_a, front.field_72448_b, front.field_72449_c);
    }

    public static Vec3 getSideCoordsRenderYawOffset(EntityLivingBase entity, double amount, boolean side) {
        return VectorHelper.getSideCoordsRenderYawOffset(entity, amount, side ? -90 : 90);
    }

    public static Vec3 getSideCoordsRenderYawOffset(EntityLivingBase entity, double amount, int side) {
        float pitch = 0.0f;
        float yaw = entity.field_70761_aq + (float)side;
        float f3 = MathHelper.func_76134_b((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = MathHelper.func_76126_a((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f5 = -MathHelper.func_76134_b((float)(-pitch * ((float)Math.PI / 180)));
        float yScale = MathHelper.func_76126_a((float)(-pitch * ((float)Math.PI / 180)));
        float xScale = f4 * f5;
        float zScale = f3 * f5;
        return Vec3.func_72443_a((double)entity.field_70165_t, (double)(entity.field_70163_u + VectorHelper.getOffset(entity)), (double)entity.field_70161_v).func_72441_c((double)xScale * amount, (double)yScale * amount, (double)zScale * amount);
    }

    public static Vec3 getFrontCoordsRenderYawOffset(EntityLivingBase entity, double amount, boolean applyPitch) {
        float pitch = applyPitch ? entity.field_70125_A : 0.0f;
        float yaw = entity.field_70761_aq;
        float f3 = MathHelper.func_76134_b((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = MathHelper.func_76126_a((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f5 = -MathHelper.func_76134_b((float)(-pitch * ((float)Math.PI / 180)));
        float yScale = MathHelper.func_76126_a((float)(-pitch * ((float)Math.PI / 180)));
        float xScale = f4 * f5;
        float zScale = f3 * f5;
        return Vec3.func_72443_a((double)entity.field_70165_t, (double)(entity.field_70163_u + VectorHelper.getOffset(entity)), (double)entity.field_70161_v).func_72441_c((double)xScale * amount, (double)yScale * amount, (double)zScale * amount);
    }

    public static <T extends Entity> List<T> getEntitiesNear(Class<T> type, World world, double x, double y, double z, double radius) {
        return world.func_72872_a(type, AxisAlignedBB.func_72330_a((double)(x - radius), (double)(y - radius), (double)(z - radius), (double)(x + radius), (double)(y + radius), (double)(z + radius)));
    }

    public static <T extends Entity> List<T> getEntitiesNear(Class<T> type, World world, Vec3 vec3, double radius) {
        return VectorHelper.getEntitiesNear(type, world, vec3.field_72450_a, vec3.field_72448_b, vec3.field_72449_c, radius);
    }
}

