/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.utils.reflection;

import java.lang.reflect.Method;
import java.util.Arrays;

public class GenericMethod<C, T> {
    private final Method theMethod;

    public GenericMethod(Method method) {
        this.theMethod = method;
    }

    public T invoke(C instance, Object ... args) {
        try {
            return (T)this.theMethod.invoke(instance, args);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public T invokeStatic(Object ... args) {
        return this.invoke(null, args);
    }

    public static class Builder<C, T> {
        private final Class<C> parentClass;
        private final Class<T> returnType;
        private Class[] parameters;

        private Builder(Class<C> parent, Class<T> type) {
            this.parentClass = parent;
            this.returnType = type;
        }

        public static <C, T> Builder in(Class<C> parent, Class<T> type) {
            return new Builder<C, T>(parent, type);
        }

        public Builder with(Class ... params) {
            this.parameters = params;
            return this;
        }

        public GenericMethod find(String ... names) {
            for (String name : names) {
                for (Method method : this.parentClass.getDeclaredMethods()) {
                    if (!method.getName().equals(name) || method.getReturnType() != this.returnType) continue;
                    if (this.parameters != null) {
                        if (method.getParameters().length != this.parameters.length) continue;
                        for (int i = 0; i < this.parameters.length; ++i) {
                            if (method.getParameterTypes()[i] == this.parameters[i]) continue;
                        }
                    }
                    method.setAccessible(true);
                    return new GenericMethod(method);
                }
            }
            throw new RuntimeException(String.format("Unable to locate method of type %s in %s: %s", this.returnType.getName(), this.parentClass.getName(), Arrays.asList(names)));
        }
    }
}

