/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.utils.registry;

import com.google.common.reflect.TypeToken;
import cpw.mods.fml.common.FMLContainer;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.InjectedModContainer;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import fiskfille.utils.registry.FiskDelegate;
import java.util.Locale;
import net.minecraft.util.ResourceLocation;

public class FiskRegistryEntry<T> {
    public final FiskDelegate<T> delegate = new FiskDelegate<FiskRegistryEntry>(this, this.getClass());
    private TypeToken<T> token = new TypeToken<T>(this.getClass()){};
    private ResourceLocation registryName = null;

    public final T setRegistryName(String name) {
        String prefix;
        if (this.getRegistryName() != null) {
            throw new IllegalStateException("Attempted to set registry name with existing registry name! New: " + name + " Old: " + this.getRegistryName());
        }
        this.delegate.setName(name);
        int index = name.lastIndexOf(58);
        String oldPrefix = index == -1 ? "" : name.substring(0, index);
        name = index == -1 ? name : name.substring(index + 1);
        ModContainer mc = Loader.instance().activeModContainer();
        String string = prefix = mc == null || mc instanceof InjectedModContainer && ((InjectedModContainer)mc).wrappedContainer instanceof FMLContainer ? "minecraft" : mc.getModId().toLowerCase(Locale.ROOT);
        if (!oldPrefix.equals(prefix) && oldPrefix.length() > 0) {
            FMLLog.bigWarning((String)"Dangerous alternative prefix '%s' for name '%s', expected '%s' invalid registry invocation/invalid name?", (Object[])new Object[]{oldPrefix, name, prefix});
            prefix = oldPrefix;
        }
        this.registryName = new ResourceLocation(prefix, name);
        return (T)this;
    }

    public final T setRegistryName(ResourceLocation name) {
        return this.setRegistryName(name.toString());
    }

    public final T setRegistryName(String domain, String name) {
        return this.setRegistryName(domain + ":" + name);
    }

    public final ResourceLocation getRegistryName() {
        return this.registryName;
    }

    public final String getDomain() {
        return this.registryName.func_110624_b();
    }

    public final Class<T> getRegistryType() {
        return this.token.getRawType();
    }

    public String toString() {
        return this.delegate.name();
    }
}

