/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.utils.registry;

import fiskfille.utils.registry.FiskRegistryEntry;
import fiskfille.utils.registry.FiskSimpleRegistry;
import java.util.Iterator;
import net.minecraft.util.ObjectIntIdentityMap;

public class FiskRegistryNamespaced<T extends FiskRegistryEntry<T>>
extends FiskSimpleRegistry<T> {
    protected ObjectIntIdentityMap underlyingIntegerMap = new ObjectIntIdentityMap();
    private int maxId = 0;
    private int nextId = 0;

    public FiskRegistryNamespaced(String domain, String key) {
        super(domain, key);
    }

    public FiskRegistryNamespaced<T> setMaxId(int max) {
        this.maxId = max;
        return this;
    }

    @Override
    public void putObject(String key, T value) {
        this.addObject(this.nextId, key, value);
        ++this.nextId;
    }

    public void addObject(int id, String key, T value) {
        if (id < 0 || this.maxId > 0 && id > this.maxId) {
            throw new IndexOutOfBoundsException(String.format("Index: %s, Max: %s", id, this.maxId));
        }
        super.putObject(key, value);
        this.underlyingIntegerMap.func_148746_a(value, id);
    }

    public int getIDForObject(T value) {
        return this.underlyingIntegerMap.func_148747_b(value);
    }

    public T getObjectById(int id) {
        return (T)this.castDefault((FiskRegistryEntry)this.underlyingIntegerMap.func_148745_a(id));
    }

    public boolean containsId(int id) {
        return this.underlyingIntegerMap.func_148744_b(id);
    }

    @Override
    public Iterator iterator() {
        return this.underlyingIntegerMap.iterator();
    }

    public T lookup(String key) {
        if (this.containsKey(key)) {
            return this.getObject(key);
        }
        try {
            int id = Integer.parseInt(key);
            if (this.containsId(id)) {
                return this.getObjectById(id);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }
}

