/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.utils.registry;

import com.google.common.base.Predicate;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import fiskfille.utils.helper.FiskPredicates;
import fiskfille.utils.registry.FiskRegistryEntry;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.util.RegistrySimple;

public class FiskSimpleRegistry<T extends FiskRegistryEntry<T>>
extends RegistrySimple
implements Iterable<T> {
    protected final Map nameLookup;
    private final String defaultDomain;
    private final String defaultKey;
    private T defaultValue;

    public FiskSimpleRegistry(String domain, String key) {
        this.nameLookup = ((BiMap)this.field_82596_a).inverse();
        this.defaultDomain = domain;
        this.defaultKey = this.namespace(key);
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public void putObject(String key, T value) {
        if (this.containsKey(key = this.namespace(key))) {
            throw new IllegalArgumentException(String.format("Duplicate key '%s'", key));
        }
        if (this.defaultKey != null && key.equals(this.defaultKey)) {
            this.defaultValue = value;
        }
        ((FiskRegistryEntry)value).setRegistryName(key);
        super.func_82595_a((Object)key, value);
    }

    public void func_82595_a(Object key, Object value) {
        this.putObject((String)key, (FiskRegistryEntry)value);
    }

    protected Map func_148740_a() {
        return HashBiMap.create();
    }

    public T getObject(String key) {
        return (T)this.castDefault((FiskRegistryEntry)super.func_82594_a((Object)this.namespace(key)));
    }

    public String getNameForObject(T value) {
        return (String)this.nameLookup.get(value);
    }

    public boolean containsKey(String key) {
        return super.func_148741_d((Object)this.namespace(key));
    }

    @Override
    public Iterator<T> iterator() {
        return this.field_82596_a.values().iterator();
    }

    protected String namespace(String key) {
        return key != null && key.indexOf(58) == -1 ? this.defaultDomain + ":" + key : key;
    }

    public boolean func_148741_d(Object key) {
        return this.containsKey((String)key);
    }

    public boolean containsValue(T value) {
        return this.field_82596_a.values().contains(value);
    }

    public T getObject(Object key) {
        return this.getObject((String)key);
    }

    public Set<String> func_148742_b() {
        return super.func_148742_b();
    }

    public Set<String> getKeys(Predicate<T> p) {
        return Maps.filterEntries((Map)this.field_82596_a, FiskPredicates.filterValues(p)).keySet();
    }

    public T castDefault(T value) {
        if (value == null) {
            return this.getDefaultValue();
        }
        return value;
    }

    public T getRandom(Random rand) {
        return (T)((FiskRegistryEntry)Iterables.get((Iterable)this, (int)rand.nextInt(this.func_148742_b().size())));
    }

    public T getRandom() {
        return this.getRandom(new Random());
    }
}

