/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import java.util.HashSet;
import java.util.Set;
import mekanism.api.Coord4D;
import mekanism.common.integration.IComputerIntegration;
import mekanism.common.tile.TileEntityContainerBlock;
import mekanism.common.tile.TileEntityThermalEvaporationController;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityThermalEvaporationBlock
extends TileEntityContainerBlock
implements IComputerIntegration {
    public Coord4D master;
    public boolean attempted;
    private static final String[] methods = new String[]{"getTemperature", "getHeight", "isFormed", "getInput", "getOutput"};

    public TileEntityThermalEvaporationBlock() {
        super("ThermalEvaporationBlock");
        this.inventory = new ItemStack[0];
    }

    public TileEntityThermalEvaporationBlock(String fullName) {
        super(fullName);
        this.inventory = new ItemStack[0];
    }

    @Override
    public void onUpdate() {
        if (!this.field_145850_b.field_72995_K && this.ticker == 5 && !this.attempted && this.master == null) {
            this.updateController();
        }
        this.attempted = false;
    }

    public void addToStructure(Coord4D controller) {
        this.master = controller;
    }

    public void controllerGone() {
        this.master = null;
    }

    public void onChunkUnload() {
        TileEntityThermalEvaporationController tile;
        super.onChunkUnload();
        if (this.master != null && (tile = this.getController()) != null) {
            tile.refresh();
        }
    }

    @Override
    public void onNeighborChange(Block block) {
        super.onNeighborChange(block);
        if (!this.field_145850_b.field_72995_K) {
            TileEntityThermalEvaporationController tile = this.getController();
            if (tile != null) {
                tile.refresh();
            } else {
                this.updateController();
            }
        }
    }

    public void updateController() {
        TileEntityThermalEvaporationController found;
        if (!(this instanceof TileEntityThermalEvaporationController) && (found = new ControllerFinder().find()) != null) {
            found.refresh();
        }
    }

    public TileEntityThermalEvaporationController getController() {
        TileEntity tile;
        if (this.master != null && (tile = this.master.getTileEntity((IBlockAccess)this.field_145850_b)) instanceof TileEntityThermalEvaporationController) {
            return (TileEntityThermalEvaporationController)tile;
        }
        return null;
    }

    @Override
    public String[] getMethods() {
        return methods;
    }

    @Override
    public Object[] invoke(int method, Object[] args) throws Exception {
        TileEntityThermalEvaporationController controller = this.getController();
        if (controller == null) {
            return new Object[]{"Unformed."};
        }
        switch (method) {
            case 0: {
                return new Object[]{Float.valueOf(controller.temperature)};
            }
            case 1: {
                return new Object[]{controller.height};
            }
            case 2: {
                return new Object[]{controller.structured};
            }
            case 3: {
                return new Object[]{controller.inputTank.getFluidAmount()};
            }
            case 4: {
                return new Object[]{controller.outputTank.getFluidAmount()};
            }
        }
        throw new NoSuchMethodException();
    }

    public class ControllerFinder {
        public TileEntityThermalEvaporationController found;
        public Set<Coord4D> iterated = new HashSet<Coord4D>();

        public void loop(Coord4D pos) {
            if (this.iterated.size() > 512 || this.found != null) {
                return;
            }
            this.iterated.add(pos);
            for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                Coord4D coord = pos.getFromSide(side);
                if (this.iterated.contains(coord) || !(coord.getTileEntity((IBlockAccess)TileEntityThermalEvaporationBlock.this.field_145850_b) instanceof TileEntityThermalEvaporationBlock)) continue;
                ((TileEntityThermalEvaporationBlock)coord.getTileEntity((IBlockAccess)((TileEntityThermalEvaporationBlock)TileEntityThermalEvaporationBlock.this).field_145850_b)).attempted = true;
                if (coord.getTileEntity((IBlockAccess)TileEntityThermalEvaporationBlock.this.field_145850_b) instanceof TileEntityThermalEvaporationController) {
                    this.found = (TileEntityThermalEvaporationController)coord.getTileEntity((IBlockAccess)TileEntityThermalEvaporationBlock.this.field_145850_b);
                    return;
                }
                this.loop(coord);
            }
        }

        public TileEntityThermalEvaporationController find() {
            this.loop(Coord4D.get(TileEntityThermalEvaporationBlock.this));
            return this.found;
        }
    }
}

