/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import mekanism.api.Coord4D;
import mekanism.api.transmitters.ITransmitterTile;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public final class PipeUtils {
    public static final FluidTankInfo[] EMPTY = new FluidTankInfo[0];

    public static boolean isValidAcceptorOnSide(TileEntity tile, ForgeDirection side) {
        if (tile instanceof ITransmitterTile || !(tile instanceof IFluidHandler)) {
            return false;
        }
        IFluidHandler container = (IFluidHandler)tile;
        FluidTankInfo[] infoArray = container.getTankInfo(side.getOpposite());
        if (container.canDrain(side.getOpposite(), FluidRegistry.WATER) || container.canFill(side.getOpposite(), FluidRegistry.WATER)) {
            return true;
        }
        if (infoArray != null && infoArray.length > 0) {
            for (FluidTankInfo info : infoArray) {
                if (info == null) continue;
                return true;
            }
        }
        return false;
    }

    public static IFluidHandler[] getConnectedAcceptors(TileEntity tileEntity) {
        IFluidHandler[] acceptors = new IFluidHandler[]{null, null, null, null, null, null};
        for (ForgeDirection orientation : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity acceptor = Coord4D.get(tileEntity).getFromSide(orientation).getTileEntity((IBlockAccess)tileEntity.func_145831_w());
            if (!(acceptor instanceof IFluidHandler)) continue;
            acceptors[orientation.ordinal()] = (IFluidHandler)acceptor;
        }
        return acceptors;
    }

    public static int emit(List<ForgeDirection> sides, FluidStack stack, TileEntity from) {
        int toSend;
        if (stack == null) {
            return 0;
        }
        ArrayList<IFluidHandler> availableAcceptors = new ArrayList<IFluidHandler>();
        IFluidHandler[] possibleAcceptors = PipeUtils.getConnectedAcceptors(from);
        for (int i = 0; i < possibleAcceptors.length; ++i) {
            IFluidHandler handler = possibleAcceptors[i];
            if (handler == null || !handler.canFill(ForgeDirection.getOrientation((int)i).getOpposite(), stack.getFluid())) continue;
            availableAcceptors.add(handler);
        }
        Collections.shuffle(availableAcceptors);
        int prevSending = toSend = stack.amount;
        if (!availableAcceptors.isEmpty()) {
            int divider = availableAcceptors.size();
            int remaining = toSend % divider;
            int sending = (toSend - remaining) / divider;
            for (IFluidHandler acceptor : availableAcceptors) {
                int currentSending = sending;
                if (remaining > 0) {
                    ++currentSending;
                    --remaining;
                }
                ForgeDirection dir = ForgeDirection.getOrientation((int)Arrays.asList(possibleAcceptors).indexOf(acceptor)).getOpposite();
                toSend -= acceptor.fill(dir, PipeUtils.copy(stack, currentSending), true);
            }
        }
        return prevSending - toSend;
    }

    public static FluidStack copy(FluidStack fluid, int amount) {
        FluidStack ret = fluid.copy();
        ret.amount = amount;
        return ret;
    }
}

