/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive;

import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.registry.EntityRegistry;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.entity.EntityParticleBunch;
import cr0s.warpdrive.render.EntityCamera;
import cr0s.warpdrive.world.EntitySphereGen;
import cr0s.warpdrive.world.EntityStarCore;
import java.lang.ref.WeakReference;
import java.util.UUID;
import java.util.WeakHashMap;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.WorldSettings;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.event.world.BlockEvent;

public class CommonProxy {
    private static final WeakHashMap<GameProfile, WeakReference<EntityPlayer>> fakePlayers = new WeakHashMap(100);

    void registerEntities() {
        EntityRegistry.registerModEntity(EntitySphereGen.class, (String)"EntitySphereGenerator", (int)WarpDriveConfig.G_ENTITY_SPHERE_GENERATOR_ID, (Object)WarpDrive.instance, (int)200, (int)1, (boolean)false);
        EntityRegistry.registerModEntity(EntityStarCore.class, (String)"EntityStarCore", (int)WarpDriveConfig.G_ENTITY_STAR_CORE_ID, (Object)WarpDrive.instance, (int)300, (int)1, (boolean)false);
        EntityRegistry.registerModEntity(EntityCamera.class, (String)"EntityCamera", (int)WarpDriveConfig.G_ENTITY_CAMERA_ID, (Object)WarpDrive.instance, (int)300, (int)1, (boolean)false);
        EntityRegistry.registerModEntity(EntityParticleBunch.class, (String)"EntityParticleBunch", (int)WarpDriveConfig.G_ENTITY_PARTICLE_BUNCH_ID, (Object)WarpDrive.instance, (int)300, (int)1, (boolean)false);
    }

    public void registerRendering() {
    }

    private static EntityPlayerMP getPlayer(UUID uuidPlayer) {
        for (Object object : MinecraftServer.func_71276_C().func_71203_ab().field_72404_b) {
            EntityPlayerMP entityPlayerMP;
            if (!(object instanceof EntityPlayerMP) || (entityPlayerMP = (EntityPlayerMP)object).func_110124_au() != uuidPlayer) continue;
            return entityPlayerMP;
        }
        return null;
    }

    private static EntityPlayer getFakePlayer(UUID uuidPlayer, WorldServer world, double x, double y, double z) {
        EntityPlayer entityFakePlayer;
        EntityPlayerMP entityPlayer = uuidPlayer == null ? null : CommonProxy.getPlayer(uuidPlayer);
        GameProfile gameProfile = entityPlayer == null ? WarpDrive.gameProfile : entityPlayer.func_146103_bH();
        WeakReference<EntityPlayer> weakFakePlayer = fakePlayers.get(gameProfile);
        EntityPlayer entityPlayer2 = entityFakePlayer = weakFakePlayer == null ? null : (EntityPlayer)weakFakePlayer.get();
        if (entityFakePlayer == null) {
            entityFakePlayer = FakePlayerFactory.get((WorldServer)world, (GameProfile)gameProfile);
            ((EntityPlayerMP)entityFakePlayer).field_71134_c.func_73076_a(WorldSettings.GameType.SURVIVAL);
            weakFakePlayer = new WeakReference<EntityPlayer>(entityFakePlayer);
            fakePlayers.put(gameProfile, weakFakePlayer);
        } else {
            entityFakePlayer.field_70170_p = world;
        }
        entityFakePlayer.field_70165_t = x;
        entityFakePlayer.field_70163_u = y;
        entityFakePlayer.field_70161_v = z;
        return entityFakePlayer;
    }

    public static EntityPlayer getFakePlayer(UUID uuidPlayer, World world, double x, double y, double z) {
        if (world.field_72995_K || !(world instanceof WorldServer)) {
            return null;
        }
        return CommonProxy.getFakePlayer(uuidPlayer, (WorldServer)world, x, y, z);
    }

    public static boolean isBlockBreakCanceled(UUID uuidPlayer, int sourceX, int sourceY, int sourceZ, World world, int eventX, int eventY, int eventZ) {
        Block block;
        if (world.field_72995_K || !(world instanceof WorldServer)) {
            return false;
        }
        if (WarpDriveConfig.LOGGING_BREAK_PLACE) {
            WarpDrive.logger.info("isBlockBreakCanceled by " + uuidPlayer + " at " + sourceX + " " + sourceY + " " + sourceZ + " to " + world.field_73011_w.func_80007_l() + " " + eventX + " " + eventY + " " + eventZ);
        }
        if (!(block = world.func_147439_a(eventX, eventY, eventZ)).isAir((IBlockAccess)world, eventX, eventY, eventZ)) {
            BlockEvent.BreakEvent breakEvent = new BlockEvent.BreakEvent(eventX, eventY, eventZ, world, world.func_147439_a(eventX, eventY, eventZ), world.func_72805_g(eventX, eventY, eventZ), CommonProxy.getFakePlayer(uuidPlayer, (WorldServer)world, (double)sourceX + 0.5, (double)sourceY + 0.5, (double)sourceZ + 0.5));
            MinecraftForge.EVENT_BUS.post((Event)breakEvent);
            if (WarpDriveConfig.LOGGING_BREAK_PLACE) {
                WarpDrive.logger.info("isBlockBreakCanceled player " + breakEvent.getPlayer() + " isCanceled " + breakEvent.isCanceled());
            }
            return breakEvent.isCanceled();
        }
        return false;
    }

    public static boolean isBlockPlaceCanceled(UUID uuidPlayer, int sourceX, int sourceY, int sourceZ, World world, int eventX, int eventY, int eventZ, Block block, int metadata) {
        if (world.field_72995_K || !(world instanceof WorldServer)) {
            return false;
        }
        if (WarpDriveConfig.LOGGING_BREAK_PLACE) {
            WarpDrive.logger.info("isBlockPlaceCanceled by " + uuidPlayer + " at " + sourceX + " " + sourceY + " " + sourceZ + " to " + world.field_73011_w.func_80007_l() + " " + eventX + " " + eventY + " " + eventZ + " of " + Block.field_149771_c.func_148750_c((Object)block) + ":" + metadata);
        }
        BlockEvent.PlaceEvent placeEvent = new BlockEvent.PlaceEvent(new BlockSnapshot(world, eventX, eventY, eventZ, block, metadata), Blocks.field_150350_a, CommonProxy.getFakePlayer(uuidPlayer, (WorldServer)world, (double)sourceX + 0.5, (double)sourceY + 0.5, (double)sourceZ + 0.5));
        MinecraftForge.EVENT_BUS.post((Event)placeEvent);
        if (WarpDriveConfig.LOGGING_BREAK_PLACE) {
            WarpDrive.logger.info("isBlockPlaceCanceled player " + placeEvent.player + " isCanceled " + placeEvent.isCanceled());
        }
        return placeEvent.isCanceled();
    }
}

