/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.api;

import cr0s.warpdrive.data.Vector3;

public interface IBeamFrequency {
    public static final int BEAM_FREQUENCY_SCANNING = 1420;
    public static final int BEAM_FREQUENCY_MIN = 0;
    public static final int BEAM_FREQUENCY_MAX = 65000;
    public static final String BEAM_FREQUENCY_TAG = "beamFrequency";

    public int getBeamFrequency();

    public void setBeamFrequency(int var1);

    public static Vector3 getBeamColor(int beamFrequency) {
        float b;
        float g;
        float r;
        if (beamFrequency <= 0) {
            r = 1.0f;
            g = 0.0f;
            b = 0.0f;
        } else if (beamFrequency <= 10000) {
            r = 1.0f;
            g = 0.0f;
            b = 0.0f + 0.5f * (float)beamFrequency / 10000.0f;
        } else if (beamFrequency <= 20000) {
            r = 1.0f;
            g = 0.0f + 1.0f * ((float)beamFrequency - 10000.0f) / 10000.0f;
            b = 0.5f - 0.5f * ((float)beamFrequency - 10000.0f) / 10000.0f;
        } else if (beamFrequency <= 30000) {
            r = 1.0f - 1.0f * ((float)beamFrequency - 20000.0f) / 10000.0f;
            g = 1.0f;
            b = 0.0f;
        } else if (beamFrequency <= 40000) {
            r = 0.0f;
            g = 1.0f - 1.0f * ((float)beamFrequency - 30000.0f) / 10000.0f;
            b = 0.0f + 1.0f * ((float)beamFrequency - 30000.0f) / 10000.0f;
        } else if (beamFrequency <= 50000) {
            r = 0.0f + 0.5f * ((float)beamFrequency - 40000.0f) / 10000.0f;
            g = 0.0f;
            b = 1.0f - 0.5f * ((float)beamFrequency - 40000.0f) / 10000.0f;
        } else if (beamFrequency <= 60000) {
            r = 0.5f + 0.5f * ((float)beamFrequency - 50000.0f) / 10000.0f;
            g = 0.0f;
            b = 0.5f - 0.5f * ((float)beamFrequency - 50000.0f) / 10000.0f;
        } else if (beamFrequency <= 65000) {
            int component = Math.round(4096.0f * ((float)beamFrequency - 60000.0f) / 5000.0f);
            r = 1.0f - 0.5f * (float)(component & 0xF);
            g = 0.5f + 0.5f * (float)(component >> 4 & 0xF);
            b = 0.5f + 0.5f * (float)(component >> 8 & 0xF);
        } else {
            r = 1.0f;
            g = 0.0f;
            b = 0.0f;
        }
        return new Vector3(r, g, b);
    }
}

