/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.IBlockBase;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class BlockAbstractBase
extends Block
implements IBlockBase {
    protected boolean isRotating = false;

    protected BlockAbstractBase(Material material) {
        super(material);
        this.func_149711_c(5.0f);
        this.func_149752_b(10.0f);
        this.func_149672_a(Block.field_149777_j);
        this.func_149647_a(WarpDrive.creativeTabWarpDrive);
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entityLiving, ItemStack itemStack) {
        int metadata;
        super.func_149689_a(world, x, y, z, entityLiving, itemStack);
        if (this.isRotating && (metadata = Commons.getFacingFromEntity(entityLiving)) >= 0 && metadata <= 15) {
            world.func_72921_c(x, y, z, metadata, 3);
        }
    }

    public boolean rotateBlock(World world, int x, int y, int z, ForgeDirection axis) {
        if (this.isRotating) {
            world.func_72921_c(x, y, z, axis.ordinal(), 3);
            return true;
        }
        return false;
    }

    @Override
    public byte getTier(ItemStack itemStack) {
        return 1;
    }

    @Override
    public EnumRarity getRarity(ItemStack itemStack, EnumRarity rarity) {
        switch (this.getTier(itemStack)) {
            case 0: {
                return EnumRarity.epic;
            }
            case 1: {
                return EnumRarity.common;
            }
            case 2: {
                return EnumRarity.uncommon;
            }
            case 3: {
                return EnumRarity.rare;
            }
        }
        return rarity;
    }
}

