/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block;

import cr0s.warpdrive.CommonProxy;
import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.IBeamFrequency;
import cr0s.warpdrive.api.IBlockUpdateDetector;
import cr0s.warpdrive.api.IVideoChannel;
import cr0s.warpdrive.block.detection.TileEntityCamera;
import cr0s.warpdrive.block.weapon.TileEntityLaserCamera;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.CameraRegistryItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public abstract class TileEntityAbstractBase
extends TileEntity
implements IBlockUpdateDetector {
    private boolean isFirstTick = true;
    private boolean isDirty = false;
    private final HashMap<Object, Integer> installedUpgrades = new HashMap(10);
    private final HashMap<Object, Integer> maxUpgrades = new HashMap(10);

    protected void onFirstUpdateTick() {
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (this.isFirstTick) {
            this.isFirstTick = false;
            this.onFirstUpdateTick();
        }
        if (this.isDirty) {
            this.func_70296_d();
        }
    }

    protected boolean isFirstTick() {
        return this.isFirstTick;
    }

    @Override
    public void onBlockUpdateDetected() {
    }

    protected void updateMetadata(int metadata) {
        if (this.func_145832_p() != metadata) {
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, metadata, 2);
        }
    }

    public void func_70296_d() {
        if (this.func_145830_o() && Commons.isSafeThread()) {
            super.func_70296_d();
            this.isDirty = false;
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            WarpDrive.starMap.onBlockUpdated(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q(), this.func_145832_p());
        } else {
            this.isDirty = true;
        }
    }

    protected boolean addToConnectedInventories(ItemStack itemStack) {
        ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>(1);
        itemStacks.add(itemStack);
        return this.addToInventories(itemStacks, Commons.getConnectedInventories(this));
    }

    protected boolean addToConnectedInventories(List<ItemStack> itemStacks) {
        return this.addToInventories(itemStacks, Commons.getConnectedInventories(this));
    }

    protected boolean addToInventories(List<ItemStack> itemStacks, Collection<IInventory> inventories) {
        boolean overflow = false;
        if (itemStacks != null) {
            for (ItemStack itemStack : itemStacks) {
                IInventory inventory;
                if (itemStack.func_77973_b() == null) {
                    WarpDrive.logger.error(this + "Invalid itemStack with null item...");
                    continue;
                }
                int qtyLeft = itemStack.field_77994_a;
                ItemStack itemStackLeft = itemStack.func_77946_l();
                Iterator<IInventory> iterator = inventories.iterator();
                while (iterator.hasNext() && (qtyLeft = TileEntityAbstractBase.addToInventory(itemStack, inventory = iterator.next())) > 0) {
                    itemStackLeft.field_77994_a = qtyLeft;
                }
                if (qtyLeft <= 0) continue;
                if (WarpDriveConfig.LOGGING_COLLECTION) {
                    WarpDrive.logger.info(this + " Overflow detected");
                }
                overflow = true;
                while (qtyLeft > 0) {
                    int transfer = Math.min(qtyLeft, itemStackLeft.func_77976_d());
                    ItemStack itemStackDrop = Commons.copyWithSize(itemStackLeft, transfer);
                    EntityItem entityItem = new EntityItem(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 1.0, (double)this.field_145849_e + 0.5, itemStackDrop);
                    this.field_145850_b.func_72838_d((Entity)entityItem);
                    qtyLeft -= transfer;
                }
            }
        }
        return overflow;
    }

    private static int addToInventory(ItemStack itemStackSource, IInventory inventory) {
        if (itemStackSource == null || itemStackSource.func_77973_b() == null) {
            return 0;
        }
        int qtyLeft = itemStackSource.field_77994_a;
        if (inventory != null) {
            int transfer;
            ItemStack itemStack;
            int i;
            for (i = 0; i < inventory.func_70302_i_(); ++i) {
                if (!inventory.func_94041_b(i, itemStackSource) || (itemStack = inventory.func_70301_a(i)) == null || !itemStack.func_77969_a(itemStackSource)) continue;
                transfer = Math.min(qtyLeft, itemStack.func_77976_d() - itemStack.field_77994_a);
                itemStack.field_77994_a += transfer;
                if ((qtyLeft -= transfer) > 0) continue;
                return 0;
            }
            for (i = 0; i < inventory.func_70302_i_(); ++i) {
                if (!inventory.func_94041_b(i, itemStackSource) || (itemStack = inventory.func_70301_a(i)) != null) continue;
                transfer = Math.min(qtyLeft, itemStackSource.func_77976_d());
                ItemStack dest = Commons.copyWithSize(itemStackSource, transfer);
                inventory.func_70299_a(i, dest);
                if ((qtyLeft -= transfer) > 0) continue;
                return 0;
            }
        }
        return qtyLeft;
    }

    protected boolean isBlockBreakCanceled(UUID uuidPlayer, World world, int eventX, int eventY, int eventZ) {
        return CommonProxy.isBlockBreakCanceled(uuidPlayer, this.field_145851_c, this.field_145848_d, this.field_145849_e, world, eventX, eventY, eventZ);
    }

    protected boolean isBlockPlaceCanceled(UUID uuidPlayer, World world, int eventX, int eventY, int eventZ, Block block, int metadata) {
        return CommonProxy.isBlockPlaceCanceled(uuidPlayer, this.field_145851_c, this.field_145848_d, this.field_145849_e, world, eventX, eventY, eventZ, block, metadata);
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        if (tagCompound.func_74764_b("upgrades")) {
            NBTTagCompound nbtTagCompoundUpgrades = tagCompound.func_74775_l("upgrades");
            Set keys = nbtTagCompoundUpgrades.func_150296_c();
            for (String key : keys) {
                Object object = this.getUpgradeFromString(key);
                byte value = nbtTagCompoundUpgrades.func_74771_c(key);
                if (object == null) {
                    WarpDrive.logger.error("Found an unknown upgrade named '" + key + "' in " + this);
                    object = key;
                }
                this.installedUpgrades.put(object, Integer.valueOf(value));
            }
        }
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        if (!this.installedUpgrades.isEmpty()) {
            NBTTagCompound nbtTagCompoundUpgrades = new NBTTagCompound();
            for (Map.Entry<Object, Integer> entry : this.installedUpgrades.entrySet()) {
                String key = this.getUpgradeAsString(entry.getKey());
                nbtTagCompoundUpgrades.func_74774_a(key, (byte)entry.getValue().intValue());
            }
            tagCompound.func_74782_a("upgrades", (NBTBase)nbtTagCompoundUpgrades);
        }
    }

    public NBTTagCompound writeItemDropNBT(NBTTagCompound tagCompound) {
        this.func_145841_b(tagCompound);
        tagCompound.func_82580_o("x");
        tagCompound.func_82580_o("y");
        tagCompound.func_82580_o("z");
        return tagCompound;
    }

    protected String getUpgradeStatus() {
        String strUpgrades = this.getUpgradesAsString();
        if (strUpgrades.isEmpty()) {
            return StatCollector.func_74837_a((String)"warpdrive.upgrade.status_line.none", (Object[])new Object[]{strUpgrades});
        }
        return StatCollector.func_74837_a((String)"warpdrive.upgrade.status_line.valid", (Object[])new Object[]{strUpgrades});
    }

    protected String getStatusPrefix() {
        if (this.field_145850_b == null) {
            return "";
        }
        ItemStack itemStack = new ItemStack(Item.func_150898_a((Block)this.func_145838_q()), 1, this.func_145832_p());
        return StatCollector.func_74837_a((String)"warpdrive.guide.prefix", (Object[])new Object[]{StatCollector.func_74837_a((String)(itemStack.func_77977_a() + ".name"), (Object[])new Object[0])});
    }

    protected String getBeamFrequencyStatus(int beamFrequency) {
        if (beamFrequency == -1) {
            return StatCollector.func_74837_a((String)"warpdrive.beam_frequency.status_line.undefined", (Object[])new Object[0]);
        }
        if (beamFrequency < 0) {
            return StatCollector.func_74837_a((String)"warpdrive.beam_frequency.status_line.invalid", (Object[])new Object[]{beamFrequency});
        }
        return StatCollector.func_74837_a((String)"warpdrive.beam_frequency.status_line.valid", (Object[])new Object[]{beamFrequency});
    }

    protected String getVideoChannelStatus(int videoChannel) {
        if (videoChannel == -1) {
            return StatCollector.func_74837_a((String)"warpdrive.video_channel.status_line.undefined", (Object[])new Object[0]);
        }
        if (videoChannel < 0) {
            return StatCollector.func_74837_a((String)"warpdrive.video_channel.status_line.invalid", (Object[])new Object[]{videoChannel});
        }
        CameraRegistryItem camera = WarpDrive.cameras.getCameraByVideoChannel(this.field_145850_b, videoChannel);
        if (camera == null) {
            if (WarpDrive.isDev && (this instanceof TileEntityCamera || this instanceof TileEntityLaserCamera)) {
                WarpDrive.cameras.printRegistry(this.field_145850_b);
            }
            return StatCollector.func_74837_a((String)"warpdrive.video_channel.status_line.not_loaded", (Object[])new Object[]{videoChannel});
        }
        if (camera.isTileEntity(this)) {
            return StatCollector.func_74837_a((String)"warpdrive.video_channel.status_line.valid_camera", (Object[])new Object[]{videoChannel});
        }
        return StatCollector.func_74837_a((String)"warpdrive.video_channel.status_line.valid_monitor", (Object[])new Object[]{videoChannel, camera.position.field_151329_a, camera.position.field_151327_b, camera.position.field_151328_c});
    }

    public String getStatusHeader() {
        return "";
    }

    public String getStatus() {
        String message = this.getStatusPrefix() + this.getStatusHeader();
        if (this instanceof IBeamFrequency && (this.field_145850_b == null || !this.field_145850_b.field_72995_K)) {
            message = message + "\n" + this.getBeamFrequencyStatus(((IBeamFrequency)((Object)this)).getBeamFrequency());
        }
        if (this instanceof IVideoChannel && (this.field_145850_b == null || this.field_145850_b.field_72995_K)) {
            message = message + "\n" + this.getVideoChannelStatus(((IVideoChannel)((Object)this)).getVideoChannel());
        }
        if (this.isUpgradeable()) {
            return message + "\n" + this.getUpgradeStatus();
        }
        return message;
    }

    public String getStatusHeaderInPureText() {
        return Commons.removeFormatting(this.getStatusHeader());
    }

    public boolean isUpgradeable() {
        return !this.maxUpgrades.isEmpty();
    }

    public boolean hasUpgrade(Object upgrade) {
        return this.getUpgradeCount(upgrade) > 0;
    }

    private String getUpgradeAsString(Object object) {
        if (object instanceof Item) {
            return Item.field_150901_e.func_148750_c(object);
        }
        if (object instanceof Block) {
            return Block.field_149771_c.func_148750_c(object);
        }
        if (object instanceof ItemStack) {
            return Item.field_150901_e.func_148750_c((Object)((ItemStack)object).func_77973_b()) + ":" + ((ItemStack)object).func_77960_j();
        }
        return object.toString();
    }

    private Object getUpgradeFromString(String name) {
        for (Object object : this.maxUpgrades.keySet()) {
            if (!this.getUpgradeAsString(object).equals(name)) continue;
            return object;
        }
        return null;
    }

    public Object getFirstUpgradeOfType(Class clazz, Object defaultValue) {
        for (Object object : this.installedUpgrades.keySet()) {
            if (clazz == null || !clazz.isInstance(object)) continue;
            return object;
        }
        return defaultValue;
    }

    public Map<Object, Integer> getUpgradesOfType(Class clazz) {
        if (clazz == null) {
            return this.installedUpgrades;
        }
        HashMap<Object, Integer> mapResult = new HashMap<Object, Integer>(this.installedUpgrades.size());
        for (Map.Entry<Object, Integer> entry : this.installedUpgrades.entrySet()) {
            if (!clazz.isInstance(entry.getKey())) continue;
            mapResult.put(entry.getKey(), entry.getValue());
        }
        return mapResult;
    }

    public int getValidUpgradeCount(Object upgrade) {
        return Math.min(this.getUpgradeMaxCount(upgrade), this.getUpgradeCount(upgrade));
    }

    public int getUpgradeCount(Object upgrade) {
        Integer value = this.installedUpgrades.get(upgrade);
        return value == null ? 0 : value;
    }

    public int getUpgradeMaxCount(Object upgrade) {
        Integer value = this.maxUpgrades.get(upgrade);
        return value == null ? 0 : value;
    }

    protected String getUpgradesAsString() {
        StringBuilder message = new StringBuilder();
        for (Map.Entry<Object, Integer> entry : this.installedUpgrades.entrySet()) {
            if (message.length() > 0) {
                message.append(", ");
            }
            Object key = entry.getKey();
            String keyName = key.toString();
            if (key instanceof Item) {
                keyName = ((Item)key).func_77658_a();
            } else if (key instanceof Block) {
                keyName = ((Block)key).func_149739_a();
            }
            if (entry.getValue() == 1) {
                message.append(keyName);
                continue;
            }
            message.append(entry.getValue()).append(" x ").append(keyName);
        }
        return message.toString();
    }

    protected void setUpgradeMaxCount(Object upgrade, int value) {
        this.maxUpgrades.put(upgrade, value);
    }

    public boolean canUpgrade(Object upgrade) {
        return this.getUpgradeMaxCount(upgrade) >= this.getUpgradeCount(upgrade) + 1;
    }

    public boolean mountUpgrade(Object upgrade) {
        if (this.canUpgrade(upgrade)) {
            this.installedUpgrades.put(upgrade, this.getUpgradeCount(upgrade) + 1);
            this.func_70296_d();
            return true;
        }
        return false;
    }

    public boolean dismountUpgrade(Object upgrade) {
        int count = this.getUpgradeCount(upgrade);
        if (count > 1) {
            this.installedUpgrades.put(upgrade, count - 1);
            this.func_70296_d();
            return true;
        }
        if (count > 0) {
            this.installedUpgrades.remove(upgrade);
            this.func_70296_d();
            return true;
        }
        return false;
    }

    public String toString() {
        return String.format("%s @ %s (%d %d %d)", this.getClass().getSimpleName(), this.field_145850_b == null ? "~NULL~" : this.field_145850_b.field_73011_w.func_80007_l(), this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }
}

